/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.criteria.json.duration;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.criteria.duration.AbstractTemporaryDurationCriterion;
import com.powsybl.iidm.criteria.duration.IntervalTemporaryDurationCriterion;
import com.powsybl.iidm.criteria.duration.LimitDurationCriterion;
import com.powsybl.iidm.criteria.json.duration.LimitDurationCriterionSerDeUtil;
import com.powsybl.iidm.criteria.json.util.DeserializerUtils;
import java.io.IOException;

public class IntervalTemporaryDurationCriterionDeserializer
extends StdDeserializer<IntervalTemporaryDurationCriterion> {
    public static final String MISSING_BOUND_ATTRIBUTE_MESSAGE = "Missing \"%s\" attribute for \"INTERVAL\" temporary limit duration criterion with non-null \"%s\" attribute.";

    public IntervalTemporaryDurationCriterionDeserializer() {
        super(IntervalTemporaryDurationCriterion.class);
    }

    public IntervalTemporaryDurationCriterion deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        ParsingContext context = new ParsingContext();
        JsonUtil.parsePolymorphicObject((JsonParser)parser, name -> {
            switch (name) {
                case "type": {
                    LimitDurationCriterionSerDeUtil.readAndCheckType(LimitDurationCriterion.LimitDurationType.TEMPORARY, AbstractTemporaryDurationCriterion.TemporaryDurationCriterionType.INTERVAL, parser);
                    return true;
                }
                case "version": {
                    parser.nextTextValue();
                    return true;
                }
                case "lowBound": {
                    parser.nextToken();
                    context.lowBound = parser.getValueAsInt();
                    return true;
                }
                case "lowClosed": {
                    parser.nextToken();
                    context.lowClosed = parser.getValueAsBoolean();
                    return true;
                }
                case "highBound": {
                    parser.nextToken();
                    context.highBound = parser.getValueAsInt();
                    return true;
                }
                case "highClosed": {
                    parser.nextToken();
                    context.highClosed = parser.getValueAsBoolean();
                    return true;
                }
            }
            return false;
        });
        IntervalTemporaryDurationCriterion.Builder builder = IntervalTemporaryDurationCriterion.builder();
        if (DeserializerUtils.checkBoundData(context.lowBound, context.lowClosed, "lowBound", "lowClosed", MISSING_BOUND_ATTRIBUTE_MESSAGE)) {
            builder.setLowBound(context.lowBound, context.lowClosed);
        }
        if (DeserializerUtils.checkBoundData(context.highBound, context.highClosed, "highBound", "highClosed", MISSING_BOUND_ATTRIBUTE_MESSAGE)) {
            builder.setHighBound(context.highBound, context.highClosed);
        }
        return builder.build();
    }

    private static class ParsingContext {
        Integer lowBound;
        Boolean lowClosed;
        Integer highBound;
        Boolean highClosed;

        private ParsingContext() {
        }
    }
}

