/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.criteria;

import com.powsybl.iidm.criteria.AbstractNetworkElementEquipmentCriterion;
import com.powsybl.iidm.criteria.Criterion;
import com.powsybl.iidm.criteria.NetworkElementIdListCriterion;
import com.powsybl.iidm.criteria.translation.NetworkElement;
import com.powsybl.iidm.network.ThreeSides;

public class NetworkElementVisitor {
    private final NetworkElement networkElement;
    private final ThreeSides side;

    public NetworkElementVisitor(NetworkElement networkElement) {
        this(networkElement, null);
    }

    public NetworkElementVisitor(NetworkElement networkElement, ThreeSides side) {
        this.networkElement = networkElement;
        this.side = side;
    }

    public boolean visit(AbstractNetworkElementEquipmentCriterion c) {
        return this.networkElement.isValidFor(c.getNetworkElementCriterionType()) && this.doRespectCriterion(c.getCountryCriterion()) && this.doRespectCriterion(c.getNominalVoltageCriterion());
    }

    public boolean visit(NetworkElementIdListCriterion c) {
        return c.getNetworkElementIds().contains(this.networkElement.getId());
    }

    private boolean doRespectCriterion(Criterion criterion) {
        return criterion == null || criterion.filter(this.networkElement, this.side);
    }
}

