/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.criteria;

import com.google.common.collect.ImmutableList;
import com.powsybl.iidm.criteria.Criterion;
import com.powsybl.iidm.criteria.translation.NetworkElement;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Terminal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TwoCountriesCriterion
implements Criterion {
    private final List<Country> countries1;
    private final List<Country> countries2;

    public TwoCountriesCriterion(List<Country> countries) {
        this(countries, Collections.emptyList());
    }

    public TwoCountriesCriterion(List<Country> countries1, List<Country> countries2) {
        Objects.requireNonNull(countries1);
        Objects.requireNonNull(countries2);
        this.countries1 = ImmutableList.copyOf(countries1);
        this.countries2 = ImmutableList.copyOf(countries2);
    }

    @Override
    public Criterion.CriterionType getType() {
        return Criterion.CriterionType.TWO_COUNTRY;
    }

    @Override
    public boolean filter(Identifiable<?> identifiable, IdentifiableType type) {
        List<Country> countries = TwoCountriesCriterion.getCountries(identifiable, type);
        return countries.size() == 2 && this.filterWithCountries(countries.get(0), countries.get(1));
    }

    protected static List<Country> getCountries(Identifiable<?> identifiable, IdentifiableType type) {
        return switch (type) {
            case IdentifiableType.LINE, IdentifiableType.TIE_LINE -> TwoCountriesCriterion.getCountries(((Branch)identifiable).getTerminal1(), ((Branch)identifiable).getTerminal2());
            case IdentifiableType.HVDC_LINE -> TwoCountriesCriterion.getCountries(((HvdcLine)identifiable).getConverterStation1().getTerminal(), ((HvdcLine)identifiable).getConverterStation2().getTerminal());
            default -> List.of();
        };
    }

    @Override
    public boolean filter(NetworkElement networkElement) {
        Country countrySide1 = networkElement.getCountry1().orElse(null);
        Country countrySide2 = networkElement.getCountry2().orElse(null);
        return this.filterWithCountries(countrySide1, countrySide2);
    }

    private boolean filterWithCountries(Country countrySide1, Country countrySide2) {
        if (countrySide1 == null && !this.countries1.isEmpty() || countrySide2 == null && !this.countries2.isEmpty()) {
            return false;
        }
        return this.countries1.isEmpty() && this.countries2.isEmpty() || this.countries1.isEmpty() && (this.countries2.contains(countrySide2) || this.countries2.contains(countrySide1)) || this.countries2.isEmpty() && (this.countries1.contains(countrySide2) || this.countries1.contains(countrySide1)) || this.countries1.contains(countrySide1) && this.countries2.contains(countrySide2) || this.countries1.contains(countrySide2) && this.countries2.contains(countrySide1);
    }

    private static List<Country> getCountries(Terminal terminal1, Terminal terminal2) {
        return Arrays.asList(TwoCountriesCriterion.getCountry(terminal1), TwoCountriesCriterion.getCountry(terminal2));
    }

    private static Country getCountry(Terminal terminal) {
        return terminal.getVoltageLevel().getSubstation().flatMap(Substation::getCountry).orElse(null);
    }

    public List<Country> getCountries1() {
        return this.countries1;
    }

    public List<Country> getCountries2() {
        return this.countries2;
    }
}

