/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.criteria.duration;

import com.powsybl.iidm.criteria.duration.AbstractTemporaryDurationCriterion;
import java.util.Optional;
import org.apache.commons.lang3.IntegerRange;

public final class IntervalTemporaryDurationCriterion
extends AbstractTemporaryDurationCriterion {
    private final Integer lowBound;
    private final Integer highBound;
    private final boolean lowClosed;
    private final boolean highClosed;

    private IntervalTemporaryDurationCriterion(Integer lowBound, Integer highBound, boolean lowClosed, boolean highClosed) {
        this.lowBound = lowBound;
        this.highBound = highBound;
        this.lowClosed = lowClosed;
        this.highClosed = highClosed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static IntervalTemporaryDurationCriterion greaterThan(int value, boolean closed) {
        return IntervalTemporaryDurationCriterion.builder().setLowBound(value, closed).build();
    }

    public static IntervalTemporaryDurationCriterion lowerThan(int value, boolean closed) {
        return IntervalTemporaryDurationCriterion.builder().setHighBound(value, closed).build();
    }

    public static IntervalTemporaryDurationCriterion between(int lowBound, int highBound, boolean lowClosed, boolean highClosed) {
        return IntervalTemporaryDurationCriterion.builder().setLowBound(lowBound, lowClosed).setHighBound(highBound, highClosed).build();
    }

    @Override
    public AbstractTemporaryDurationCriterion.TemporaryDurationCriterionType getComparisonType() {
        return AbstractTemporaryDurationCriterion.TemporaryDurationCriterionType.INTERVAL;
    }

    @Override
    public boolean filter(int acceptableDuration) {
        if (acceptableDuration < 0) {
            return false;
        }
        boolean lowBoundOk = this.lowBound == null || acceptableDuration > this.lowBound || this.lowClosed && acceptableDuration == this.lowBound;
        boolean highBoundOk = this.highBound == null || acceptableDuration < this.highBound || this.highClosed && acceptableDuration == this.highBound;
        return lowBoundOk && highBoundOk;
    }

    public Optional<Integer> getLowBound() {
        return Optional.ofNullable(this.lowBound);
    }

    public Optional<Integer> getHighBound() {
        return Optional.ofNullable(this.highBound);
    }

    public boolean isLowClosed() {
        return this.lowClosed;
    }

    public boolean isHighClosed() {
        return this.highClosed;
    }

    public IntegerRange asRange() {
        int min = 0;
        if (this.lowBound != null) {
            min = this.lowBound;
            if (!this.lowClosed) {
                ++min;
            }
        }
        int max = Integer.MAX_VALUE;
        if (this.highBound != null) {
            max = this.highBound;
            if (!this.highClosed) {
                --max;
            }
        }
        return IntegerRange.of((int)min, (int)max);
    }

    public static class Builder {
        private Integer lowBound = null;
        private Integer highBound = null;
        private boolean lowClosed = true;
        private boolean highClosed = true;

        public Builder setLowBound(int value, boolean closed) {
            this.checkValue(value);
            this.checkBounds(value, this.highBound, closed, this.highClosed);
            this.lowBound = value;
            this.lowClosed = closed;
            return this;
        }

        public Builder setHighBound(int value, boolean closed) {
            this.checkValue(value);
            this.checkBounds(this.lowBound, value, this.lowClosed, closed);
            this.highBound = value;
            this.highClosed = closed;
            return this;
        }

        private void checkValue(int value) {
            if (value < 0) {
                throw new IllegalArgumentException("Invalid bound value (must be >= 0).");
            }
        }

        private void checkBounds(Integer low, Integer high, boolean closedLow, boolean closedHigh) {
            int h;
            if (low != null && high != null && low > high) {
                throw new IllegalArgumentException("Invalid interval bounds values (low must be <= high).");
            }
            int l = low != null ? low : 0;
            int n = h = high != null ? high : Integer.MAX_VALUE;
            if (!(l != h || closedLow && closedHigh)) {
                throw new IllegalArgumentException("Invalid interval: it should not be empty");
            }
        }

        public IntervalTemporaryDurationCriterion build() {
            if (this.lowBound == null && this.highBound == null) {
                throw new IllegalArgumentException("Invalid interval criterion: at least one bound must be defined.");
            }
            return new IntervalTemporaryDurationCriterion(this.lowBound, this.highBound, this.lowClosed, this.highClosed);
        }
    }
}

