/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.criteria.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.iidm.criteria.AtLeastOneCountryCriterion;
import com.powsybl.iidm.criteria.AtLeastOneNominalVoltageCriterion;
import com.powsybl.iidm.criteria.Criterion;
import com.powsybl.iidm.criteria.PropertyCriterion;
import com.powsybl.iidm.criteria.RegexCriterion;
import com.powsybl.iidm.criteria.SingleCountryCriterion;
import com.powsybl.iidm.criteria.SingleNominalVoltageCriterion;
import com.powsybl.iidm.criteria.ThreeNominalVoltageCriterion;
import com.powsybl.iidm.criteria.TwoCountriesCriterion;
import com.powsybl.iidm.criteria.TwoNominalVoltageCriterion;
import com.powsybl.iidm.criteria.VoltageInterval;
import java.io.IOException;
import java.util.Optional;
import java.util.stream.Collectors;

public class CriterionSerializer
extends StdSerializer<Criterion> {
    public CriterionSerializer() {
        super(Criterion.class);
    }

    public void serialize(Criterion criterion, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", criterion.getType().toString());
        switch (criterion.getType()) {
            case AT_LEAST_ONE_COUNTRY: {
                serializerProvider.defaultSerializeField("countries", ((AtLeastOneCountryCriterion)criterion).getCountries().stream().map(Enum::toString).collect(Collectors.toList()), jsonGenerator);
                break;
            }
            case SINGLE_COUNTRY: {
                serializerProvider.defaultSerializeField("countries", ((SingleCountryCriterion)criterion).getCountries().stream().map(Enum::toString).collect(Collectors.toList()), jsonGenerator);
                break;
            }
            case TWO_COUNTRY: {
                serializerProvider.defaultSerializeField("countries1", ((TwoCountriesCriterion)criterion).getCountries1().stream().map(Enum::toString).collect(Collectors.toList()), jsonGenerator);
                serializerProvider.defaultSerializeField("countries2", ((TwoCountriesCriterion)criterion).getCountries2().stream().map(Enum::toString).collect(Collectors.toList()), jsonGenerator);
                break;
            }
            case AT_LEAST_ONE_NOMINAL_VOLTAGE: {
                AtLeastOneNominalVoltageCriterion atLeastOneNominalVoltageCriterion = (AtLeastOneNominalVoltageCriterion)criterion;
                serializerProvider.defaultSerializeField("voltageInterval", (Object)atLeastOneNominalVoltageCriterion.getVoltageInterval(), jsonGenerator);
                break;
            }
            case SINGLE_NOMINAL_VOLTAGE: {
                SingleNominalVoltageCriterion singleNominalVoltageCriterion = (SingleNominalVoltageCriterion)criterion;
                serializerProvider.defaultSerializeField("voltageInterval", (Object)singleNominalVoltageCriterion.getVoltageInterval(), jsonGenerator);
                break;
            }
            case TWO_NOMINAL_VOLTAGE: {
                CriterionSerializer.serializeTwoWindingsVoltageCriterion((TwoNominalVoltageCriterion)criterion, jsonGenerator, serializerProvider);
                break;
            }
            case THREE_NOMINAL_VOLTAGE: {
                CriterionSerializer.serializeThreeNominalVoltageCriterion((ThreeNominalVoltageCriterion)criterion, jsonGenerator, serializerProvider);
                break;
            }
            case PROPERTY: {
                jsonGenerator.writeStringField("propertyKey", ((PropertyCriterion)criterion).getPropertyKey());
                serializerProvider.defaultSerializeField("propertyValue", ((PropertyCriterion)criterion).getPropertyValues(), jsonGenerator);
                jsonGenerator.writeStringField("equipmentToCheck", ((PropertyCriterion)criterion).getEquipmentToCheck().toString());
                if (((PropertyCriterion)criterion).getSideToCheck() == null) break;
                jsonGenerator.writeStringField("sideToCheck", ((PropertyCriterion)criterion).getSideToCheck().toString());
                break;
            }
            case REGEX: {
                jsonGenerator.writeStringField("regex", ((RegexCriterion)criterion).getRegex());
                break;
            }
            default: {
                throw new IllegalArgumentException("type " + criterion.getType().toString() + " not known");
            }
        }
        jsonGenerator.writeEndObject();
    }

    private static void serializeTwoWindingsVoltageCriterion(TwoNominalVoltageCriterion twoNominalVoltageCriterion, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Optional<VoltageInterval> optInterval = twoNominalVoltageCriterion.getVoltageInterval1();
        if (optInterval.isPresent()) {
            serializerProvider.defaultSerializeField("voltageInterval1", (Object)optInterval.get(), jsonGenerator);
        }
        if ((optInterval = twoNominalVoltageCriterion.getVoltageInterval2()).isPresent()) {
            serializerProvider.defaultSerializeField("voltageInterval2", (Object)optInterval.get(), jsonGenerator);
        }
    }

    private static void serializeThreeNominalVoltageCriterion(ThreeNominalVoltageCriterion threeNominalVoltageCriterion, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Optional<VoltageInterval> optInterval = threeNominalVoltageCriterion.getVoltageInterval1();
        if (optInterval.isPresent()) {
            serializerProvider.defaultSerializeField("voltageInterval1", (Object)optInterval.get(), jsonGenerator);
        }
        if ((optInterval = threeNominalVoltageCriterion.getVoltageInterval2()).isPresent()) {
            serializerProvider.defaultSerializeField("voltageInterval2", (Object)optInterval.get(), jsonGenerator);
        }
        if ((optInterval = threeNominalVoltageCriterion.getVoltageInterval3()).isPresent()) {
            serializerProvider.defaultSerializeField("voltageInterval3", (Object)optInterval.get(), jsonGenerator);
        }
    }
}

