/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.criteria.translation;

import com.powsybl.iidm.criteria.NetworkElementCriterion;
import com.powsybl.iidm.criteria.translation.NetworkElement;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import java.util.List;
import java.util.Optional;

public class DefaultNetworkElementAdapter
implements NetworkElement {
    private static final List<IdentifiableType> EVERY_SUPPORTED_TYPES = List.of(IdentifiableType.LINE, IdentifiableType.TIE_LINE, IdentifiableType.HVDC_LINE, IdentifiableType.TWO_WINDINGS_TRANSFORMER, IdentifiableType.THREE_WINDINGS_TRANSFORMER, IdentifiableType.DANGLING_LINE, IdentifiableType.GENERATOR, IdentifiableType.LOAD, IdentifiableType.BATTERY, IdentifiableType.SHUNT_COMPENSATOR, IdentifiableType.STATIC_VAR_COMPENSATOR, IdentifiableType.BUSBAR_SECTION, IdentifiableType.HVDC_CONVERTER_STATION);
    private final Identifiable<?> identifiable;

    public DefaultNetworkElementAdapter(Identifiable<?> identifiable) {
        this.identifiable = identifiable;
    }

    @Override
    public String getId() {
        return this.identifiable.getId();
    }

    @Override
    public Optional<Country> getCountry1() {
        return this.getCountry(ThreeSides.ONE);
    }

    @Override
    public Optional<Country> getCountry2() {
        return this.getCountry(ThreeSides.TWO);
    }

    @Override
    public Optional<Country> getCountry3() {
        return this.getCountry(ThreeSides.THREE);
    }

    @Override
    public Optional<Country> getCountry() {
        return this.getCountry1();
    }

    @Override
    public Optional<Country> getCountry(ThreeSides side) {
        return switch (this.identifiable.getType()) {
            case IdentifiableType.LINE, IdentifiableType.TIE_LINE -> {
                if (side != ThreeSides.THREE) {
                    yield this.getCountryFromTerminal(((Branch)this.identifiable).getTerminal(side.toTwoSides()));
                }
                yield Optional.empty();
            }
            case IdentifiableType.HVDC_LINE -> {
                if (side != ThreeSides.THREE) {
                    yield this.getCountryFromTerminal(((HvdcLine)this.identifiable).getConverterStation(side.toTwoSides()).getTerminal());
                }
                yield Optional.empty();
            }
            case IdentifiableType.DANGLING_LINE, IdentifiableType.GENERATOR, IdentifiableType.LOAD, IdentifiableType.BATTERY, IdentifiableType.SHUNT_COMPENSATOR, IdentifiableType.STATIC_VAR_COMPENSATOR, IdentifiableType.BUSBAR_SECTION, IdentifiableType.HVDC_CONVERTER_STATION -> {
                if (side != ThreeSides.ONE) {
                    yield Optional.empty();
                }
                yield this.getCountryFromTerminal(((Injection)this.identifiable).getTerminal());
            }
            case IdentifiableType.TWO_WINDINGS_TRANSFORMER -> ((TwoWindingsTransformer)this.identifiable).getSubstation().map(Substation::getNullableCountry);
            case IdentifiableType.THREE_WINDINGS_TRANSFORMER -> ((ThreeWindingsTransformer)this.identifiable).getSubstation().map(Substation::getNullableCountry);
            default -> Optional.empty();
        };
    }

    private Optional<Country> getCountryFromTerminal(Terminal terminal) {
        Optional substation = terminal.getVoltageLevel().getSubstation();
        return substation.map(Substation::getNullableCountry);
    }

    @Override
    public Optional<Double> getNominalVoltage1() {
        return this.getNominalVoltage(ThreeSides.ONE);
    }

    @Override
    public Optional<Double> getNominalVoltage2() {
        return this.getNominalVoltage(ThreeSides.TWO);
    }

    @Override
    public Optional<Double> getNominalVoltage3() {
        return this.getNominalVoltage(ThreeSides.THREE);
    }

    @Override
    public Optional<Double> getNominalVoltage() {
        return this.getNominalVoltage1();
    }

    @Override
    public Optional<Double> getNominalVoltage(ThreeSides side) {
        return switch (this.identifiable.getType()) {
            case IdentifiableType.DANGLING_LINE, IdentifiableType.GENERATOR, IdentifiableType.LOAD, IdentifiableType.BATTERY, IdentifiableType.SHUNT_COMPENSATOR, IdentifiableType.STATIC_VAR_COMPENSATOR, IdentifiableType.BUSBAR_SECTION, IdentifiableType.HVDC_CONVERTER_STATION -> {
                if (side != ThreeSides.ONE) {
                    yield Optional.empty();
                }
                yield Optional.of(((Injection)this.identifiable).getTerminal().getVoltageLevel().getNominalV());
            }
            case IdentifiableType.LINE, IdentifiableType.TIE_LINE, IdentifiableType.TWO_WINDINGS_TRANSFORMER -> {
                if (side == ThreeSides.THREE) {
                    yield Optional.empty();
                }
                yield Optional.of(((Branch)this.identifiable).getTerminal(side.toTwoSides()).getVoltageLevel().getNominalV());
            }
            case IdentifiableType.HVDC_LINE -> {
                if (side == ThreeSides.THREE) {
                    yield Optional.empty();
                }
                yield Optional.of(((HvdcLine)this.identifiable).getConverterStation(side.toTwoSides()).getTerminal().getVoltageLevel().getNominalV());
            }
            case IdentifiableType.THREE_WINDINGS_TRANSFORMER -> Optional.of(((ThreeWindingsTransformer)this.identifiable).getTerminal(side).getVoltageLevel().getNominalV());
            default -> Optional.empty();
        };
    }

    @Override
    public boolean isValidFor(NetworkElementCriterion.NetworkElementCriterionType type) {
        return type == NetworkElementCriterion.NetworkElementCriterionType.IDENTIFIER || type == NetworkElementCriterion.NetworkElementCriterionType.LINE && this.identifiable.getType() == IdentifiableType.LINE || type == NetworkElementCriterion.NetworkElementCriterionType.TIE_LINE && this.identifiable.getType() == IdentifiableType.TIE_LINE || type == NetworkElementCriterion.NetworkElementCriterionType.DANGLING_LINE && this.identifiable.getType() == IdentifiableType.DANGLING_LINE || type == NetworkElementCriterion.NetworkElementCriterionType.TWO_WINDINGS_TRANSFORMER && this.identifiable.getType() == IdentifiableType.TWO_WINDINGS_TRANSFORMER || type == NetworkElementCriterion.NetworkElementCriterionType.THREE_WINDINGS_TRANSFORMER && this.identifiable.getType() == IdentifiableType.THREE_WINDINGS_TRANSFORMER || type == NetworkElementCriterion.NetworkElementCriterionType.IDENTIFIABLE && EVERY_SUPPORTED_TYPES.contains(this.identifiable.getType());
    }

    public Identifiable<?> getIdentifiable() {
        return this.identifiable;
    }
}

