/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.criteria;

import com.google.common.collect.ImmutableList;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.criteria.Criterion;
import com.powsybl.iidm.network.AcDcConverter;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.List;
import java.util.Objects;

public class PropertyCriterion
implements Criterion {
    private final String propertyKey;
    private final List<String> propertyValues;
    private final EquipmentToCheck equipmentToCheck;
    private final SideToCheck sideToCheck;

    public PropertyCriterion(String propertyKey, List<String> propertyValues, EquipmentToCheck equipmentToCheck) {
        this(propertyKey, propertyValues, equipmentToCheck, null);
    }

    public PropertyCriterion(String propertyKey, List<String> propertyValues, EquipmentToCheck equipmentToCheck, SideToCheck sideToCheck) {
        this.propertyKey = Objects.requireNonNull(propertyKey);
        this.propertyValues = ImmutableList.copyOf(propertyValues);
        this.equipmentToCheck = Objects.requireNonNull(equipmentToCheck);
        this.sideToCheck = sideToCheck;
    }

    @Override
    public Criterion.CriterionType getType() {
        return Criterion.CriterionType.PROPERTY;
    }

    @Override
    public boolean filter(Identifiable<?> identifiable, IdentifiableType type) {
        return switch (this.equipmentToCheck) {
            default -> throw new IncompatibleClassChangeError();
            case EquipmentToCheck.SELF -> {
                if (identifiable.hasProperty(this.propertyKey) && this.propertyValues.contains(identifiable.getProperty(this.propertyKey))) {
                    yield true;
                }
                yield false;
            }
            case EquipmentToCheck.VOLTAGE_LEVEL, EquipmentToCheck.SUBSTATION -> this.filterEquipment(identifiable, type);
        };
    }

    private boolean filterIdentifiable(Identifiable<?> identifiable) {
        return identifiable.hasProperty(this.propertyKey) && this.propertyValues.contains(identifiable.getProperty(this.propertyKey));
    }

    private boolean filterEquipment(Identifiable<?> identifiable, IdentifiableType type) {
        return switch (type) {
            case IdentifiableType.STATIC_VAR_COMPENSATOR, IdentifiableType.SHUNT_COMPENSATOR, IdentifiableType.BUSBAR_SECTION, IdentifiableType.GENERATOR, IdentifiableType.DANGLING_LINE, IdentifiableType.LOAD, IdentifiableType.BATTERY, IdentifiableType.HVDC_CONVERTER_STATION -> this.filterSubstationOrVoltageLevel(((Injection)identifiable).getTerminal().getVoltageLevel());
            case IdentifiableType.SWITCH -> this.filterSubstationOrVoltageLevel(((Switch)identifiable).getVoltageLevel());
            case IdentifiableType.TWO_WINDINGS_TRANSFORMER, IdentifiableType.LINE -> this.filterBranch(((Branch)identifiable).getTerminal1().getVoltageLevel(), ((Branch)identifiable).getTerminal2().getVoltageLevel());
            case IdentifiableType.HVDC_LINE -> this.filterBranch(((HvdcLine)identifiable).getConverterStation1().getTerminal().getVoltageLevel(), ((HvdcLine)identifiable).getConverterStation2().getTerminal().getVoltageLevel());
            case IdentifiableType.THREE_WINDINGS_TRANSFORMER -> this.filterThreeWindingsTransformer((ThreeWindingsTransformer)identifiable);
            case IdentifiableType.LINE_COMMUTATED_CONVERTER, IdentifiableType.VOLTAGE_SOURCE_CONVERTER -> this.filterSubstationOrVoltageLevel(((AcDcConverter)identifiable).getTerminal1().getVoltageLevel());
            default -> throw new PowsyblException(String.format("type %s has no implementation for ContingencyElement", type));
        };
    }

    private boolean filterBranch(VoltageLevel voltageLevel1, VoltageLevel voltageLevel2) {
        return switch (this.sideToCheck) {
            case SideToCheck.ONE -> {
                if (this.filterSubstationOrVoltageLevel(voltageLevel1) || this.filterSubstationOrVoltageLevel(voltageLevel2)) {
                    yield true;
                }
                yield false;
            }
            case SideToCheck.BOTH -> {
                if (this.filterSubstationOrVoltageLevel(voltageLevel1) && this.filterSubstationOrVoltageLevel(voltageLevel2)) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalArgumentException("only ONE or BOTH sides can be checked when filtering properties on branches");
        };
    }

    private boolean filterThreeWindingsTransformer(ThreeWindingsTransformer threeWindingsTransformer) {
        VoltageLevel voltageLevel1 = threeWindingsTransformer.getLeg1().getTerminal().getVoltageLevel();
        VoltageLevel voltageLevel2 = threeWindingsTransformer.getLeg2().getTerminal().getVoltageLevel();
        VoltageLevel voltageLevel3 = threeWindingsTransformer.getLeg3().getTerminal().getVoltageLevel();
        if (this.sideToCheck == null) {
            throw new IllegalArgumentException("enum to check side can not be null for threeWindingsTransformer to check their voltage level");
        }
        return switch (this.sideToCheck) {
            case SideToCheck.ONE -> {
                if (this.filterSubstationOrVoltageLevel(voltageLevel1) || this.filterSubstationOrVoltageLevel(voltageLevel2) || this.filterSubstationOrVoltageLevel(voltageLevel3)) {
                    yield true;
                }
                yield false;
            }
            case SideToCheck.BOTH -> {
                if (this.filterSubstationOrVoltageLevel(voltageLevel1) && this.filterSubstationOrVoltageLevel(voltageLevel2) || this.filterSubstationOrVoltageLevel(voltageLevel1) && this.filterSubstationOrVoltageLevel(voltageLevel3) || this.filterSubstationOrVoltageLevel(voltageLevel2) && this.filterSubstationOrVoltageLevel(voltageLevel3)) {
                    yield true;
                }
                yield false;
            }
            case SideToCheck.ALL_THREE -> {
                if (this.filterSubstationOrVoltageLevel(voltageLevel1) && this.filterSubstationOrVoltageLevel(voltageLevel2) && this.filterSubstationOrVoltageLevel(voltageLevel3)) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalArgumentException("enum to check side must be ONE, BOTH or ALL_THREE for threeWindingsTransformer");
        };
    }

    private boolean filterSubstationOrVoltageLevel(VoltageLevel voltageLevel) {
        if (this.equipmentToCheck == EquipmentToCheck.VOLTAGE_LEVEL) {
            return this.filterIdentifiable((Identifiable<?>)voltageLevel);
        }
        Substation substation = voltageLevel.getNullableSubstation();
        return substation != null && this.filterIdentifiable((Identifiable<?>)substation);
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public List<String> getPropertyValues() {
        return this.propertyValues;
    }

    public EquipmentToCheck getEquipmentToCheck() {
        return this.equipmentToCheck;
    }

    public SideToCheck getSideToCheck() {
        return this.sideToCheck;
    }

    public static enum EquipmentToCheck {
        SELF,
        VOLTAGE_LEVEL,
        SUBSTATION;

    }

    public static enum SideToCheck {
        ONE,
        BOTH,
        ALL_THREE;

    }
}

