/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.criteria;

import com.google.common.collect.ImmutableList;
import com.powsybl.iidm.criteria.Criterion;
import com.powsybl.iidm.criteria.translation.NetworkElement;
import com.powsybl.iidm.network.AcDcConverter;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.List;
import java.util.Objects;

public class SingleCountryCriterion
implements Criterion {
    private final List<Country> countries;

    public SingleCountryCriterion(List<Country> countries) {
        Objects.requireNonNull(countries);
        this.countries = ImmutableList.copyOf(countries);
    }

    @Override
    public Criterion.CriterionType getType() {
        return Criterion.CriterionType.SINGLE_COUNTRY;
    }

    @Override
    public boolean filter(Identifiable<?> identifiable, IdentifiableType type) {
        Country country = SingleCountryCriterion.getCountry(identifiable, type);
        return this.filterWithCountry(country);
    }

    @Override
    public boolean filter(NetworkElement networkElement) {
        return this.filterWithCountry(networkElement.getCountry().orElse(null));
    }

    public List<Country> getCountries() {
        return this.countries;
    }

    protected static Country getCountry(Identifiable<?> identifiable, IdentifiableType type) {
        return switch (type) {
            case IdentifiableType.DANGLING_LINE, IdentifiableType.GENERATOR, IdentifiableType.LOAD, IdentifiableType.SHUNT_COMPENSATOR, IdentifiableType.STATIC_VAR_COMPENSATOR, IdentifiableType.BUSBAR_SECTION, IdentifiableType.BATTERY, IdentifiableType.HVDC_CONVERTER_STATION -> SingleCountryCriterion.getCountry(((Injection)identifiable).getTerminal().getVoltageLevel());
            case IdentifiableType.SWITCH -> SingleCountryCriterion.getCountry(((Switch)identifiable).getVoltageLevel());
            case IdentifiableType.TWO_WINDINGS_TRANSFORMER -> SingleCountryCriterion.getCountry(((TwoWindingsTransformer)identifiable).getNullableSubstation());
            case IdentifiableType.THREE_WINDINGS_TRANSFORMER -> SingleCountryCriterion.getCountry(((ThreeWindingsTransformer)identifiable).getNullableSubstation());
            case IdentifiableType.LINE_COMMUTATED_CONVERTER, IdentifiableType.VOLTAGE_SOURCE_CONVERTER -> SingleCountryCriterion.getCountry(((AcDcConverter)identifiable).getTerminal1().getVoltageLevel());
            default -> null;
        };
    }

    private static Country getCountry(Substation substation) {
        if (substation == null) {
            return null;
        }
        return substation.getCountry().orElse(null);
    }

    private static Country getCountry(VoltageLevel voltageLevel) {
        return voltageLevel.getSubstation().map(SingleCountryCriterion::getCountry).orElse(null);
    }

    private boolean filterWithCountry(Country country) {
        if (country == null && !this.countries.isEmpty()) {
            return false;
        }
        return this.countries.isEmpty() || this.countries.contains(country);
    }
}

