/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.criteria;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.powsybl.iidm.criteria.Criterion;
import com.powsybl.iidm.criteria.VoltageInterval;
import com.powsybl.iidm.criteria.translation.NetworkElement;
import com.powsybl.iidm.criteria.util.NominalVoltageUtils;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public class ThreeNominalVoltageCriterion
implements Criterion {
    private final VoltageInterval voltageInterval1;
    private final VoltageInterval voltageInterval2;
    private final VoltageInterval voltageInterval3;
    @JsonIgnore
    private final List<VoltageInterval> voltageIntervals = new ArrayList<VoltageInterval>();

    public ThreeNominalVoltageCriterion(VoltageInterval voltageInterval1, VoltageInterval voltageInterval2, VoltageInterval voltageInterval3) {
        this.voltageInterval1 = voltageInterval1;
        this.voltageInterval2 = voltageInterval2;
        this.voltageInterval3 = voltageInterval3;
        if (this.voltageInterval1 != null) {
            this.voltageIntervals.add(voltageInterval1);
        }
        if (this.voltageInterval2 != null) {
            this.voltageIntervals.add(voltageInterval2);
        }
        if (this.voltageInterval3 != null) {
            this.voltageIntervals.add(voltageInterval3);
        }
    }

    @Override
    public Criterion.CriterionType getType() {
        return Criterion.CriterionType.THREE_NOMINAL_VOLTAGE;
    }

    @Override
    public boolean filter(Identifiable<?> identifiable, IdentifiableType type) {
        List<Double> nominalVoltages = ThreeNominalVoltageCriterion.getNominalVoltages(identifiable, type);
        return nominalVoltages.size() == 3 && this.filterWithNominalVoltages(nominalVoltages.get(0), nominalVoltages.get(1), nominalVoltages.get(2));
    }

    protected static List<Double> getNominalVoltages(Identifiable<?> identifiable, IdentifiableType type) {
        if (type == IdentifiableType.THREE_WINDINGS_TRANSFORMER) {
            ThreeWindingsTransformer transformer = (ThreeWindingsTransformer)identifiable;
            return Arrays.asList(NominalVoltageUtils.getNominalVoltage(transformer.getLeg1().getTerminal()), NominalVoltageUtils.getNominalVoltage(transformer.getLeg2().getTerminal()), NominalVoltageUtils.getNominalVoltage(transformer.getLeg3().getTerminal()));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean filter(NetworkElement networkElement) {
        Double nominalVoltage1 = networkElement.getNominalVoltage1().orElse(null);
        Double nominalVoltage2 = networkElement.getNominalVoltage2().orElse(null);
        Double nominalVoltage3 = networkElement.getNominalVoltage3().orElse(null);
        return this.filterWithNominalVoltages(nominalVoltage1, nominalVoltage2, nominalVoltage3);
    }

    private boolean filterWithNominalVoltages(Double nominalVoltage1, Double nominalVoltage2, Double nominalVoltage3) {
        AtomicBoolean filter = new AtomicBoolean(true);
        this.voltageIntervals.forEach(voltageInterval -> {
            if (!(voltageInterval.checkIsBetweenBound(nominalVoltage1) || voltageInterval.checkIsBetweenBound(nominalVoltage2) || voltageInterval.checkIsBetweenBound(nominalVoltage3))) {
                filter.set(false);
            }
        });
        return filter.get();
    }

    public Optional<VoltageInterval> getVoltageInterval1() {
        return Optional.ofNullable(this.voltageInterval1);
    }

    public Optional<VoltageInterval> getVoltageInterval2() {
        return Optional.ofNullable(this.voltageInterval2);
    }

    public Optional<VoltageInterval> getVoltageInterval3() {
        return Optional.ofNullable(this.voltageInterval3);
    }
}

