/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.criteria;

import java.util.Optional;
import org.apache.commons.lang3.DoubleRange;

public final class VoltageInterval {
    private final Double nominalVoltageLowBound;
    private final Double nominalVoltageHighBound;
    private final boolean lowClosed;
    private final boolean highClosed;

    private VoltageInterval(Double lowBound, Double highBound, boolean lowClosed, boolean highClosed) {
        this.nominalVoltageLowBound = lowBound;
        this.nominalVoltageHighBound = highBound;
        this.lowClosed = lowClosed;
        this.highClosed = highClosed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static VoltageInterval greaterThan(double value, boolean closed) {
        return VoltageInterval.builder().setLowBound(value, closed).build();
    }

    public static VoltageInterval lowerThan(double value, boolean closed) {
        return VoltageInterval.builder().setHighBound(value, closed).build();
    }

    public static VoltageInterval between(double lowBound, double highBound, boolean lowClosed, boolean highClosed) {
        return VoltageInterval.builder().setLowBound(lowBound, lowClosed).setHighBound(highBound, highClosed).build();
    }

    public boolean checkIsBetweenBound(Double value) {
        if (value == null || value < 0.0) {
            return false;
        }
        boolean lowBoundOk = this.nominalVoltageLowBound == null || value > this.nominalVoltageLowBound || this.lowClosed && value.equals(this.nominalVoltageLowBound);
        boolean highBoundOk = this.nominalVoltageHighBound == null || value < this.nominalVoltageHighBound || this.highClosed && value.equals(this.nominalVoltageHighBound);
        return lowBoundOk && highBoundOk;
    }

    public Optional<Double> getNominalVoltageLowBound() {
        return Optional.ofNullable(this.nominalVoltageLowBound);
    }

    public Optional<Double> getNominalVoltageHighBound() {
        return Optional.ofNullable(this.nominalVoltageHighBound);
    }

    public boolean isLowClosed() {
        return this.lowClosed;
    }

    public boolean isHighClosed() {
        return this.highClosed;
    }

    public DoubleRange asRange() {
        double min = 0.0;
        if (this.nominalVoltageLowBound != null) {
            min = this.nominalVoltageLowBound;
            if (!this.lowClosed) {
                min += Math.ulp(min);
            }
        }
        double max = Double.MAX_VALUE;
        if (this.nominalVoltageHighBound != null) {
            max = this.nominalVoltageHighBound;
            if (!this.highClosed) {
                max -= Math.ulp(max);
            }
        }
        return DoubleRange.of((double)min, (double)max);
    }

    public static class Builder {
        private Double nominalVoltageLowBound = null;
        private Double nominalVoltageHighBound = null;
        private boolean lowClosed = true;
        private boolean highClosed = true;

        public Builder setLowBound(double value, boolean closed) {
            Builder.checkValue(value);
            Builder.checkBounds(value, this.nominalVoltageHighBound, closed, this.highClosed);
            this.nominalVoltageLowBound = value;
            this.lowClosed = closed;
            return this;
        }

        public Builder setHighBound(double value, boolean closed) {
            Builder.checkValue(value);
            Builder.checkBounds(this.nominalVoltageLowBound, value, this.lowClosed, closed);
            this.nominalVoltageHighBound = value;
            this.highClosed = closed;
            return this;
        }

        protected static void checkValue(double value) {
            if (Double.isNaN(value) || Double.isInfinite(value) || value < 0.0) {
                throw new IllegalArgumentException("Invalid interval bound value (must be >= 0 and not infinite).");
            }
        }

        protected static void checkBounds(Double low, Double high, boolean closedLow, boolean closedHigh) {
            double h;
            if (low != null && high != null && low > high) {
                throw new IllegalArgumentException("Invalid interval bounds values (nominalVoltageLowBound must be <= nominalVoltageHighBound).");
            }
            double l = low != null ? low : 0.0;
            double d = h = high != null ? high : Double.MAX_VALUE;
            if (!(l != h || closedLow && closedHigh)) {
                throw new IllegalArgumentException("Invalid interval: it should not be empty");
            }
        }

        public VoltageInterval build() {
            if (this.nominalVoltageLowBound == null && this.nominalVoltageHighBound == null) {
                throw new IllegalArgumentException("Invalid interval: at least one bound must be defined.");
            }
            return new VoltageInterval(this.nominalVoltageLowBound, this.nominalVoltageHighBound, this.lowClosed, this.highClosed);
        }
    }
}

