/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.extensions.util;

import com.powsybl.math.matrix.DenseMatrix;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.util.Pair;

public final class FortescueUtil {
    public static DenseMatrix getFortescueMatrix() {
        return FortescueUtil.getFortescueOrInverseMatrix(false);
    }

    public static DenseMatrix getFortescueInverseMatrix() {
        return FortescueUtil.getFortescueOrInverseMatrix(true);
    }

    public static DenseMatrix getFortescueOrInverseMatrix(boolean isInverse) {
        DenseMatrix mFortescueOrInverse = new DenseMatrix(6, 6);
        double t = 1.0;
        double signA = 1.0;
        if (isInverse) {
            t = 0.3333333333333333;
            signA = -1.0;
        }
        mFortescueOrInverse.add(0, 0, t);
        mFortescueOrInverse.add(1, 1, t);
        mFortescueOrInverse.add(2, 0, t);
        mFortescueOrInverse.add(3, 1, t);
        mFortescueOrInverse.add(4, 0, t);
        mFortescueOrInverse.add(5, 1, t);
        mFortescueOrInverse.add(0, 2, t);
        mFortescueOrInverse.add(1, 3, t);
        mFortescueOrInverse.add(2, 2, -t / 2.0);
        mFortescueOrInverse.add(2, 3, signA * t * Math.sqrt(3.0) / 2.0);
        mFortescueOrInverse.add(3, 2, -signA * t * Math.sqrt(3.0) / 2.0);
        mFortescueOrInverse.add(3, 3, -t / 2.0);
        mFortescueOrInverse.add(4, 2, -t / 2.0);
        mFortescueOrInverse.add(4, 3, -signA * t * Math.sqrt(3.0) / 2.0);
        mFortescueOrInverse.add(5, 2, signA * t * Math.sqrt(3.0) / 2.0);
        mFortescueOrInverse.add(5, 3, -t / 2.0);
        mFortescueOrInverse.add(0, 4, t);
        mFortescueOrInverse.add(1, 5, t);
        mFortescueOrInverse.add(2, 4, -t / 2.0);
        mFortescueOrInverse.add(2, 5, -signA * t * Math.sqrt(3.0) / 2.0);
        mFortescueOrInverse.add(3, 4, signA * t * Math.sqrt(3.0) / 2.0);
        mFortescueOrInverse.add(3, 5, -t / 2.0);
        mFortescueOrInverse.add(4, 4, -t / 2.0);
        mFortescueOrInverse.add(4, 5, signA * t * Math.sqrt(3.0) / 2.0);
        mFortescueOrInverse.add(5, 4, -signA * t * Math.sqrt(3.0) / 2.0);
        mFortescueOrInverse.add(5, 5, -t / 2.0);
        return mFortescueOrInverse;
    }

    public static Vector2D getCartesianFromPolar(double magnitude, double angle) {
        return new Vector2D(magnitude * Math.cos(angle), magnitude * Math.sin(angle));
    }

    public static Pair<Double, Double> getPolarFromCartesian(double xValue, double yValue) {
        return new Pair((Object)Math.sqrt(xValue * xValue + yValue * yValue), (Object)Math.atan2(yValue, xValue));
    }

    private FortescueUtil() {
    }

    public static enum SequenceType {
        POSITIVE,
        NEGATIVE,
        ZERO;

    }
}

