/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.extensions.util;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.extensions.Measurement;
import com.powsybl.iidm.network.extensions.Measurements;
import com.powsybl.iidm.network.util.Identifiables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MeasurementValidationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MeasurementValidationUtil.class);

    public static <C extends Connectable<C>> void checkId(String id, Measurements<C> measurements) {
        MeasurementValidationUtil.checkId(id, false, measurements);
    }

    public static <C extends Connectable<C>> String checkId(String id, boolean idUnicity, Measurements<C> measurements) {
        String finalId = id;
        if (id != null && measurements.getMeasurement(id) != null) {
            if (idUnicity) {
                finalId = Identifiables.getUniqueId((String)id, s -> measurements.getMeasurement((String)s) != null);
                LOGGER.warn("Ensure ID {} unicity: {}", (Object)id, (Object)finalId);
            } else {
                throw new PowsyblException(String.format("There is already a measurement with ID %s", id));
            }
        }
        return finalId;
    }

    public static void checkValue(double value, boolean valid) {
        if (Double.isNaN(value) && valid) {
            throw new PowsyblException("Valid measurement can not have an undefined value");
        }
    }

    public static <C extends Connectable<C>> void checkSide(Measurement.Type type, ThreeSides side, Connectable<C> c) {
        if (side != null && c instanceof Injection) {
            throw new PowsyblException("Inconsistent side for measurement of injection");
        }
        if (side == null && type != Measurement.Type.OTHER && !(c instanceof Injection)) {
            throw new PowsyblException("Inconsistent null side for measurement of branch or three windings transformer");
        }
    }

    private MeasurementValidationUtil() {
    }
}

