/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.SlackTerminalAdder;
import com.powsybl.iidm.network.util.TerminalFinder;
import java.util.Objects;

public interface SlackTerminal
extends Extension<VoltageLevel> {
    public static final String NAME = "slackTerminal";

    public static void reset(Network network) {
        network.getVoltageLevels().forEach(vl -> SlackTerminal.reset(vl, null));
    }

    public static void reset(VoltageLevel voltageLevel, Terminal terminal) {
        Objects.requireNonNull(voltageLevel);
        SlackTerminal st = (SlackTerminal)voltageLevel.getExtension(SlackTerminal.class);
        if (st == null && terminal != null) {
            ((SlackTerminalAdder)voltageLevel.newExtension(SlackTerminalAdder.class)).withTerminal(terminal).add();
        } else if (st != null) {
            st.setTerminal(terminal, true);
        }
    }

    public static void attach(Bus bus) {
        Objects.requireNonNull(bus);
        VoltageLevel vl = bus.getVoltageLevel();
        Terminal terminal = (Terminal)TerminalFinder.getDefault().find(bus.getConnectedTerminals()).orElseThrow(() -> new PowsyblException("Unable to find a terminal in the bus " + bus.getId()));
        SlackTerminal.reset(vl, terminal);
    }

    default public String getName() {
        return NAME;
    }

    public Terminal getTerminal();

    public SlackTerminal setTerminal(Terminal var1);

    default public SlackTerminal setTerminal(Terminal terminal, boolean cleanIfEmpty) {
        this.setTerminal(terminal);
        if (cleanIfEmpty && terminal == null && this.isEmpty()) {
            ((VoltageLevel)this.getExtendable()).removeExtension(SlackTerminal.class);
        }
        return this;
    }

    public boolean isEmpty();
}

