/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.extensions;

import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.extensions.ReferenceTerminalsAdder;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public interface ReferenceTerminals
extends Extension<Network> {
    public static final String NAME = "referenceTerminals";

    default public String getName() {
        return NAME;
    }

    public Set<Terminal> getReferenceTerminals();

    public void setReferenceTerminals(Set<Terminal> var1);

    public ReferenceTerminals reset();

    public ReferenceTerminals addReferenceTerminal(Terminal var1);

    public static void reset(Network network) {
        Objects.requireNonNull(network);
        ReferenceTerminals ext = (ReferenceTerminals)network.getExtension(ReferenceTerminals.class);
        if (ext == null) {
            ext = (ReferenceTerminals)((ReferenceTerminalsAdder)network.newExtension(ReferenceTerminalsAdder.class)).withTerminals(Set.of()).add();
        }
        ext.reset();
        network.getSubnetworks().forEach(ReferenceTerminals::reset);
    }

    public static void addTerminal(Terminal terminal) {
        Objects.requireNonNull(terminal);
        Network network = terminal.getVoltageLevel().getNetwork();
        ReferenceTerminals ext = (ReferenceTerminals)network.getExtension(ReferenceTerminals.class);
        if (ext == null) {
            ext = (ReferenceTerminals)((ReferenceTerminalsAdder)network.newExtension(ReferenceTerminalsAdder.class)).withTerminals(Set.of()).add();
        }
        ext.addReferenceTerminal(terminal);
    }

    public static Set<Terminal> getTerminals(Network network) {
        Objects.requireNonNull(network);
        ReferenceTerminals ext = (ReferenceTerminals)network.getExtension(ReferenceTerminals.class);
        if (ext == null) {
            return Collections.emptySet();
        }
        return ext.getReferenceTerminals();
    }
}

