/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.extensions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.extensions.ReferencePriority;
import com.powsybl.iidm.network.extensions.ReferencePriorityAdder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public interface ReferencePriorities<C extends Connectable<C>>
extends Extension<C> {
    public static final String NAME = "referencePriorities";
    public static final ImmutableMap<IdentifiableType, Integer> DEFAULT_CONNECTABLE_TYPE_PRIORITIES = Maps.immutableEnumMap((Map)ImmutableMap.builder().put((Object)IdentifiableType.GENERATOR, (Object)1).put((Object)IdentifiableType.BUSBAR_SECTION, (Object)2).put((Object)IdentifiableType.LOAD, (Object)3).build());
    public static final Comparator<ReferencePriority> DEFAULT_CONNECTABLE_TYPE_COMPARATOR = Comparator.comparing(rt -> (Integer)DEFAULT_CONNECTABLE_TYPE_PRIORITIES.getOrDefault((Object)rt.getTerminal().getConnectable().getType(), (Object)Integer.MAX_VALUE));

    default public String getName() {
        return NAME;
    }

    public static List<ReferencePriority> get(Network network, Comparator<ReferencePriority> connectableComparator) {
        return network.getConnectableStream().filter(c -> c.getExtension(ReferencePriorities.class) != null).map(c -> (ReferencePriorities)c.getExtension(ReferencePriorities.class)).flatMap(rt -> rt.getReferencePriorities().stream()).filter(rt -> ((ReferencePriority)rt).getPriority() > 0).sorted(Comparator.comparingInt(ReferencePriority::getPriority).thenComparing(connectableComparator)).toList();
    }

    public static List<ReferencePriority> get(Network network) {
        return ReferencePriorities.get(network, DEFAULT_CONNECTABLE_TYPE_COMPARATOR);
    }

    public static void delete(Network network) {
        network.getConnectableStream().filter(c -> c.getExtension(ReferencePriorities.class) != null).forEach(c -> ((ReferencePriorities)c.getExtension(ReferencePriorities.class)).deleteReferencePriorities());
    }

    public ReferencePriorityAdder newReferencePriority();

    public List<ReferencePriority> getReferencePriorities();

    public void deleteReferencePriorities();
}

