/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.extensions;

import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.extensions.ReferencePriorities;
import com.powsybl.iidm.network.extensions.ReferencePrioritiesAdder;
import java.util.Optional;

public interface ReferencePriority {
    public Terminal getTerminal();

    public int getPriority();

    public static int get(Injection<?> injection) {
        ReferencePriorities ext = (ReferencePriorities)injection.getExtension(ReferencePriorities.class);
        if (ext == null || ext.getReferencePriorities().isEmpty()) {
            return 0;
        }
        return ext.getReferencePriorities().get(0).getPriority();
    }

    public static int get(Branch<?> branch, TwoSides side) {
        ReferencePriorities ext = (ReferencePriorities)branch.getExtension(ReferencePriorities.class);
        if (ext == null) {
            return 0;
        }
        Optional<ReferencePriority> refTerminal = ext.getReferencePriorities().stream().filter(rt -> rt.getTerminal().getConnectable().getId().equals(branch.getId())).filter(rt -> side.toThreeSides().equals(Terminal.getConnectableSide((Terminal)rt.getTerminal()).orElseThrow())).findFirst();
        return refTerminal.map(ReferencePriority::getPriority).orElse(0);
    }

    public static int get(ThreeWindingsTransformer threeWindingsTransformer, ThreeSides side) {
        ReferencePriorities ext = (ReferencePriorities)threeWindingsTransformer.getExtension(ReferencePriorities.class);
        if (ext == null) {
            return 0;
        }
        Optional<ReferencePriority> refTerminal = ext.getReferencePriorities().stream().filter(rt -> rt.getTerminal().getConnectable().getId().equals(threeWindingsTransformer.getId())).filter(rt -> side.equals(Terminal.getConnectableSide((Terminal)rt.getTerminal()).orElseThrow())).findFirst();
        return refTerminal.map(ReferencePriority::getPriority).orElse(0);
    }

    public static void set(Injection<?> injection, int priority) {
        ReferencePriorities ext = (ReferencePriorities)injection.getExtension(ReferencePriorities.class);
        if (ext == null) {
            ext = (ReferencePriorities)((ReferencePrioritiesAdder)injection.newExtension(ReferencePrioritiesAdder.class)).add();
        }
        ext.newReferencePriority().setTerminal((Terminal)injection.getTerminals().get(0)).setPriority(priority).add();
    }

    public static void set(Branch<?> branch, TwoSides side, int priority) {
        ReferencePriorities ext = (ReferencePriorities)branch.getExtension(ReferencePriorities.class);
        if (ext == null) {
            ext = (ReferencePriorities)((ReferencePrioritiesAdder)branch.newExtension(ReferencePrioritiesAdder.class)).add();
        }
        ext.newReferencePriority().setTerminal(branch.getTerminal(side)).setPriority(priority).add();
    }

    public static void set(ThreeWindingsTransformer threeWindingsTransformer, ThreeSides side, int priority) {
        ReferencePriorities ext = (ReferencePriorities)threeWindingsTransformer.getExtension(ReferencePriorities.class);
        if (ext == null) {
            ext = (ReferencePriorities)((ReferencePrioritiesAdder)threeWindingsTransformer.newExtension(ReferencePrioritiesAdder.class)).add();
        }
        ext.newReferencePriority().setTerminal(threeWindingsTransformer.getTerminal(side)).setPriority(priority).add();
    }
}

