/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.extensions.util;

import com.powsybl.math.matrix.ComplexMatrix;
import com.powsybl.math.matrix.DenseMatrix;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Pair;

public final class FortescueUtil {
    public static DenseMatrix getFortescueMatrix() {
        return FortescueUtil.createComplexMatrix(false).toRealCartesianMatrix();
    }

    public static DenseMatrix getFortescueInverseMatrix() {
        return FortescueUtil.createComplexMatrix(true).toRealCartesianMatrix();
    }

    public static ComplexMatrix createComplexMatrix(boolean inverse) {
        Complex a = new Complex(-0.5, FastMath.sqrt((double)3.0) / 2.0);
        Complex a2 = a.multiply(a);
        double t = 1.0;
        Complex c1 = a;
        Complex c2 = a2;
        if (inverse) {
            t = 0.3333333333333333;
            c1 = a2.multiply(t);
            c2 = a.multiply(t);
        }
        Complex unit = new Complex(t, 0.0);
        ComplexMatrix complexMatrix = new ComplexMatrix(3, 3);
        complexMatrix.set(0, 0, unit);
        complexMatrix.set(0, 1, unit);
        complexMatrix.set(0, 2, unit);
        complexMatrix.set(1, 0, unit);
        complexMatrix.set(1, 1, c2);
        complexMatrix.set(1, 2, c1);
        complexMatrix.set(2, 0, unit);
        complexMatrix.set(2, 1, c1);
        complexMatrix.set(2, 2, c2);
        return complexMatrix;
    }

    public static Vector2D getCartesianFromPolar(double magnitude, double angle) {
        return new Vector2D(magnitude * Math.cos(angle), magnitude * Math.sin(angle));
    }

    public static Pair<Double, Double> getPolarFromCartesian(double xValue, double yValue) {
        return new Pair((Object)Math.sqrt(xValue * xValue + yValue * yValue), (Object)Math.atan2(yValue, xValue));
    }

    private FortescueUtil() {
    }

    public static enum SequenceType {
        POSITIVE(1),
        NEGATIVE(2),
        ZERO(0);

        private final int num;

        private SequenceType(int num) {
            this.num = num;
        }

        public int getNum() {
            return this.num;
        }
    }
}

