/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.OperationalLimits;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.BranchUtil;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.OperationalLimitsHolderImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.util.Ref;
import com.powsybl.iidm.network.util.LimitViolationUtils;
import java.util.Collection;
import java.util.Optional;

abstract class AbstractConnectableBranch<I extends Branch<I> & Connectable<I>>
extends AbstractConnectable<I>
implements Branch<I> {
    protected final OperationalLimitsHolderImpl operationalLimitsHolder1 = new OperationalLimitsHolderImpl(this, "limits1");
    protected final OperationalLimitsHolderImpl operationalLimitsHolder2 = new OperationalLimitsHolderImpl(this, "limits2");

    AbstractConnectableBranch(Ref<NetworkImpl> network, String id, String name, boolean fictitious) {
        super(network, id, name, fictitious);
    }

    public TerminalExt getTerminal1() {
        return (TerminalExt)this.terminals.get(0);
    }

    public TerminalExt getTerminal2() {
        return (TerminalExt)this.terminals.get(1);
    }

    public Terminal getTerminal(Branch.Side side) {
        return BranchUtil.getFromSide(side, this::getTerminal1, this::getTerminal2);
    }

    public Terminal getTerminal(String voltageLevelId) {
        return BranchUtil.getTerminal(voltageLevelId, this.getTerminal1(), this.getTerminal2());
    }

    public Branch.Side getSide(Terminal terminal) {
        return BranchUtil.getSide(terminal, this.getTerminal1(), this.getTerminal2());
    }

    public Collection<OperationalLimits> getOperationalLimits1() {
        return this.operationalLimitsHolder1.getOperationalLimits();
    }

    public Optional<CurrentLimits> getCurrentLimits1() {
        return this.operationalLimitsHolder1.getOperationalLimits(LimitType.CURRENT, CurrentLimits.class);
    }

    public CurrentLimits getNullableCurrentLimits1() {
        return this.operationalLimitsHolder1.getNullableOperationalLimits(LimitType.CURRENT, CurrentLimits.class);
    }

    public CurrentLimitsAdder newCurrentLimits1() {
        return this.operationalLimitsHolder1.newCurrentLimits();
    }

    public Optional<ApparentPowerLimits> getApparentPowerLimits1() {
        return this.operationalLimitsHolder1.getOperationalLimits(LimitType.APPARENT_POWER, ApparentPowerLimits.class);
    }

    public ApparentPowerLimits getNullableApparentPowerLimits1() {
        return this.operationalLimitsHolder1.getNullableOperationalLimits(LimitType.APPARENT_POWER, ApparentPowerLimits.class);
    }

    public ApparentPowerLimitsAdder newApparentPowerLimits1() {
        return this.operationalLimitsHolder1.newApparentPowerLimits();
    }

    public Collection<OperationalLimits> getOperationalLimits2() {
        return this.operationalLimitsHolder2.getOperationalLimits();
    }

    public Optional<ActivePowerLimits> getActivePowerLimits1() {
        return this.operationalLimitsHolder1.getOperationalLimits(LimitType.ACTIVE_POWER, ActivePowerLimits.class);
    }

    public ActivePowerLimits getNullableActivePowerLimits1() {
        return this.operationalLimitsHolder1.getNullableOperationalLimits(LimitType.ACTIVE_POWER, ActivePowerLimits.class);
    }

    public ActivePowerLimitsAdder newActivePowerLimits1() {
        return this.operationalLimitsHolder1.newActivePowerLimits();
    }

    public Optional<CurrentLimits> getCurrentLimits2() {
        return this.operationalLimitsHolder2.getOperationalLimits(LimitType.CURRENT, CurrentLimits.class);
    }

    public CurrentLimits getNullableCurrentLimits2() {
        return this.operationalLimitsHolder2.getNullableOperationalLimits(LimitType.CURRENT, CurrentLimits.class);
    }

    public CurrentLimitsAdder newCurrentLimits2() {
        return this.operationalLimitsHolder2.newCurrentLimits();
    }

    public Optional<ApparentPowerLimits> getApparentPowerLimits2() {
        return this.operationalLimitsHolder2.getOperationalLimits(LimitType.APPARENT_POWER, ApparentPowerLimits.class);
    }

    public ApparentPowerLimits getNullableApparentPowerLimits2() {
        return this.operationalLimitsHolder2.getNullableOperationalLimits(LimitType.APPARENT_POWER, ApparentPowerLimits.class);
    }

    public ApparentPowerLimitsAdder newApparentPowerLimits2() {
        return this.operationalLimitsHolder2.newApparentPowerLimits();
    }

    public Optional<ActivePowerLimits> getActivePowerLimits2() {
        return this.operationalLimitsHolder2.getOperationalLimits(LimitType.ACTIVE_POWER, ActivePowerLimits.class);
    }

    public ActivePowerLimits getNullableActivePowerLimits2() {
        return this.operationalLimitsHolder2.getNullableOperationalLimits(LimitType.ACTIVE_POWER, ActivePowerLimits.class);
    }

    public ActivePowerLimitsAdder newActivePowerLimits2() {
        return this.operationalLimitsHolder2.newActivePowerLimits();
    }

    public Optional<CurrentLimits> getCurrentLimits(Branch.Side side) {
        return BranchUtil.getFromSide(side, this::getCurrentLimits1, this::getCurrentLimits2);
    }

    public Optional<ActivePowerLimits> getActivePowerLimits(Branch.Side side) {
        return BranchUtil.getFromSide(side, this::getActivePowerLimits1, this::getActivePowerLimits2);
    }

    public Optional<ApparentPowerLimits> getApparentPowerLimits(Branch.Side side) {
        return BranchUtil.getFromSide(side, this::getApparentPowerLimits1, this::getApparentPowerLimits2);
    }

    OperationalLimitsHolderImpl getLimitsHolder1() {
        return this.operationalLimitsHolder1;
    }

    OperationalLimitsHolderImpl getLimitsHolder2() {
        return this.operationalLimitsHolder2;
    }

    public boolean isOverloaded() {
        return this.isOverloaded(1.0f);
    }

    public boolean isOverloaded(float limitReduction) {
        return this.checkPermanentLimit1(limitReduction, LimitType.CURRENT) || this.checkPermanentLimit2(limitReduction, LimitType.CURRENT);
    }

    public int getOverloadDuration() {
        return BranchUtil.getOverloadDuration(this.checkTemporaryLimits1(LimitType.CURRENT), this.checkTemporaryLimits2(LimitType.CURRENT));
    }

    public boolean checkPermanentLimit(Branch.Side side, float limitReduction, LimitType type) {
        return BranchUtil.getFromSide(side, () -> this.checkPermanentLimit1(limitReduction, type), () -> this.checkPermanentLimit2(limitReduction, type));
    }

    public boolean checkPermanentLimit(Branch.Side side, LimitType type) {
        return this.checkPermanentLimit(side, 1.0f, type);
    }

    public boolean checkPermanentLimit1(float limitReduction, LimitType type) {
        return LimitViolationUtils.checkPermanentLimit((Branch)this, (Branch.Side)Branch.Side.ONE, (float)limitReduction, (double)this.getValueForLimit(this.getTerminal1(), type), (LimitType)type);
    }

    public boolean checkPermanentLimit1(LimitType type) {
        return this.checkPermanentLimit1(1.0f, type);
    }

    public boolean checkPermanentLimit2(float limitReduction, LimitType type) {
        return LimitViolationUtils.checkPermanentLimit((Branch)this, (Branch.Side)Branch.Side.TWO, (float)limitReduction, (double)this.getValueForLimit(this.getTerminal2(), type), (LimitType)type);
    }

    public boolean checkPermanentLimit2(LimitType type) {
        return this.checkPermanentLimit2(1.0f, type);
    }

    public Branch.Overload checkTemporaryLimits(Branch.Side side, float limitReduction, LimitType type) {
        return BranchUtil.getFromSide(side, () -> this.checkTemporaryLimits1(limitReduction, type), () -> this.checkTemporaryLimits2(limitReduction, type));
    }

    public Branch.Overload checkTemporaryLimits(Branch.Side side, LimitType type) {
        return this.checkTemporaryLimits(side, 1.0f, type);
    }

    public Branch.Overload checkTemporaryLimits1(float limitReduction, LimitType type) {
        return LimitViolationUtils.checkTemporaryLimits((Branch)this, (Branch.Side)Branch.Side.ONE, (float)limitReduction, (double)this.getValueForLimit(this.getTerminal1(), type), (LimitType)type);
    }

    public Branch.Overload checkTemporaryLimits1(LimitType type) {
        return this.checkTemporaryLimits1(1.0f, type);
    }

    public Branch.Overload checkTemporaryLimits2(float limitReduction, LimitType type) {
        return LimitViolationUtils.checkTemporaryLimits((Branch)this, (Branch.Side)Branch.Side.TWO, (float)limitReduction, (double)this.getValueForLimit(this.getTerminal2(), type), (LimitType)type);
    }

    public Branch.Overload checkTemporaryLimits2(LimitType type) {
        return this.checkTemporaryLimits2(1.0f, type);
    }

    public double getValueForLimit(Terminal t, LimitType type) {
        return BranchUtil.getValueForLimit(t, type);
    }
}

