/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.util.Ref;
import java.util.Optional;

abstract class AbstractHvdcConverterStation<T extends HvdcConverterStation<T>>
extends AbstractConnectable<T>
implements HvdcConverterStation<T> {
    private HvdcLine hvdcLine = null;
    private float lossFactor = Float.NaN;

    AbstractHvdcConverterStation(Ref<NetworkImpl> network, String id, String name, boolean fictitious, float lossFactor) {
        super(network, id, name, fictitious);
        this.lossFactor = lossFactor;
    }

    public HvdcLine getHvdcLine() {
        return this.hvdcLine;
    }

    T setHvdcLine(HvdcLine hvdcLine) {
        this.hvdcLine = hvdcLine;
        return (T)this;
    }

    public TerminalExt getTerminal() {
        return (TerminalExt)this.terminals.get(0);
    }

    public float getLossFactor() {
        return this.lossFactor;
    }

    public T setLossFactor(float lossFactor) {
        ValidationUtil.checkLossFactor((Validable)this, (float)lossFactor);
        float oldValue = this.lossFactor;
        this.lossFactor = lossFactor;
        this.notifyUpdate("lossFactor", (Object)Float.valueOf(oldValue), (Object)Float.valueOf(lossFactor));
        return (T)this;
    }

    public Optional<? extends HvdcConverterStation<?>> getOtherConverterStation() {
        if (this.hvdcLine != null) {
            return this.hvdcLine.getConverterStation1() == this ? Optional.ofNullable(this.hvdcLine.getConverterStation2()) : Optional.ofNullable(this.hvdcLine.getConverterStation1());
        }
        return Optional.empty();
    }

    @Override
    public void remove() {
        if (this.hvdcLine != null) {
            throw new ValidationException((Validable)this, "Impossible to remove this converter station (still attached to '" + this.hvdcLine.getId() + "')");
        }
        super.remove();
    }
}

