/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.google.common.base.Strings;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtendable;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.impl.MultiVariantObject;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.util.Identifiables;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

abstract class AbstractIdentifiable<I extends Identifiable<I>>
extends AbstractExtendable<I>
implements Identifiable<I>,
Validable,
MultiVariantObject {
    protected String id;
    protected String name;
    protected boolean fictitious = false;
    protected final Properties properties = new Properties();
    private final Set<String> aliasesWithoutType = new HashSet<String>();
    private final Map<String, String> aliasesByType = new HashMap<String, String>();

    AbstractIdentifiable(String id, String name) {
        this.id = id;
        this.name = name;
    }

    AbstractIdentifiable(String id, String name, boolean fictitious) {
        this(id, name);
        this.fictitious = fictitious;
    }

    public String getId() {
        return this.id;
    }

    void replaceId(String newId) {
        throw new PowsyblException("Cannot change ID");
    }

    public Optional<String> getOptionalName() {
        return Optional.ofNullable(this.name);
    }

    public String getNameOrId() {
        return this.name != null ? this.name : this.id;
    }

    public I setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.getNetwork().getListeners().notifyUpdate((Identifiable)this, "name", (Object)oldName, (Object)name);
        return (I)this;
    }

    public Set<String> getAliases() {
        HashSet<String> aliases = new HashSet<String>();
        aliases.addAll(this.aliasesWithoutType);
        aliases.addAll(this.aliasesByType.values());
        return Collections.unmodifiableSet(aliases);
    }

    public Optional<String> getAliasType(String alias) {
        Objects.requireNonNull(alias);
        if (this.aliasesWithoutType.contains(alias)) {
            return Optional.empty();
        }
        return this.aliasesByType.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(alias)).map(Map.Entry::getKey).findFirst();
    }

    public Optional<String> getAliasFromType(String aliasType) {
        if (Strings.isNullOrEmpty((String)aliasType)) {
            throw new PowsyblException("Alias type must not be null or empty");
        }
        return Optional.ofNullable(this.aliasesByType.get(aliasType));
    }

    public void addAlias(String alias) {
        this.addAlias(alias, false);
    }

    public void addAlias(String alias, boolean ensureAliasUnicity) {
        this.addAlias(alias, null, ensureAliasUnicity);
    }

    public void addAlias(String alias, String aliasType) {
        this.addAlias(alias, aliasType, false);
    }

    public void addAlias(String alias, String aliasType, boolean ensureAliasUnicity) {
        Objects.requireNonNull(alias);
        String uniqueAlias = alias;
        if (ensureAliasUnicity) {
            uniqueAlias = Identifiables.getUniqueId((String)alias, this.getNetwork().getIndex()::contains);
        }
        if (!Strings.isNullOrEmpty((String)aliasType) && this.aliasesByType.containsKey(aliasType)) {
            throw new PowsyblException(this.id + " already has an alias of type " + aliasType);
        }
        if (this.getNetwork().getIndex().addAlias(this, uniqueAlias)) {
            if (Strings.isNullOrEmpty((String)aliasType)) {
                this.aliasesWithoutType.add(uniqueAlias);
            } else {
                this.aliasesByType.put(aliasType, uniqueAlias);
            }
        }
    }

    public void removeAlias(String alias) {
        Objects.requireNonNull(alias);
        this.getNetwork().getIndex().removeAlias(this, alias);
        String type = this.aliasesByType.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(alias)).map(Map.Entry::getKey).filter(Objects::nonNull).findFirst().orElse(null);
        if (Strings.isNullOrEmpty((String)type)) {
            this.aliasesWithoutType.remove(alias);
        } else {
            this.aliasesByType.remove(type);
        }
    }

    public boolean hasAliases() {
        return !this.aliasesWithoutType.isEmpty() || !this.aliasesByType.isEmpty();
    }

    public boolean isFictitious() {
        return this.fictitious;
    }

    public void setFictitious(boolean fictitious) {
        boolean oldValue = this.fictitious;
        this.fictitious = fictitious;
        this.getNetwork().getListeners().notifyUpdate((Identifiable)this, "fictitious", (Object)oldValue, (Object)fictitious);
    }

    public abstract NetworkImpl getNetwork();

    protected abstract String getTypeDescription();

    public String getMessageHeader() {
        return this.getTypeDescription() + " '" + this.id + "': ";
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean hasProperty() {
        return !this.properties.isEmpty();
    }

    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public String getProperty(String key) {
        Object val = this.properties.get(key);
        return val != null ? val.toString() : null;
    }

    public String getProperty(String key, String defaultValue) {
        Object val = this.properties.getOrDefault((Object)key, defaultValue);
        return val != null ? val.toString() : null;
    }

    public String setProperty(String key, String value) {
        String oldValue = (String)this.properties.put(key, value);
        if (Objects.isNull(oldValue)) {
            this.getNetwork().getListeners().notifyElementAdded(this, () -> "properties[" + key + "]", (Object)value);
        } else {
            this.getNetwork().getListeners().notifyElementReplaced(this, () -> "properties[" + key + "]", (Object)oldValue, (Object)value);
        }
        return oldValue;
    }

    public boolean removeProperty(String key) {
        Object oldValue = this.properties.remove(key);
        if (oldValue != null) {
            this.getNetwork().getListeners().notifyElementRemoved(this, () -> "properties[" + key + "]", oldValue);
            return true;
        }
        return false;
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet().stream().map(Object::toString).collect(Collectors.toSet());
    }

    public String toString() {
        return this.id;
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.getExtensions().stream().filter(e -> e instanceof MultiVariantObject).map(e -> (MultiVariantObject)e).forEach(e -> e.extendVariantArraySize(initVariantArraySize, number, sourceIndex));
    }

    @Override
    public void reduceVariantArraySize(int number) {
        this.getExtensions().stream().filter(e -> e instanceof MultiVariantObject).map(e -> (MultiVariantObject)e).forEach(e -> e.reduceVariantArraySize(number));
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        this.getExtensions().stream().filter(e -> e instanceof MultiVariantObject).map(e -> (MultiVariantObject)e).forEach(e -> e.deleteVariantArrayElement(index));
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        this.getExtensions().stream().filter(e -> e instanceof MultiVariantObject).map(e -> (MultiVariantObject)e).forEach(e -> e.allocateVariantArrayElement(indexes, sourceIndex));
    }
}

