/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.google.common.collect.FluentIterable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.ContainerType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.NetworkExt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.joda.time.DateTime;

abstract class AbstractNetwork
extends AbstractIdentifiable<Network>
implements NetworkExt {
    private DateTime caseDate = new DateTime();
    private int forecastDistance = 0;
    protected String sourceFormat;

    AbstractNetwork(String id, String name, String sourceFormat) {
        super(id, name);
        this.sourceFormat = Objects.requireNonNull(sourceFormat, "source format is null");
    }

    public ContainerType getContainerType() {
        return ContainerType.NETWORK;
    }

    public DateTime getCaseDate() {
        return this.caseDate;
    }

    public Network setCaseDate(DateTime caseDate) {
        ValidationUtil.checkCaseDate((Validable)this, (DateTime)caseDate);
        this.caseDate = caseDate;
        return this;
    }

    public int getForecastDistance() {
        return this.forecastDistance;
    }

    public Network setForecastDistance(int forecastDistance) {
        ValidationUtil.checkForecastDistance((Validable)this, (int)forecastDistance);
        this.forecastDistance = forecastDistance;
        return this;
    }

    public String getSourceFormat() {
        return this.sourceFormat;
    }

    @Override
    protected String getTypeDescription() {
        return "Network";
    }

    protected static void transferExtensions(Network from, Network to) {
        new ArrayList<Object>(from.getExtensions()).forEach(e -> Arrays.stream(e.getClass().getInterfaces()).filter(c -> Objects.nonNull(from.getExtension(c))).forEach(clazz -> {
            from.removeExtension(clazz);
            to.addExtension(clazz, (Extension)e);
        }));
    }

    abstract class AbstractBusViewImpl
    implements Network.BusView {
        AbstractBusViewImpl() {
        }

        public Iterable<Bus> getBuses() {
            return FluentIterable.from((Iterable)AbstractNetwork.this.getVoltageLevels()).transformAndConcat(vl -> vl.getBusView().getBuses());
        }

        public Stream<Bus> getBusStream() {
            return AbstractNetwork.this.getVoltageLevelStream().flatMap(vl -> vl.getBusView().getBusStream());
        }
    }

    abstract class AbstractBusBreakerViewImpl
    implements Network.BusBreakerView {
        AbstractBusBreakerViewImpl() {
        }

        public Iterable<Bus> getBuses() {
            return FluentIterable.from((Iterable)AbstractNetwork.this.getVoltageLevels()).transformAndConcat(vl -> vl.getBusBreakerView().getBuses());
        }

        public Stream<Bus> getBusStream() {
            return AbstractNetwork.this.getVoltageLevelStream().flatMap(vl -> vl.getBusBreakerView().getBusStream());
        }

        public int getBusCount() {
            return AbstractNetwork.this.getVoltageLevelStream().mapToInt(vl -> vl.getBusBreakerView().getBusCount()).sum();
        }

        public Iterable<Switch> getSwitches() {
            return FluentIterable.from((Iterable)AbstractNetwork.this.getVoltageLevels()).transformAndConcat(vl -> vl.getBusBreakerView().getSwitches());
        }

        public Stream<Switch> getSwitchStream() {
            return AbstractNetwork.this.getVoltageLevelStream().flatMap(vl -> vl.getBusBreakerView().getSwitchStream());
        }

        public int getSwitchCount() {
            return AbstractNetwork.this.getVoltageLevelStream().mapToInt(vl -> vl.getBusBreakerView().getSwitchCount()).sum();
        }
    }
}

