/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.util.Colors;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.BusbarSectionAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.AbstractIdentifiableAdder;
import com.powsybl.iidm.network.impl.AbstractVoltageLevel;
import com.powsybl.iidm.network.impl.BusAdderImpl;
import com.powsybl.iidm.network.impl.BusExt;
import com.powsybl.iidm.network.impl.BusTerminal;
import com.powsybl.iidm.network.impl.ConfiguredBus;
import com.powsybl.iidm.network.impl.MergedBus;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import com.powsybl.iidm.network.impl.SubstationImpl;
import com.powsybl.iidm.network.impl.SwitchImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.Variant;
import com.powsybl.iidm.network.impl.VariantArray;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.impl.util.Ref;
import com.powsybl.iidm.network.util.Identifiables;
import com.powsybl.iidm.network.util.Networks;
import com.powsybl.iidm.network.util.ShortIdDictionary;
import com.powsybl.math.graph.TraversalType;
import com.powsybl.math.graph.TraverseResult;
import com.powsybl.math.graph.Traverser;
import com.powsybl.math.graph.UndirectedGraphImpl;
import com.powsybl.math.graph.UndirectedGraphListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.anarres.graphviz.builder.GraphVizAttribute;
import org.anarres.graphviz.builder.GraphVizEdge;
import org.anarres.graphviz.builder.GraphVizGraph;
import org.anarres.graphviz.builder.GraphVizNode;
import org.anarres.graphviz.builder.GraphVizScope;

class BusBreakerVoltageLevel
extends AbstractVoltageLevel {
    private static final boolean DRAW_SWITCH_ID = true;
    private final UndirectedGraphImpl<ConfiguredBus, SwitchImpl> graph = new UndirectedGraphImpl(NODE_INDEX_LIMIT);
    private final Map<String, Integer> buses = new HashMap<String, Integer>();
    private final Map<String, Integer> switches = new HashMap<String, Integer>();
    final CalculatedBusTopology calculatedBusTopology = new CalculatedBusTopology();
    protected final VariantArray<VariantImpl> variants;
    private final VoltageLevelExt.NodeBreakerViewExt nodeBreakerView = new VoltageLevelExt.NodeBreakerViewExt(){

        public double getFictitiousP0(int node) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public VoltageLevel.NodeBreakerView setFictitiousP0(int node, double p0) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public double getFictitiousQ0(int node) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public VoltageLevel.NodeBreakerView setFictitiousQ0(int node, double q0) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public int getMaximumNodeIndex() {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public int[] getNodes() {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public int getNode1(String switchId) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public int getNode2(String switchId) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public Terminal getTerminal(int node) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public Stream<Switch> getSwitchStream(int node) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public List<Switch> getSwitches(int node) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public IntStream getNodeInternalConnectedToStream(int node) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public List<Integer> getNodesInternalConnectedTo(int node) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public Optional<Terminal> getOptionalTerminal(int node) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public boolean hasAttachedEquipment(int node) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public Terminal getTerminal1(String switchId) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public Terminal getTerminal2(String switchId) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public VoltageLevel.NodeBreakerView.SwitchAdder newSwitch() {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public VoltageLevel.NodeBreakerView.InternalConnectionAdder newInternalConnection() {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public int getInternalConnectionCount() {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public Iterable<VoltageLevel.NodeBreakerView.InternalConnection> getInternalConnections() {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public Stream<VoltageLevel.NodeBreakerView.InternalConnection> getInternalConnectionStream() {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public void removeInternalConnections(int node1, int node2) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public VoltageLevel.NodeBreakerView.SwitchAdder newBreaker() {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public VoltageLevel.NodeBreakerView.SwitchAdder newDisconnector() {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public Switch getSwitch(String switchId) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public Stream<Switch> getSwitchStream() {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public Iterable<Switch> getSwitches() {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public int getSwitchCount() {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public void removeSwitch(String switchId) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public BusbarSectionAdder newBusbarSection() {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public Iterable<BusbarSection> getBusbarSections() {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public Stream<BusbarSection> getBusbarSectionStream() {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public int getBusbarSectionCount() {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public BusbarSection getBusbarSection(String id) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public void traverse(int node, VoltageLevel.NodeBreakerView.TopologyTraverser traverser) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public void traverse(int[] node, VoltageLevel.NodeBreakerView.TopologyTraverser traverser) {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }
    };
    private final VoltageLevelExt.BusBreakerViewExt busBreakerView = new VoltageLevelExt.BusBreakerViewExt(){

        public Iterable<Bus> getBuses() {
            return Iterables.unmodifiableIterable((Iterable)Iterables.transform((Iterable)BusBreakerVoltageLevel.this.graph.getVerticesObj(), (Function)Functions.identity()));
        }

        public Stream<Bus> getBusStream() {
            return BusBreakerVoltageLevel.this.graph.getVertexObjectStream().map(java.util.function.Function.identity());
        }

        public int getBusCount() {
            return BusBreakerVoltageLevel.this.graph.getVertexCount();
        }

        @Override
        public ConfiguredBus getBus(String id) {
            return BusBreakerVoltageLevel.this.getBus(id, false);
        }

        public BusAdder newBus() {
            return new BusAdderImpl(BusBreakerVoltageLevel.this);
        }

        public void removeBus(String busId) {
            BusBreakerVoltageLevel.this.removeBus(busId);
        }

        public void removeAllBuses() {
            BusBreakerVoltageLevel.this.removeAllBuses();
        }

        public Iterable<Switch> getSwitches() {
            return Iterables.unmodifiableIterable((Iterable)Iterables.transform((Iterable)BusBreakerVoltageLevel.this.graph.getEdgesObject(), (Function)Functions.identity()));
        }

        public Stream<Switch> getSwitchStream() {
            return BusBreakerVoltageLevel.this.graph.getEdgeObjectStream().map(java.util.function.Function.identity());
        }

        public int getSwitchCount() {
            return BusBreakerVoltageLevel.this.graph.getEdgeCount();
        }

        public void removeSwitch(String switchId) {
            BusBreakerVoltageLevel.this.removeSwitch(switchId);
        }

        public void removeAllSwitches() {
            BusBreakerVoltageLevel.this.removeAllSwitches();
        }

        public ConfiguredBus getBus1(String switchId) {
            int e = BusBreakerVoltageLevel.this.getEdge(switchId, true);
            int v1 = BusBreakerVoltageLevel.this.graph.getEdgeVertex1(e);
            return (ConfiguredBus)BusBreakerVoltageLevel.this.graph.getVertexObject(v1);
        }

        public ConfiguredBus getBus2(String switchId) {
            int e = BusBreakerVoltageLevel.this.getEdge(switchId, true);
            int v2 = BusBreakerVoltageLevel.this.graph.getEdgeVertex2(e);
            return (ConfiguredBus)BusBreakerVoltageLevel.this.graph.getVertexObject(v2);
        }

        public Collection<Bus> getBusesFromBusViewBusId(String mergedBusId) {
            return this.getBusStreamFromBusViewBusId(mergedBusId).collect(Collectors.toSet());
        }

        public Stream<Bus> getBusStreamFromBusViewBusId(String mergedBusId) {
            MergedBus bus = (MergedBus)BusBreakerVoltageLevel.this.busView.getBus(mergedBusId);
            Objects.requireNonNull(bus, "bus is null");
            BusBreakerVoltageLevel.this.calculatedBusTopology.updateCache();
            return BusBreakerVoltageLevel.this.variants.get().cache.mapping.entrySet().stream().filter(e -> e.getValue() == bus).map(e -> (Bus)e.getKey()).distinct();
        }

        public SwitchImpl getSwitch(String switchId) {
            return BusBreakerVoltageLevel.this.getSwitch(switchId, false);
        }

        public VoltageLevel.BusBreakerView.SwitchAdder newSwitch() {
            return new SwitchAdderImpl();
        }

        private Traverser adapt(VoltageLevel.BusBreakerView.TopologyTraverser t) {
            return (vertex1, e, vertex2) -> t.traverse((Bus)BusBreakerVoltageLevel.this.graph.getVertexObject(vertex1), (Switch)BusBreakerVoltageLevel.this.graph.getEdgeObject(e), (Bus)BusBreakerVoltageLevel.this.graph.getVertexObject(vertex2));
        }

        public void traverse(Bus bus, VoltageLevel.BusBreakerView.TopologyTraverser traverser) {
            BusBreakerVoltageLevel.this.graph.traverse(BusBreakerVoltageLevel.this.getVertex(bus.getId(), true).intValue(), TraversalType.DEPTH_FIRST, this.adapt(traverser));
        }
    };
    private final VoltageLevelExt.BusViewExt busView = new VoltageLevelExt.BusViewExt(){

        public Iterable<Bus> getBuses() {
            return Collections.unmodifiableCollection(BusBreakerVoltageLevel.this.calculatedBusTopology.getMergedBuses());
        }

        public Stream<Bus> getBusStream() {
            return BusBreakerVoltageLevel.this.calculatedBusTopology.getMergedBuses().stream().map(java.util.function.Function.identity());
        }

        @Override
        public MergedBus getBus(String id) {
            return BusBreakerVoltageLevel.this.calculatedBusTopology.getMergedBus(id, false);
        }

        public Bus getMergedBus(String configuredBusId) {
            ConfiguredBus b = (ConfiguredBus)BusBreakerVoltageLevel.this.busBreakerView.getBus(configuredBusId);
            return BusBreakerVoltageLevel.this.calculatedBusTopology.getMergedBus(b);
        }
    };

    private Integer getVertex(String busId, boolean throwException) {
        Objects.requireNonNull(busId, "bus id is null");
        Integer v = this.buses.get(busId);
        if (throwException && v == null) {
            throw new PowsyblException("Bus " + busId + " not found in voltage level " + this.id);
        }
        return v;
    }

    ConfiguredBus getBus(String busId, boolean throwException) {
        Integer v = this.getVertex(busId, throwException);
        if (v != null) {
            ConfiguredBus bus = (ConfiguredBus)this.graph.getVertexObject(v.intValue());
            if (!bus.getId().equals(busId)) {
                throw new IllegalStateException("Invalid bus id (expected: " + busId + ", actual: " + bus.getId() + ")");
            }
            return bus;
        }
        return null;
    }

    private Integer getEdge(String switchId, boolean throwException) {
        Objects.requireNonNull(switchId, "switch id is null");
        Integer e = this.switches.get(switchId);
        if (throwException && e == null) {
            throw new PowsyblException("Switch " + switchId + " not found in voltage level" + this.id);
        }
        return e;
    }

    private SwitchImpl getSwitch(String switchId, boolean throwException) {
        Integer e = this.getEdge(switchId, throwException);
        if (e != null) {
            SwitchImpl aSwitch = (SwitchImpl)this.graph.getEdgeObject(e.intValue());
            if (!aSwitch.getId().equals(switchId)) {
                throw new IllegalStateException("Invalid switch id (expected: " + switchId + ", actual: " + aSwitch.getId() + ")");
            }
            return aSwitch;
        }
        return null;
    }

    BusBreakerVoltageLevel(String id, String name, boolean fictitious, SubstationImpl substation, Ref<NetworkImpl> ref, Ref<SubnetworkImpl> subnetworkRef, double nominalV, double lowVoltageLimit, double highVoltageLimit) {
        super(id, name, fictitious, substation, ref, subnetworkRef, nominalV, lowVoltageLimit, highVoltageLimit);
        this.variants = new VariantArray<VariantImpl>(ref, VariantImpl::new);
        this.graph.addListener((UndirectedGraphListener)new UndirectedGraphListener<ConfiguredBus, SwitchImpl>(){

            public void vertexAdded(int v) {
                BusBreakerVoltageLevel.this.invalidateCache();
            }

            public void vertexObjectSet(int v, ConfiguredBus obj) {
                BusBreakerVoltageLevel.this.invalidateCache();
            }

            public void vertexRemoved(int v, ConfiguredBus obj) {
                BusBreakerVoltageLevel.this.invalidateCache();
            }

            public void allVerticesRemoved() {
                BusBreakerVoltageLevel.this.invalidateCache();
            }

            public void edgeAdded(int e, SwitchImpl obj) {
                BusBreakerVoltageLevel.this.invalidateCache();
            }

            public void edgeBeforeRemoval(int e, SwitchImpl obj) {
            }

            public void edgeRemoved(int e, SwitchImpl obj) {
                BusBreakerVoltageLevel.this.invalidateCache();
            }

            public void allEdgesBeforeRemoval(Collection<SwitchImpl> obj) {
            }

            public void allEdgesRemoved(Collection<SwitchImpl> obj) {
                BusBreakerVoltageLevel.this.invalidateCache();
            }
        });
    }

    @Override
    public void invalidateCache(boolean exceptBusBreakerView) {
        this.calculatedBusTopology.invalidateCache();
        this.getNetwork().getBusView().invalidateCache();
        this.getNetwork().getBusBreakerView().invalidateCache();
        this.getNetwork().getConnectedComponentsManager().invalidate();
        this.getNetwork().getSynchronousComponentsManager().invalidate();
    }

    @Override
    public Iterable<Terminal> getTerminals() {
        return FluentIterable.from((Iterable)this.graph.getVerticesObj()).transformAndConcat(ConfiguredBus::getTerminals).transform(Terminal.class::cast);
    }

    @Override
    public Stream<Terminal> getTerminalStream() {
        return this.graph.getVertexObjectStream().flatMap(bus -> bus.getTerminals().stream());
    }

    static PowsyblException createNotSupportedBusBreakerTopologyException() {
        return new PowsyblException("Not supported in a bus breaker topology");
    }

    @Override
    public VoltageLevelExt.NodeBreakerViewExt getNodeBreakerView() {
        return this.nodeBreakerView;
    }

    @Override
    public VoltageLevelExt.BusBreakerViewExt getBusBreakerView() {
        return this.busBreakerView;
    }

    @Override
    public VoltageLevelExt.BusViewExt getBusView() {
        return this.busView;
    }

    public Iterable<Switch> getSwitches() {
        return this.getBusBreakerView().getSwitches();
    }

    public int getSwitchCount() {
        return this.getBusBreakerView().getSwitchCount();
    }

    public TopologyKind getTopologyKind() {
        return TopologyKind.BUS_BREAKER;
    }

    void addBus(ConfiguredBus bus) {
        this.getNetwork().getIndex().checkAndAdd((Identifiable<?>)bus);
        int v = this.graph.addVertex();
        this.graph.setVertexObject(v, (Object)bus);
        this.buses.put(bus.getId(), v);
    }

    private void removeBus(String busId) {
        ConfiguredBus bus = this.getBus(busId, true);
        if (bus.getTerminalCount() > 0) {
            throw new ValidationException((Validable)this, "Cannot remove bus " + bus.getId() + " because of connectable equipments");
        }
        for (Map.Entry<String, Integer> entry : this.switches.entrySet()) {
            String switchId = entry.getKey();
            int e = entry.getValue();
            int v1 = this.graph.getEdgeVertex1(e);
            int v2 = this.graph.getEdgeVertex2(e);
            ConfiguredBus b1 = (ConfiguredBus)this.graph.getVertexObject(v1);
            ConfiguredBus b2 = (ConfiguredBus)this.graph.getVertexObject(v2);
            if (bus != b1 && bus != b2) continue;
            throw new PowsyblException("Cannot remove bus '" + bus.getId() + "' because switch '" + switchId + "' is connected to it");
        }
        NetworkImpl network = this.getNetwork();
        network.getListeners().notifyBeforeRemoval((Identifiable)bus);
        network.getIndex().remove((Identifiable)bus);
        int v = this.buses.remove(bus.getId());
        this.graph.removeVertex(v);
        network.getListeners().notifyAfterRemoval(busId);
    }

    private void removeAllBuses() {
        if (this.graph.getEdgeCount() > 0) {
            throw new ValidationException((Validable)this, "Cannot remove all buses because there is still some switches");
        }
        for (ConfiguredBus bus : this.graph.getVerticesObj()) {
            if (bus.getTerminalCount() <= 0) continue;
            throw new ValidationException((Validable)this, "Cannot remove bus " + bus.getId() + " because of connected equipments");
        }
        NetworkImpl network = this.getNetwork();
        ArrayList<String> removedBusesIds = new ArrayList<String>(this.graph.getVertexCount());
        for (ConfiguredBus bus : this.graph.getVerticesObj()) {
            removedBusesIds.add(bus.getId());
            network.getListeners().notifyBeforeRemoval((Identifiable)bus);
            network.getIndex().remove((Identifiable)bus);
        }
        this.graph.removeAllVertices();
        this.buses.clear();
        removedBusesIds.forEach(id -> network.getListeners().notifyAfterRemoval((String)id));
    }

    private void addSwitch(SwitchImpl aSwitch, String busId1, String busId2) {
        int v1 = this.getVertex(busId1, true);
        int v2 = this.getVertex(busId2, true);
        this.getNetwork().getIndex().checkAndAdd(aSwitch);
        int e = this.graph.addEdge(v1, v2, (Object)aSwitch);
        this.switches.put(aSwitch.getId(), e);
    }

    private void removeSwitch(String switchId) {
        Integer e = this.switches.get(switchId);
        if (e == null) {
            throw new PowsyblException("Switch '" + switchId + "' not found in voltage level '" + this.id + "'");
        }
        NetworkImpl network = this.getNetwork();
        SwitchImpl aSwitch = (SwitchImpl)this.graph.getEdgeObject(e.intValue());
        network.getListeners().notifyBeforeRemoval(aSwitch);
        this.switches.remove(switchId);
        this.graph.removeEdge(e.intValue());
        network.getIndex().remove(aSwitch);
        network.getListeners().notifyAfterRemoval(switchId);
    }

    private void removeAllSwitches() {
        NetworkImpl network = this.getNetwork();
        ArrayList<String> removedSwitchesIds = new ArrayList<String>(this.graph.getEdgeCount());
        for (SwitchImpl s : this.graph.getEdgesObject()) {
            removedSwitchesIds.add(s.getId());
            network.getListeners().notifyBeforeRemoval(s);
            network.getIndex().remove(s);
        }
        this.graph.removeAllEdges();
        this.switches.clear();
        for (String removedSwitchId : removedSwitchesIds) {
            network.getListeners().notifyAfterRemoval(removedSwitchId);
        }
    }

    private void checkTerminal(TerminalExt terminal) {
        if (!(terminal instanceof BusTerminal)) {
            throw new ValidationException((Validable)terminal.getConnectable(), "voltage level " + this.id + " has a bus/breaker topology, a bus connection should be specified instead of a node connection");
        }
        String connectableBusId = ((BusTerminal)terminal).getConnectableBusId();
        if (connectableBusId != null) {
            this.getBus(connectableBusId, true);
        }
    }

    @Override
    public void attach(TerminalExt terminal, boolean test) {
        this.checkTerminal(terminal);
        if (test) {
            return;
        }
        terminal.setVoltageLevel(this);
        String connectableBusId = ((BusTerminal)terminal).getConnectableBusId();
        ConfiguredBus connectableBus = this.getBus(connectableBusId, true);
        this.getNetwork().getVariantManager().forEachVariant(() -> {
            connectableBus.addTerminal((BusTerminal)terminal);
            this.invalidateCache();
        });
    }

    @Override
    public void detach(TerminalExt terminal) {
        if (!(terminal instanceof BusTerminal)) {
            throw new IllegalArgumentException("Incorrect terminal type");
        }
        String connectableBusId = ((BusTerminal)terminal).getConnectableBusId();
        ConfiguredBus connectableBus = this.getBus(connectableBusId, true);
        this.getNetwork().getVariantManager().forEachVariant(() -> {
            connectableBus.removeTerminal((BusTerminal)terminal);
            ((BusTerminal)terminal).setConnectableBusId(null);
            this.invalidateCache();
        });
        terminal.setVoltageLevel(null);
    }

    @Override
    public boolean connect(TerminalExt terminal) {
        if (!(terminal instanceof BusTerminal)) {
            throw new IllegalStateException("Given TerminalExt not supported: " + terminal.getClass().getName());
        }
        if (terminal.isConnected()) {
            return false;
        }
        ((BusTerminal)terminal).setConnected(true);
        this.invalidateCache();
        return true;
    }

    @Override
    public boolean disconnect(TerminalExt terminal) {
        if (!(terminal instanceof BusTerminal)) {
            throw new IllegalStateException("Given TerminalExt not supported: " + terminal.getClass().getName());
        }
        if (!terminal.isConnected()) {
            return false;
        }
        ((BusTerminal)terminal).setConnected(false);
        this.invalidateCache();
        return true;
    }

    void traverse(BusTerminal terminal, Terminal.TopologyTraverser traverser, TraversalType traversalType) {
        this.traverse(terminal, traverser, new HashSet<Terminal>(), traversalType);
    }

    boolean traverse(BusTerminal terminal, Terminal.TopologyTraverser traverser, Set<Terminal> visitedTerminals, TraversalType traversalType) {
        Objects.requireNonNull(terminal);
        Objects.requireNonNull(traverser);
        Objects.requireNonNull(visitedTerminals);
        TraverseResult termTraverseResult = BusBreakerVoltageLevel.getTraverserResult(visitedTerminals, terminal, traverser);
        if (termTraverseResult == TraverseResult.TERMINATE_TRAVERSER) {
            return false;
        }
        if (termTraverseResult == TraverseResult.CONTINUE) {
            boolean traversalTerminated;
            ArrayList<TerminalExt> nextTerminals = new ArrayList<TerminalExt>();
            BusBreakerVoltageLevel.addNextTerminals(terminal, nextTerminals);
            int v = this.getVertex(terminal.getConnectableBusId(), true);
            ConfiguredBus bus = (ConfiguredBus)this.graph.getVertexObject(v);
            for (BusTerminal t : bus.getTerminals()) {
                TraverseResult tTraverseResult = BusBreakerVoltageLevel.getTraverserResult(visitedTerminals, t, traverser);
                if (tTraverseResult == TraverseResult.TERMINATE_TRAVERSER) {
                    return false;
                }
                if (tTraverseResult != TraverseResult.CONTINUE) continue;
                BusBreakerVoltageLevel.addNextTerminals(t, nextTerminals);
            }
            boolean bl = traversalTerminated = !this.graph.traverse(v, traversalType, (v1, e, v2) -> {
                SwitchImpl aSwitch = (SwitchImpl)this.graph.getEdgeObject(e);
                List<BusTerminal> otherBusTerminals = ((ConfiguredBus)this.graph.getVertexObject(v2)).getTerminals();
                TraverseResult switchTraverseResult = traverser.traverse((Switch)aSwitch);
                if (switchTraverseResult == TraverseResult.CONTINUE && !otherBusTerminals.isEmpty()) {
                    BusTerminal otherTerminal = otherBusTerminals.get(0);
                    TraverseResult otherTermTraverseResult = BusBreakerVoltageLevel.getTraverserResult(visitedTerminals, otherTerminal, traverser);
                    if (otherTermTraverseResult == TraverseResult.CONTINUE) {
                        BusBreakerVoltageLevel.addNextTerminals(otherTerminal, nextTerminals);
                    }
                    return otherTermTraverseResult;
                }
                return switchTraverseResult;
            });
            if (traversalTerminated) {
                return false;
            }
            for (TerminalExt t : nextTerminals) {
                if (t.traverse(traverser, visitedTerminals, traversalType)) continue;
                return false;
            }
        }
        return true;
    }

    private static TraverseResult getTraverserResult(Set<Terminal> visitedTerminals, BusTerminal terminal, Terminal.TopologyTraverser traverser) {
        return visitedTerminals.add(terminal) ? traverser.traverse((Terminal)terminal, terminal.isConnected()) : TraverseResult.TERMINATE_PATH;
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.variants.push(number, () -> this.variants.copy(sourceIndex));
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.variants.pop(number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
        this.variants.delete(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        this.variants.allocate(indexes, () -> this.variants.copy(sourceIndex));
    }

    @Override
    protected void removeTopology() {
        this.removeAllSwitches();
        this.removeAllBuses();
    }

    public void printTopology() {
        this.printTopology(System.out, null);
    }

    public void printTopology(PrintStream out, ShortIdDictionary dict) {
        out.println("-------------------------------------------------------------");
        out.println("Topology of " + this.id);
        java.util.function.Function<ConfiguredBus, String> vertexToString = bus -> {
            StringBuilder builder = new StringBuilder();
            builder.append(bus.getId()).append(" [");
            Iterator<TerminalExt> it = bus.getConnectedTerminals().iterator();
            while (it.hasNext()) {
                TerminalExt terminal = it.next();
                builder.append(dict != null ? dict.getShortId(terminal.getConnectable().getId()) : terminal.getConnectable().getId());
                if (!it.hasNext()) continue;
                builder.append(", ");
            }
            builder.append("]");
            return builder.toString();
        };
        java.util.function.Function<SwitchImpl, String> edgeToString = aSwitch -> {
            StringBuilder builder = new StringBuilder();
            builder.append("id=").append(aSwitch.getId()).append(" status=").append(aSwitch.isOpen() ? "open" : "closed");
            return builder.toString();
        };
        this.graph.print(out, vertexToString, edgeToString);
    }

    public void exportTopology(Path file) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.exportTopology(writer);
        }
    }

    public void exportTopology(Writer writer) {
        this.exportTopology(writer, new SecureRandom());
    }

    public void exportTopology(Writer writer, Random random) {
        AbstractConnectable connectable;
        Objects.requireNonNull(writer);
        Objects.requireNonNull(random);
        GraphVizScope.Impl scope = new GraphVizScope.Impl();
        GraphVizGraph gvGraph = new GraphVizGraph();
        String[] colors = Colors.generateColorScale((int)this.graph.getVertexCount(), (Random)random);
        int i = 0;
        for (ConfiguredBus bus : this.graph.getVerticesObj()) {
            ((GraphVizNode)((GraphVizNode)gvGraph.node((GraphVizScope)scope, (Object)bus.getId()).label((CharSequence)("BUS" + System.lineSeparator() + bus.getId()))).shape("ellipse").style("filled")).attr(GraphVizAttribute.fillcolor, colors[i]);
            for (TerminalExt terminalExt : bus.getTerminals()) {
                connectable = terminalExt.getConnectable();
                String label = connectable.getType().toString() + System.lineSeparator() + connectable.getId() + connectable.getOptionalName().map(name -> System.lineSeparator() + name).orElse("");
                ((GraphVizNode)((GraphVizNode)gvGraph.node((GraphVizScope)scope, (Object)connectable.getId()).label((CharSequence)label)).shape("ellipse").style("filled")).attr(GraphVizAttribute.fillcolor, colors[i]);
            }
            ++i;
        }
        for (ConfiguredBus bus : this.graph.getVerticesObj()) {
            for (TerminalExt terminalExt : bus.getTerminals()) {
                connectable = terminalExt.getConnectable();
                gvGraph.edge((GraphVizScope)scope, (Object)bus.getId(), (Object)connectable.getId()).style(terminalExt.isConnected() ? "solid" : "dotted");
            }
        }
        for (int e = 0; e < this.graph.getEdgeCount(); ++e) {
            int v1 = this.graph.getEdgeVertex1(e);
            int v2 = this.graph.getEdgeVertex2(e);
            SwitchImpl switchImpl = (SwitchImpl)this.graph.getEdgeObject(e);
            ConfiguredBus bus1 = (ConfiguredBus)this.graph.getVertexObject(v1);
            ConfiguredBus bus2 = (ConfiguredBus)this.graph.getVertexObject(v2);
            GraphVizEdge edge = (GraphVizEdge)gvGraph.edge((GraphVizScope)scope, (Object)bus1.getId(), (Object)bus2.getId(), (Object)switchImpl.getId()).style(switchImpl.isOpen() ? "dotted" : "solid");
            String label = switchImpl.getKind().toString() + System.lineSeparator() + switchImpl.getId() + switchImpl.getOptionalName().map(n -> System.lineSeparator() + n).orElse("");
            ((GraphVizEdge)edge.label((CharSequence)label)).attr(GraphVizAttribute.fontsize, "10");
        }
        try {
            gvGraph.writeTo(writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    class CalculatedBusTopology {
        CalculatedBusTopology() {
        }

        protected boolean isBusValid(Set<ConfiguredBus> busSet) {
            int feederCount = 0;
            block3: for (TerminalExt terminal : FluentIterable.from(busSet).transformAndConcat(BusExt::getConnectedTerminals)) {
                AbstractConnectable connectable = terminal.getConnectable();
                switch (connectable.getType()) {
                    case LINE: 
                    case TWO_WINDINGS_TRANSFORMER: 
                    case THREE_WINDINGS_TRANSFORMER: 
                    case HVDC_CONVERTER_STATION: 
                    case DANGLING_LINE: 
                    case LOAD: 
                    case GENERATOR: 
                    case BATTERY: 
                    case SHUNT_COMPENSATOR: 
                    case STATIC_VAR_COMPENSATOR: {
                        ++feederCount;
                        continue block3;
                    }
                }
                throw new IllegalStateException();
            }
            return Networks.isBusValid((int)feederCount);
        }

        private MergedBus createMergedBus(int busNum, Set<ConfiguredBus> busSet) {
            String suffix = "_" + busNum;
            String mergedBusId = Identifiables.getUniqueId((String)(BusBreakerVoltageLevel.this.id + suffix), BusBreakerVoltageLevel.this.getNetwork().getIndex()::contains);
            String mergedBusName = BusBreakerVoltageLevel.this.name != null ? BusBreakerVoltageLevel.this.name + suffix : null;
            return new MergedBus(mergedBusId, mergedBusName, BusBreakerVoltageLevel.this.fictitious, busSet);
        }

        private void updateCache() {
            if (BusBreakerVoltageLevel.this.variants.get().cache != null) {
                return;
            }
            LinkedHashMap<String, MergedBus> mergedBuses = new LinkedHashMap<String, MergedBus>();
            IdentityHashMap<ConfiguredBus, MergedBus> mapping = new IdentityHashMap<ConfiguredBus, MergedBus>();
            boolean[] encountered = new boolean[BusBreakerVoltageLevel.this.graph.getVertexCapacity()];
            Arrays.fill(encountered, false);
            int busNum = 0;
            for (int v : BusBreakerVoltageLevel.this.graph.getVertices()) {
                if (encountered[v]) continue;
                LinkedHashSet<ConfiguredBus> busSet = new LinkedHashSet<ConfiguredBus>(1);
                busSet.add((ConfiguredBus)BusBreakerVoltageLevel.this.graph.getVertexObject(v));
                BusBreakerVoltageLevel.this.graph.traverse(v, TraversalType.DEPTH_FIRST, (v1, e, v2) -> {
                    SwitchImpl aSwitch = (SwitchImpl)BusBreakerVoltageLevel.this.graph.getEdgeObject(e);
                    if (aSwitch.isOpen()) {
                        return TraverseResult.TERMINATE_PATH;
                    }
                    busSet.add((ConfiguredBus)BusBreakerVoltageLevel.this.graph.getVertexObject(v2));
                    return TraverseResult.CONTINUE;
                }, encountered);
                if (!this.isBusValid(busSet)) continue;
                MergedBus mergedBus = this.createMergedBus(busNum++, busSet);
                mergedBuses.put(mergedBus.getId(), mergedBus);
                busSet.forEach(bus -> mapping.put((ConfiguredBus)bus, mergedBus));
            }
            BusBreakerVoltageLevel.this.variants.get().cache = new BusCache(mergedBuses, mapping);
        }

        private void invalidateCache() {
            if (BusBreakerVoltageLevel.this.variants.get().cache != null) {
                for (MergedBus bus : BusBreakerVoltageLevel.this.variants.get().cache.getMergedBuses()) {
                    bus.invalidate();
                }
                BusBreakerVoltageLevel.this.variants.get().cache = null;
            }
        }

        private Collection<MergedBus> getMergedBuses() {
            this.updateCache();
            return BusBreakerVoltageLevel.this.variants.get().cache.getMergedBuses();
        }

        private MergedBus getMergedBus(String mergedBusId, boolean throwException) {
            this.updateCache();
            MergedBus bus = BusBreakerVoltageLevel.this.variants.get().cache.getMergedBus(mergedBusId);
            if (throwException && bus == null) {
                throw new PowsyblException("Bus " + mergedBusId + " not found in voltage level " + BusBreakerVoltageLevel.this.id);
            }
            return bus;
        }

        MergedBus getMergedBus(ConfiguredBus bus) {
            Objects.requireNonNull(bus, "bus is null");
            this.updateCache();
            return BusBreakerVoltageLevel.this.variants.get().cache.getMergedBus(bus);
        }
    }

    private static final class VariantImpl
    implements Variant {
        private BusCache cache;

        private VariantImpl() {
        }

        public VariantImpl copy() {
            return new VariantImpl();
        }
    }

    private static final class BusCache {
        private final Map<String, MergedBus> mergedBus;
        private final Map<ConfiguredBus, MergedBus> mapping;

        private BusCache(Map<String, MergedBus> mergedBus, Map<ConfiguredBus, MergedBus> mapping) {
            this.mergedBus = mergedBus;
            this.mapping = mapping;
        }

        private Collection<MergedBus> getMergedBuses() {
            return this.mergedBus.values();
        }

        private MergedBus getMergedBus(String id) {
            return this.mergedBus.get(id);
        }

        private MergedBus getMergedBus(ConfiguredBus cfgBus) {
            return this.mapping.get(cfgBus);
        }
    }

    private final class SwitchAdderImpl
    extends AbstractIdentifiableAdder<SwitchAdderImpl>
    implements VoltageLevel.BusBreakerView.SwitchAdder {
        private String busId1;
        private String busId2;
        private boolean open = false;

        private SwitchAdderImpl() {
        }

        @Override
        protected NetworkImpl getNetwork() {
            return BusBreakerVoltageLevel.this.getNetwork();
        }

        @Override
        protected String getTypeDescription() {
            return "Switch";
        }

        public VoltageLevel.BusBreakerView.SwitchAdder setBus1(String bus1) {
            this.busId1 = bus1;
            return this;
        }

        public VoltageLevel.BusBreakerView.SwitchAdder setBus2(String bus2) {
            this.busId2 = bus2;
            return this;
        }

        public VoltageLevel.BusBreakerView.SwitchAdder setOpen(boolean open) {
            this.open = open;
            return this;
        }

        public Switch add() {
            String id = this.checkAndGetUniqueId();
            if (this.busId1 == null) {
                throw new ValidationException((Validable)this, "first connection bus is not set");
            }
            if (this.busId2 == null) {
                throw new ValidationException((Validable)this, "second connection bus is not set");
            }
            if (this.busId1.equals(this.busId2)) {
                throw new ValidationException((Validable)this, "same bus at both ends");
            }
            SwitchImpl aSwitch = new SwitchImpl(BusBreakerVoltageLevel.this, id, this.getName(), this.isFictitious(), SwitchKind.BREAKER, this.open, true);
            BusBreakerVoltageLevel.this.addSwitch(aSwitch, this.busId1, this.busId2);
            this.getNetwork().getListeners().notifyCreation(aSwitch);
            return aSwitch;
        }
    }
}

