/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.util.trove.TBooleanArrayList;
import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.Boundary;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.OperationalLimits;
import com.powsybl.iidm.network.ReactiveLimits;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.MinMaxReactiveLimitsAdderImpl;
import com.powsybl.iidm.network.impl.MinMaxReactiveLimitsImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.NetworkIndex;
import com.powsybl.iidm.network.impl.OperationalLimitsHolderImpl;
import com.powsybl.iidm.network.impl.ReactiveCapabilityCurveAdderImpl;
import com.powsybl.iidm.network.impl.ReactiveLimitsHolderImpl;
import com.powsybl.iidm.network.impl.ReactiveLimitsOwner;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.TieLineImpl;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import com.powsybl.iidm.network.impl.util.Ref;
import com.powsybl.iidm.network.util.DanglingLineBoundaryImpl;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

class DanglingLineImpl
extends AbstractConnectable<DanglingLine>
implements DanglingLine {
    private final Ref<NetworkImpl> network;
    private TieLineImpl tieLine = null;
    private double r;
    private double x;
    private double g;
    private double b;
    private final String pairingKey;
    private final GenerationImpl generation;
    private final OperationalLimitsHolderImpl operationalLimitsHolder;
    private final TDoubleArrayList p0;
    private final TDoubleArrayList q0;
    private final DanglingLineBoundaryImpl boundary;

    DanglingLineImpl(Ref<NetworkImpl> network, String id, String name, boolean fictitious, double p0, double q0, double r, double x, double g, double b, String pairingKey, GenerationImpl generation) {
        super(network, id, name, fictitious);
        this.network = network;
        int variantArraySize = network.get().getVariantManager().getVariantArraySize();
        this.p0 = new TDoubleArrayList(variantArraySize);
        this.q0 = new TDoubleArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.p0.add(p0);
            this.q0.add(q0);
        }
        this.r = r;
        this.x = x;
        this.g = g;
        this.b = b;
        this.pairingKey = pairingKey;
        this.operationalLimitsHolder = new OperationalLimitsHolderImpl(this, "limits");
        this.boundary = new DanglingLineBoundaryImpl((DanglingLine)this);
        this.generation = generation != null ? generation.attach(this) : null;
    }

    @Override
    void replaceId(String newId) {
        NetworkIndex.checkId(newId);
        this.network.get().getIndex().remove(this);
        this.id = newId;
        this.network.get().getIndex().checkAndAdd(this);
    }

    OperationalLimitsHolderImpl getLimitsHolder() {
        return this.operationalLimitsHolder;
    }

    void setTieLine(TieLineImpl tieLine) {
        this.tieLine = tieLine;
    }

    public TerminalExt getTerminal() {
        return (TerminalExt)this.terminals.get(0);
    }

    public Optional<TieLine> getTieLine() {
        return Optional.ofNullable(this.tieLine);
    }

    @Override
    public void remove() {
        if (this.tieLine != null) {
            throw new UnsupportedOperationException("Parent tie line " + this.tieLine.getId() + " should be removed before the child dangling line");
        }
        super.remove();
    }

    void removeTieLine() {
        this.tieLine = null;
    }

    @Override
    protected String getTypeDescription() {
        return "Dangling line";
    }

    public boolean isPaired() {
        return this.tieLine != null;
    }

    public double getP0() {
        return this.p0.get(this.network.get().getVariantIndex());
    }

    public DanglingLineImpl setP0(double p0) {
        NetworkImpl n = this.getNetwork();
        int variantIndex = n.getVariantIndex();
        double oldValue = this.p0.set(variantIndex, p0);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("p0", variantId, (Object)oldValue, (Object)p0);
        return this;
    }

    public double getQ0() {
        return this.q0.get(this.network.get().getVariantIndex());
    }

    public DanglingLineImpl setQ0(double q0) {
        NetworkImpl n = this.getNetwork();
        int variantIndex = n.getVariantIndex();
        double oldValue = this.q0.set(variantIndex, q0);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("q0", variantId, (Object)oldValue, (Object)q0);
        return this;
    }

    public double getR() {
        return this.r;
    }

    public DanglingLineImpl setR(double r) {
        ValidationUtil.checkR((Validable)this, (double)r);
        double oldValue = this.r;
        this.r = r;
        this.notifyUpdate("r", (Object)oldValue, (Object)r);
        return this;
    }

    public double getX() {
        return this.x;
    }

    public DanglingLineImpl setX(double x) {
        ValidationUtil.checkX((Validable)this, (double)x);
        double oldValue = this.x;
        this.x = x;
        this.notifyUpdate("x", (Object)oldValue, (Object)x);
        return this;
    }

    public double getG() {
        return this.g;
    }

    public DanglingLineImpl setG(double g) {
        ValidationUtil.checkG((Validable)this, (double)g);
        double oldValue = this.g;
        this.g = g;
        this.notifyUpdate("g", (Object)oldValue, (Object)g);
        return this;
    }

    public double getB() {
        return this.b;
    }

    public DanglingLineImpl setB(double b) {
        ValidationUtil.checkB((Validable)this, (double)b);
        double oldValue = this.b;
        this.b = b;
        this.notifyUpdate("b", (Object)oldValue, (Object)b);
        return this;
    }

    public String getPairingKey() {
        return this.pairingKey;
    }

    public DanglingLine.Generation getGeneration() {
        return this.generation;
    }

    public Collection<OperationalLimits> getOperationalLimits() {
        return this.operationalLimitsHolder.getOperationalLimits();
    }

    public Optional<CurrentLimits> getCurrentLimits() {
        return this.operationalLimitsHolder.getOperationalLimits(LimitType.CURRENT, CurrentLimits.class);
    }

    public CurrentLimits getNullableCurrentLimits() {
        return this.operationalLimitsHolder.getNullableOperationalLimits(LimitType.CURRENT, CurrentLimits.class);
    }

    public Optional<ActivePowerLimits> getActivePowerLimits() {
        return this.operationalLimitsHolder.getOperationalLimits(LimitType.ACTIVE_POWER, ActivePowerLimits.class);
    }

    public ActivePowerLimits getNullableActivePowerLimits() {
        return this.operationalLimitsHolder.getNullableOperationalLimits(LimitType.ACTIVE_POWER, ActivePowerLimits.class);
    }

    public Optional<ApparentPowerLimits> getApparentPowerLimits() {
        return this.operationalLimitsHolder.getOperationalLimits(LimitType.APPARENT_POWER, ApparentPowerLimits.class);
    }

    public ApparentPowerLimits getNullableApparentPowerLimits() {
        return this.operationalLimitsHolder.getNullableOperationalLimits(LimitType.APPARENT_POWER, ApparentPowerLimits.class);
    }

    public CurrentLimitsAdder newCurrentLimits() {
        return this.operationalLimitsHolder.newCurrentLimits();
    }

    public ActivePowerLimitsAdder newActivePowerLimits() {
        return this.operationalLimitsHolder.newActivePowerLimits();
    }

    public ApparentPowerLimitsAdder newApparentPowerLimits() {
        return this.operationalLimitsHolder.newApparentPowerLimits();
    }

    public Boundary getBoundary() {
        return this.boundary;
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.p0.ensureCapacity(this.p0.size() + number);
        this.q0.ensureCapacity(this.q0.size() + number);
        for (int i = 0; i < number; ++i) {
            this.p0.add(this.p0.get(sourceIndex));
            this.q0.add(this.q0.get(sourceIndex));
        }
        if (this.generation != null) {
            this.generation.extendVariantArraySize(number, sourceIndex);
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.p0.remove(this.p0.size() - number, number);
        this.q0.remove(this.q0.size() - number, number);
        if (this.generation != null) {
            this.generation.reduceVariantArraySize(number);
        }
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.p0.set(index, this.p0.get(sourceIndex));
            this.q0.set(index, this.q0.get(sourceIndex));
        }
        if (this.generation != null) {
            this.generation.allocateVariantArrayElement(indexes, sourceIndex);
        }
    }

    static class GenerationImpl
    implements DanglingLine.Generation,
    ReactiveLimitsOwner,
    Validable {
        private DanglingLineImpl danglingLine;
        private ReactiveLimitsHolderImpl reactiveLimits;
        private double minP;
        private double maxP;
        private final TDoubleArrayList targetP;
        private final TDoubleArrayList targetQ;
        private final TDoubleArrayList targetV;
        private final TBooleanArrayList voltageRegulationOn;

        GenerationImpl(VariantManagerHolder network, double minP, double maxP, double targetP, double targetQ, double targetV, boolean voltageRegulationOn) {
            this.minP = Double.isNaN(minP) ? -1.7976931348623157E308 : minP;
            this.maxP = Double.isNaN(maxP) ? Double.MAX_VALUE : maxP;
            int variantArraySize = network.getVariantManager().getVariantArraySize();
            this.targetP = new TDoubleArrayList(variantArraySize);
            this.targetQ = new TDoubleArrayList(variantArraySize);
            this.targetV = new TDoubleArrayList(variantArraySize);
            this.voltageRegulationOn = new TBooleanArrayList(variantArraySize);
            for (int i = 0; i < variantArraySize; ++i) {
                this.targetP.add(targetP);
                this.targetQ.add(targetQ);
                this.targetV.add(targetV);
                this.voltageRegulationOn.add(voltageRegulationOn);
            }
        }

        GenerationImpl attach(DanglingLineImpl danglingLine) {
            if (this.danglingLine != null) {
                throw new IllegalStateException("DanglingLine.Generation already attached to " + this.danglingLine.getId());
            }
            this.danglingLine = Objects.requireNonNull(danglingLine);
            this.reactiveLimits = new ReactiveLimitsHolderImpl(this.danglingLine, (ReactiveLimits)new MinMaxReactiveLimitsImpl(-1.7976931348623157E308, Double.MAX_VALUE));
            return this;
        }

        public double getTargetP() {
            return this.targetP.get(this.danglingLine.getNetwork().getVariantIndex());
        }

        public GenerationImpl setTargetP(double targetP) {
            NetworkImpl n = this.danglingLine.getNetwork();
            ValidationUtil.checkActivePowerSetpoint((Validable)this.danglingLine, (double)targetP, (ValidationLevel)n.getMinValidationLevel());
            int variantIndex = this.danglingLine.network.get().getVariantIndex();
            double oldValue = this.targetP.set(variantIndex, targetP);
            String variantId = this.danglingLine.network.get().getVariantManager().getVariantId(variantIndex);
            n.invalidateValidationLevel();
            this.danglingLine.notifyUpdate("targetP", variantId, (Object)oldValue, (Object)targetP);
            return this;
        }

        public double getMaxP() {
            return this.maxP;
        }

        public GenerationImpl setMaxP(double maxP) {
            ValidationUtil.checkMaxP((Validable)this.danglingLine, (double)maxP);
            ValidationUtil.checkActivePowerLimits((Validable)this.danglingLine, (double)this.minP, (double)maxP);
            double oldValue = this.maxP;
            this.maxP = maxP;
            this.danglingLine.notifyUpdate("maxP", (Object)oldValue, (Object)maxP);
            return this;
        }

        public double getMinP() {
            return this.minP;
        }

        public GenerationImpl setMinP(double minP) {
            ValidationUtil.checkMinP((Validable)this.danglingLine, (double)minP);
            ValidationUtil.checkActivePowerLimits((Validable)this.danglingLine, (double)minP, (double)this.maxP);
            double oldValue = this.minP;
            this.minP = minP;
            this.danglingLine.notifyUpdate("minP", (Object)oldValue, (Object)minP);
            return this;
        }

        public double getTargetQ() {
            return this.targetQ.get(this.danglingLine.getNetwork().getVariantIndex());
        }

        public GenerationImpl setTargetQ(double targetQ) {
            NetworkImpl n = this.danglingLine.getNetwork();
            int variantIndex = n.getVariantIndex();
            ValidationUtil.checkVoltageControl((Validable)this.danglingLine, (Boolean)this.voltageRegulationOn.get(variantIndex), (double)this.targetV.get(variantIndex), (double)targetQ, (ValidationLevel)n.getMinValidationLevel());
            double oldValue = this.targetQ.set(variantIndex, targetQ);
            String variantId = n.getVariantManager().getVariantId(variantIndex);
            n.invalidateValidationLevel();
            this.danglingLine.notifyUpdate("targetQ", variantId, (Object)oldValue, (Object)targetQ);
            return this;
        }

        public boolean isVoltageRegulationOn() {
            return this.voltageRegulationOn.get(this.danglingLine.getNetwork().getVariantIndex());
        }

        public GenerationImpl setVoltageRegulationOn(boolean voltageRegulationOn) {
            NetworkImpl n = this.danglingLine.getNetwork();
            int variantIndex = this.danglingLine.getNetwork().getVariantIndex();
            ValidationUtil.checkVoltageControl((Validable)this.danglingLine, (Boolean)voltageRegulationOn, (double)this.targetV.get(variantIndex), (double)this.targetQ.get(variantIndex), (ValidationLevel)n.getMinValidationLevel());
            boolean oldValue = this.voltageRegulationOn.get(variantIndex);
            this.voltageRegulationOn.set(variantIndex, voltageRegulationOn);
            String variantId = this.danglingLine.getNetwork().getVariantManager().getVariantId(variantIndex);
            n.invalidateValidationLevel();
            this.danglingLine.notifyUpdate("voltageRegulationOn", variantId, (Object)oldValue, (Object)voltageRegulationOn);
            return this;
        }

        public double getTargetV() {
            return this.targetV.get(this.danglingLine.getNetwork().getVariantIndex());
        }

        public GenerationImpl setTargetV(double targetV) {
            NetworkImpl n = this.danglingLine.getNetwork();
            int variantIndex = this.danglingLine.getNetwork().getVariantIndex();
            ValidationUtil.checkVoltageControl((Validable)this.danglingLine, (Boolean)this.voltageRegulationOn.get(variantIndex), (double)targetV, (double)this.targetQ.get(variantIndex), (ValidationLevel)n.getMinValidationLevel());
            double oldValue = this.targetV.set(variantIndex, targetV);
            String variantId = this.danglingLine.getNetwork().getVariantManager().getVariantId(variantIndex);
            n.invalidateValidationLevel();
            this.danglingLine.notifyUpdate("targetV", variantId, (Object)oldValue, (Object)targetV);
            return this;
        }

        public ReactiveCapabilityCurveAdderImpl newReactiveCapabilityCurve() {
            return new ReactiveCapabilityCurveAdderImpl<GenerationImpl>(this);
        }

        public MinMaxReactiveLimitsAdderImpl newMinMaxReactiveLimits() {
            return new MinMaxReactiveLimitsAdderImpl<GenerationImpl>(this);
        }

        @Override
        public void setReactiveLimits(ReactiveLimits reactiveLimits) {
            this.reactiveLimits.setReactiveLimits(reactiveLimits);
        }

        public ReactiveLimits getReactiveLimits() {
            return this.reactiveLimits.getReactiveLimits();
        }

        public <R extends ReactiveLimits> R getReactiveLimits(Class<R> type) {
            return this.reactiveLimits.getReactiveLimits(type);
        }

        public String getMessageHeader() {
            return this.danglingLine.getMessageHeader();
        }

        void extendVariantArraySize(int number, int sourceIndex) {
            this.targetP.ensureCapacity(this.targetP.size() + number);
            this.targetQ.ensureCapacity(this.targetQ.size() + number);
            this.voltageRegulationOn.ensureCapacity(this.voltageRegulationOn.size() + number);
            this.targetV.ensureCapacity(this.targetV.size() + number);
            for (int i = 0; i < number; ++i) {
                this.targetP.add(this.targetP.get(sourceIndex));
                this.targetQ.add(this.targetQ.get(sourceIndex));
                this.voltageRegulationOn.add(this.voltageRegulationOn.get(sourceIndex));
                this.targetV.add(this.targetV.get(sourceIndex));
            }
        }

        void reduceVariantArraySize(int number) {
            this.targetP.remove(this.targetP.size() - number, number);
            this.targetQ.remove(this.targetQ.size() - number, number);
            this.voltageRegulationOn.remove(this.voltageRegulationOn.size() - number, number);
            this.targetV.remove(this.targetV.size() - number, number);
        }

        void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
            for (int index : indexes) {
                this.targetP.set(index, this.targetP.get(sourceIndex));
                this.targetQ.set(index, this.targetQ.get(sourceIndex));
                this.voltageRegulationOn.set(index, this.voltageRegulationOn.get(sourceIndex));
                this.targetV.set(index, this.targetV.get(sourceIndex));
            }
        }
    }
}

