/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractHvdcConverterStation;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.NetworkExt;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.util.Ref;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;

class HvdcLineImpl
extends AbstractIdentifiable<HvdcLine>
implements HvdcLine {
    static final String TYPE_DESCRIPTION = "hvdcLine";
    private double r;
    private double nominalV;
    private double maxP;
    private final TIntArrayList convertersMode;
    private final TDoubleArrayList activePowerSetpoint;
    private final Ref<NetworkImpl> networkRef;
    private AbstractHvdcConverterStation<?> converterStation1;
    private AbstractHvdcConverterStation<?> converterStation2;

    HvdcLineImpl(String id, String name, boolean fictitious, double r, double nominalV, double maxP, HvdcLine.ConvertersMode convertersMode, double activePowerSetpoint, AbstractHvdcConverterStation<?> converterStation1, AbstractHvdcConverterStation<?> converterStation2, Ref<NetworkImpl> networkRef) {
        super(id, name, fictitious);
        this.r = r;
        this.nominalV = nominalV;
        this.maxP = maxP;
        int variantArraySize = networkRef.get().getVariantManager().getVariantArraySize();
        this.convertersMode = new TIntArrayList(variantArraySize);
        this.convertersMode.fill(0, variantArraySize, convertersMode != null ? convertersMode.ordinal() : -1);
        this.activePowerSetpoint = new TDoubleArrayList(variantArraySize);
        this.activePowerSetpoint.fill(0, variantArraySize, activePowerSetpoint);
        this.converterStation1 = this.attach(converterStation1);
        this.converterStation2 = this.attach(converterStation2);
        this.networkRef = networkRef;
    }

    private AbstractHvdcConverterStation<?> attach(AbstractHvdcConverterStation<?> converterStation) {
        converterStation.setHvdcLine(this);
        return converterStation;
    }

    protected void notifyUpdate(String attribute, Object oldValue, Object newValue) {
        this.getNetwork().getListeners().notifyUpdate((Identifiable)this, attribute, oldValue, newValue);
    }

    protected void notifyUpdate(String attribute, String variantId, Object oldValue, Object newValue) {
        this.getNetwork().getListeners().notifyUpdate((Identifiable)this, attribute, variantId, oldValue, newValue);
    }

    @Override
    public NetworkImpl getNetwork() {
        return this.networkRef.get();
    }

    public Network getParentNetwork() {
        NetworkExt subnetwork2;
        NetworkExt subnetwork1 = this.converterStation1.getParentNetwork();
        if (subnetwork1 == (subnetwork2 = this.converterStation2.getParentNetwork())) {
            return subnetwork1;
        }
        return this.networkRef.get();
    }

    public HvdcLine.ConvertersMode getConvertersMode() {
        int variantIndex = this.networkRef.get().getVariantIndex();
        return this.convertersMode.get(variantIndex) != -1 ? HvdcLine.ConvertersMode.values()[this.convertersMode.get(variantIndex)] : null;
    }

    public HvdcLineImpl setConvertersMode(HvdcLine.ConvertersMode convertersMode) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkConvertersMode((Validable)this, (HvdcLine.ConvertersMode)convertersMode, (n.getMinValidationLevel().compareTo((Enum)ValidationLevel.STEADY_STATE_HYPOTHESIS) >= 0 ? 1 : 0) != 0);
        int variantIndex = n.getVariantIndex();
        HvdcLine.ConvertersMode oldValue = this.convertersMode.get(variantIndex) != -1 ? HvdcLine.ConvertersMode.values()[this.convertersMode.get(variantIndex)] : null;
        this.convertersMode.set(variantIndex, convertersMode != null ? convertersMode.ordinal() : -1);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("convertersMode", variantId, oldValue, convertersMode);
        return this;
    }

    public double getR() {
        return this.r;
    }

    public HvdcLineImpl setR(double r) {
        ValidationUtil.checkR((Validable)this, (double)r);
        double oldValue = this.r;
        this.r = r;
        this.notifyUpdate("r", oldValue, r);
        return this;
    }

    public double getNominalV() {
        return this.nominalV;
    }

    public HvdcLineImpl setNominalV(double nominalV) {
        ValidationUtil.checkNominalV((Validable)this, (double)nominalV);
        double oldValue = this.nominalV;
        this.nominalV = nominalV;
        this.notifyUpdate("nominalV", oldValue, nominalV);
        return this;
    }

    public double getMaxP() {
        return this.maxP;
    }

    public HvdcLineImpl setMaxP(double maxP) {
        ValidationUtil.checkHvdcMaxP((Validable)this, (double)maxP);
        double oldValue = this.maxP;
        this.maxP = maxP;
        this.notifyUpdate("maxP", oldValue, maxP);
        return this;
    }

    public double getActivePowerSetpoint() {
        return this.activePowerSetpoint.get(this.getNetwork().getVariantIndex());
    }

    public HvdcLineImpl setActivePowerSetpoint(double activePowerSetpoint) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkHvdcActivePowerSetpoint((Validable)this, (double)activePowerSetpoint, (n.getMinValidationLevel().compareTo((Enum)ValidationLevel.STEADY_STATE_HYPOTHESIS) >= 0 ? 1 : 0) != 0);
        int variantIndex = n.getVariantIndex();
        double oldValue = this.activePowerSetpoint.set(variantIndex, activePowerSetpoint);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("activePowerSetpoint", variantId, oldValue, activePowerSetpoint);
        return this;
    }

    public AbstractHvdcConverterStation<?> getConverterStation(HvdcLine.Side side) {
        return side == HvdcLine.Side.ONE ? this.getConverterStation1() : this.getConverterStation2();
    }

    public AbstractHvdcConverterStation<?> getConverterStation1() {
        return this.converterStation1;
    }

    public AbstractHvdcConverterStation<?> getConverterStation2() {
        return this.converterStation2;
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.convertersMode.ensureCapacity(this.convertersMode.size() + number);
        this.convertersMode.fill(initVariantArraySize, initVariantArraySize + number, this.convertersMode.get(sourceIndex));
        this.activePowerSetpoint.ensureCapacity(this.activePowerSetpoint.size() + number);
        this.activePowerSetpoint.fill(initVariantArraySize, initVariantArraySize + number, this.activePowerSetpoint.get(sourceIndex));
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.activePowerSetpoint.remove(this.activePowerSetpoint.size() - number, number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.convertersMode.set(index, this.convertersMode.get(sourceIndex));
            this.activePowerSetpoint.set(index, this.activePowerSetpoint.get(sourceIndex));
        }
    }

    public void remove() {
        NetworkImpl network = this.getNetwork();
        network.getListeners().notifyBeforeRemoval(this);
        this.converterStation1.setHvdcLine(null);
        this.converterStation2.setHvdcLine(null);
        this.converterStation1 = null;
        this.converterStation2 = null;
        network.getIndex().remove(this);
        network.getListeners().notifyAfterRemoval(this.id);
    }

    @Override
    protected String getTypeDescription() {
        return TYPE_DESCRIPTION;
    }
}

