/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractBranchAdder;
import com.powsybl.iidm.network.impl.LineImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.impl.util.Ref;

class LineAdderImpl
extends AbstractBranchAdder<LineAdderImpl>
implements LineAdder {
    private final NetworkImpl network;
    private final String subnetwork;
    private double r = Double.NaN;
    private double x = Double.NaN;
    private double g1 = 0.0;
    private double b1 = 0.0;
    private double g2 = 0.0;
    private double b2 = 0.0;

    LineAdderImpl(NetworkImpl network, String subnetwork) {
        this.network = network;
        this.subnetwork = subnetwork;
    }

    @Override
    protected NetworkImpl getNetwork() {
        return this.network;
    }

    @Override
    protected String getTypeDescription() {
        return "AC Line";
    }

    public LineAdderImpl setR(double r) {
        this.r = r;
        return this;
    }

    public LineAdderImpl setX(double x) {
        this.x = x;
        return this;
    }

    public LineAdderImpl setG1(double g1) {
        this.g1 = g1;
        return this;
    }

    public LineAdderImpl setB1(double b1) {
        this.b1 = b1;
        return this;
    }

    public LineAdderImpl setG2(double g2) {
        this.g2 = g2;
        return this;
    }

    public LineAdderImpl setB2(double b2) {
        this.b2 = b2;
        return this;
    }

    public LineImpl add() {
        String id = this.checkAndGetUniqueId();
        this.checkConnectableBuses();
        VoltageLevelExt voltageLevel1 = this.checkAndGetVoltageLevel1();
        VoltageLevelExt voltageLevel2 = this.checkAndGetVoltageLevel2();
        if (!(this.subnetwork == null || this.subnetwork.equals(voltageLevel1.getSubnetworkId()) && this.subnetwork.equals(voltageLevel2.getSubnetworkId()))) {
            throw new ValidationException((Validable)this, "The involved voltage levels are not in the subnetwork '" + this.subnetwork + "'. Create this line from the parent network '" + this.getNetwork().getId() + "'");
        }
        TerminalExt terminal1 = this.checkAndGetTerminal1();
        TerminalExt terminal2 = this.checkAndGetTerminal2();
        ValidationUtil.checkR((Validable)this, (double)this.r);
        ValidationUtil.checkX((Validable)this, (double)this.x);
        ValidationUtil.checkG1((Validable)this, (double)this.g1);
        ValidationUtil.checkG2((Validable)this, (double)this.g2);
        ValidationUtil.checkB1((Validable)this, (double)this.b1);
        ValidationUtil.checkB2((Validable)this, (double)this.b2);
        Ref<NetworkImpl> networkRef = LineAdderImpl.computeNetworkRef(this.getNetwork(), voltageLevel1, voltageLevel2);
        LineImpl line = new LineImpl(networkRef, id, this.getName(), this.isFictitious(), this.r, this.x, this.g1, this.b1, this.g2, this.b2);
        terminal1.setNum(1);
        terminal2.setNum(2);
        line.addTerminal(terminal1);
        line.addTerminal(terminal2);
        voltageLevel1.attach(terminal1, true);
        voltageLevel2.attach(terminal2, true);
        voltageLevel1.attach(terminal1, false);
        voltageLevel2.attach(terminal2, false);
        this.network.getIndex().checkAndAdd(line);
        this.getNetwork().getListeners().notifyCreation(line);
        return line;
    }
}

