/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractConnectableBranch;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.util.Ref;

class LineImpl
extends AbstractConnectableBranch<Line>
implements Line {
    private double r;
    private double x;
    private double g1;
    private double b1;
    private double g2;
    private double b2;

    LineImpl(Ref<NetworkImpl> network, String id, String name, boolean fictitious, double r, double x, double g1, double b1, double g2, double b2) {
        super(network, id, name, fictitious);
        this.r = r;
        this.x = x;
        this.g1 = g1;
        this.b1 = b1;
        this.g2 = g2;
        this.b2 = b2;
    }

    public double getR() {
        return this.r;
    }

    public LineImpl setR(double r) {
        ValidationUtil.checkR((Validable)this, (double)r);
        double oldValue = this.r;
        this.r = r;
        this.notifyUpdate("r", (Object)oldValue, (Object)r);
        return this;
    }

    public double getX() {
        return this.x;
    }

    public LineImpl setX(double x) {
        ValidationUtil.checkX((Validable)this, (double)x);
        double oldValue = this.x;
        this.x = x;
        this.notifyUpdate("x", (Object)oldValue, (Object)x);
        return this;
    }

    public double getG1() {
        return this.g1;
    }

    public LineImpl setG1(double g1) {
        ValidationUtil.checkG1((Validable)this, (double)g1);
        double oldValue = this.g1;
        this.g1 = g1;
        this.notifyUpdate("g1", (Object)oldValue, (Object)g1);
        return this;
    }

    public double getB1() {
        return this.b1;
    }

    public LineImpl setB1(double b1) {
        ValidationUtil.checkB1((Validable)this, (double)b1);
        double oldValue = this.b1;
        this.b1 = b1;
        this.notifyUpdate("b1", (Object)oldValue, (Object)b1);
        return this;
    }

    public double getG2() {
        return this.g2;
    }

    public LineImpl setG2(double g2) {
        ValidationUtil.checkG2((Validable)this, (double)g2);
        double oldValue = this.g2;
        this.g2 = g2;
        this.notifyUpdate("g2", (Object)oldValue, (Object)g2);
        return this;
    }

    public double getB2() {
        return this.b2;
    }

    public LineImpl setB2(double b2) {
        ValidationUtil.checkB2((Validable)this, (double)b2);
        double oldValue = this.b2;
        this.b2 = b2;
        this.notifyUpdate("b2", (Object)oldValue, (Object)b2);
        return this;
    }

    @Override
    protected String getTypeDescription() {
        return "AC line";
    }
}

