/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.OperationalLimits;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.ActivePowerLimitsAdderImpl;
import com.powsybl.iidm.network.impl.ApparentPowerLimitsAdderImpl;
import com.powsybl.iidm.network.impl.CurrentLimitsAdderImpl;
import com.powsybl.iidm.network.impl.OperationalLimitsOwner;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Objects;
import java.util.Optional;

class OperationalLimitsHolderImpl
implements OperationalLimitsOwner {
    private final EnumMap<LimitType, OperationalLimits> operationalLimits = new EnumMap(LimitType.class);
    private final AbstractIdentifiable<?> identifiable;
    private final String attributeName;

    OperationalLimitsHolderImpl(AbstractIdentifiable<?> identifiable, String attributeName) {
        this.identifiable = Objects.requireNonNull(identifiable);
        this.attributeName = Objects.requireNonNull(attributeName);
    }

    @Override
    public void setOperationalLimits(LimitType limitType, OperationalLimits operationalLimits) {
        OperationalLimits oldValue = operationalLimits == null ? this.operationalLimits.remove(limitType) : this.operationalLimits.put(limitType, operationalLimits);
        this.identifiable.getNetwork().getListeners().notifyUpdate(this.identifiable, this.attributeName + "_" + limitType, (Object)oldValue, (Object)operationalLimits);
    }

    @Override
    public void notifyUpdate(LimitType limitType, String attribute, double oldValue, double newValue) {
        this.identifiable.getNetwork().getListeners().notifyUpdate(this.identifiable, this.attributeName + "_" + limitType + "." + attribute, (Object)oldValue, (Object)newValue);
    }

    Collection<OperationalLimits> getOperationalLimits() {
        return Collections.unmodifiableCollection(this.operationalLimits.values());
    }

    <L extends OperationalLimits> Optional<L> getOperationalLimits(LimitType type, Class<L> limitClazz) {
        return Optional.ofNullable(this.getNullableOperationalLimits(type, limitClazz));
    }

    <L extends OperationalLimits> L getNullableOperationalLimits(LimitType type, Class<L> limitClazz) {
        if (type == null) {
            throw new IllegalArgumentException("limit type is null");
        }
        OperationalLimits ol = this.operationalLimits.get(type);
        if (ol == null || limitClazz.isInstance(ol)) {
            return (L)ol;
        }
        throw new IllegalStateException("Unexpected class for operational limits of type " + type + ". Expected: " + ol.getClass().getName() + ", actual: " + limitClazz.getName() + ".");
    }

    CurrentLimitsAdder newCurrentLimits() {
        return new CurrentLimitsAdderImpl(this);
    }

    ApparentPowerLimitsAdder newApparentPowerLimits() {
        return new ApparentPowerLimitsAdderImpl(this);
    }

    ActivePowerLimitsAdder newActivePowerLimits() {
        return new ActivePowerLimitsAdderImpl(this);
    }

    public String getMessageHeader() {
        return this.identifiable.getMessageHeader();
    }
}

