/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.PhaseTapChangerImpl;
import com.powsybl.iidm.network.impl.PhaseTapChangerParent;
import com.powsybl.iidm.network.impl.PhaseTapChangerStepImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PhaseTapChangerAdderImpl
implements PhaseTapChangerAdder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhaseTapChangerAdderImpl.class);
    private final PhaseTapChangerParent parent;
    private int lowTapPosition = 0;
    private Integer tapPosition;
    private final List<PhaseTapChangerStepImpl> steps = new ArrayList<PhaseTapChangerStepImpl>();
    private PhaseTapChanger.RegulationMode regulationMode = PhaseTapChanger.RegulationMode.FIXED_TAP;
    private double regulationValue = Double.NaN;
    private boolean regulating = false;
    private double targetDeadband = Double.NaN;
    private TerminalExt regulationTerminal;

    PhaseTapChangerAdderImpl(PhaseTapChangerParent parent) {
        this.parent = parent;
    }

    NetworkImpl getNetwork() {
        return this.parent.getNetwork();
    }

    public PhaseTapChangerAdder setLowTapPosition(int lowTapPosition) {
        this.lowTapPosition = lowTapPosition;
        return this;
    }

    public PhaseTapChangerAdder setTapPosition(int tapPosition) {
        this.tapPosition = tapPosition;
        return this;
    }

    public PhaseTapChangerAdder setRegulationMode(PhaseTapChanger.RegulationMode regulationMode) {
        this.regulationMode = regulationMode;
        return this;
    }

    public PhaseTapChangerAdder setRegulationValue(double regulationValue) {
        this.regulationValue = regulationValue;
        return this;
    }

    public PhaseTapChangerAdder setRegulating(boolean regulating) {
        this.regulating = regulating;
        return this;
    }

    public PhaseTapChangerAdder setTargetDeadband(double targetDeadband) {
        this.targetDeadband = targetDeadband;
        return this;
    }

    public PhaseTapChangerAdder setRegulationTerminal(Terminal regulationTerminal) {
        this.regulationTerminal = (TerminalExt)regulationTerminal;
        return this;
    }

    public PhaseTapChangerAdder.StepAdder beginStep() {
        return new StepAdderImpl();
    }

    public PhaseTapChanger add() {
        NetworkImpl network = this.getNetwork();
        if (this.tapPosition == null) {
            ValidationUtil.throwExceptionOrLogError((Validable)this.parent, (String)"tap position is not set", (ValidationLevel)network.getMinValidationLevel());
            network.setValidationLevelIfGreaterThan(ValidationLevel.EQUIPMENT);
        }
        if (this.steps.isEmpty()) {
            throw new ValidationException((Validable)this.parent, "a phase tap changer shall have at least one step");
        }
        if (this.tapPosition != null) {
            int highTapPosition = this.lowTapPosition + this.steps.size() - 1;
            if (this.tapPosition < this.lowTapPosition || this.tapPosition > highTapPosition) {
                ValidationUtil.throwExceptionOrLogError((Validable)this.parent, (String)("incorrect tap position " + this.tapPosition + " [" + this.lowTapPosition + ", " + highTapPosition + "]"), (ValidationLevel)network.getMinValidationLevel());
                network.setValidationLevelIfGreaterThan(ValidationLevel.EQUIPMENT);
            }
        }
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkPhaseTapChangerRegulation((Validable)this.parent, (PhaseTapChanger.RegulationMode)this.regulationMode, (double)this.regulationValue, (boolean)this.regulating, (Terminal)this.regulationTerminal, (Network)network, (network.getMinValidationLevel().compareTo((Enum)ValidationLevel.STEADY_STATE_HYPOTHESIS) >= 0 ? 1 : 0) != 0));
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkTargetDeadband((Validable)this.parent, (String)"phase tap changer", (boolean)this.regulating, (double)this.targetDeadband, (ValidationLevel)network.getMinValidationLevel()));
        PhaseTapChangerImpl tapChanger = new PhaseTapChangerImpl(this.parent, this.lowTapPosition, this.steps, this.regulationTerminal, this.tapPosition, this.regulating, this.regulationMode, this.regulationValue, this.targetDeadband);
        HashSet tapChangers = new HashSet(this.parent.getAllTapChangers());
        tapChangers.remove(this.parent.getPhaseTapChanger());
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkOnlyOneTapChangerRegulatingEnabled((Validable)this.parent, tapChangers, (boolean)this.regulating, (network.getMinValidationLevel().compareTo((Enum)ValidationLevel.STEADY_STATE_HYPOTHESIS) >= 0 ? 1 : 0) != 0));
        if (this.parent.hasRatioTapChanger()) {
            LOGGER.warn("{} has both Ratio and Phase Tap Changer", (Object)this.parent);
        }
        this.parent.setPhaseTapChanger(tapChanger);
        return tapChanger;
    }

    class StepAdderImpl
    implements PhaseTapChangerAdder.StepAdder {
        private double alpha = Double.NaN;
        private double rho = 1.0;
        private double r = 0.0;
        private double x = 0.0;
        private double g = 0.0;
        private double b = 0.0;

        StepAdderImpl() {
        }

        public PhaseTapChangerAdder.StepAdder setAlpha(double alpha) {
            this.alpha = alpha;
            return this;
        }

        public PhaseTapChangerAdder.StepAdder setRho(double rho) {
            this.rho = rho;
            return this;
        }

        public PhaseTapChangerAdder.StepAdder setR(double r) {
            this.r = r;
            return this;
        }

        public PhaseTapChangerAdder.StepAdder setX(double x) {
            this.x = x;
            return this;
        }

        public PhaseTapChangerAdder.StepAdder setG(double g) {
            this.g = g;
            return this;
        }

        public PhaseTapChangerAdder.StepAdder setB(double b) {
            this.b = b;
            return this;
        }

        public PhaseTapChangerAdder endStep() {
            if (Double.isNaN(this.alpha)) {
                throw new ValidationException((Validable)PhaseTapChangerAdderImpl.this.parent, "step alpha is not set");
            }
            if (Double.isNaN(this.rho)) {
                throw new ValidationException((Validable)PhaseTapChangerAdderImpl.this.parent, "step rho is not set");
            }
            if (Double.isNaN(this.r)) {
                throw new ValidationException((Validable)PhaseTapChangerAdderImpl.this.parent, "step r is not set");
            }
            if (Double.isNaN(this.x)) {
                throw new ValidationException((Validable)PhaseTapChangerAdderImpl.this.parent, "step x is not set");
            }
            if (Double.isNaN(this.g)) {
                throw new ValidationException((Validable)PhaseTapChangerAdderImpl.this.parent, "step g is not set");
            }
            if (Double.isNaN(this.b)) {
                throw new ValidationException((Validable)PhaseTapChangerAdderImpl.this.parent, "step b is not set");
            }
            PhaseTapChangerStepImpl step = new PhaseTapChangerStepImpl(PhaseTapChangerAdderImpl.this.steps.size(), this.alpha, this.rho, this.r, this.x, this.g, this.b);
            PhaseTapChangerAdderImpl.this.steps.add(step);
            return PhaseTapChangerAdderImpl.this;
        }
    }
}

