/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.impl.AbstractIdentifiableAdder;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import com.powsybl.iidm.network.impl.SubstationImpl;
import com.powsybl.iidm.network.impl.util.Ref;

class SubstationAdderImpl
extends AbstractIdentifiableAdder<SubstationAdderImpl>
implements SubstationAdder {
    private final Ref<NetworkImpl> networkRef;
    private final Ref<SubnetworkImpl> subnetworkRef;
    private Country country;
    private String tso;
    private String[] tags;

    SubstationAdderImpl(Ref<NetworkImpl> networkRef, Ref<SubnetworkImpl> subnetworkRef) {
        this.networkRef = networkRef;
        this.subnetworkRef = subnetworkRef;
    }

    @Override
    protected NetworkImpl getNetwork() {
        return this.networkRef.get();
    }

    @Override
    protected String getTypeDescription() {
        return "Substation";
    }

    public SubstationAdder setCountry(Country country) {
        this.country = country;
        return this;
    }

    public SubstationAdder setTso(String tso) {
        this.tso = tso;
        return this;
    }

    public SubstationAdder setGeographicalTags(String ... tags) {
        this.tags = tags;
        return this;
    }

    public Substation add() {
        String id = this.checkAndGetUniqueId();
        SubstationImpl substation = new SubstationImpl(id, this.getName(), this.isFictitious(), this.country, this.tso, this.networkRef, this.subnetworkRef);
        if (this.tags != null) {
            for (String tag : this.tags) {
                substation.addGeographicalTag(tag);
            }
        }
        this.getNetwork().getIndex().checkAndAdd(substation);
        this.getNetwork().getListeners().notifyCreation(substation);
        return substation;
    }
}

