/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

final class Substations {
    private Substations() {
    }

    static Iterable<Substation> filter(Iterable<Substation> substations, String country, String tso, String ... geographicalTags) {
        return StreamSupport.stream(substations.spliterator(), false).filter(substation -> {
            if (country != null && !country.equals(substation.getCountry().map(Country::getName).orElse(""))) {
                return false;
            }
            if (tso != null && !tso.equals(substation.getTso())) {
                return false;
            }
            for (String tag : geographicalTags) {
                if (substation.getGeographicalTags().contains(tag)) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    static void checkRemovability(Substation substation) {
        for (VoltageLevel vl : substation.getVoltageLevels()) {
            for (Connectable connectable : vl.getConnectables()) {
                if (connectable instanceof Branch) {
                    Branch branch = (Branch)connectable;
                    Substations.checkRemovability(substation, branch);
                    continue;
                }
                if (connectable instanceof ThreeWindingsTransformer) {
                    ThreeWindingsTransformer twt = (ThreeWindingsTransformer)connectable;
                    Substations.checkRemovability(substation, twt);
                    continue;
                }
                if (!(connectable instanceof HvdcConverterStation)) continue;
                HvdcConverterStation hvdcConverterStation = (HvdcConverterStation)connectable;
                Substations.checkRemovability(substation, hvdcConverterStation);
            }
        }
    }

    private static void checkRemovability(Substation substation, Branch branch) {
        Substation s1 = branch.getTerminal1().getVoltageLevel().getSubstation().orElse(null);
        Substation s2 = branch.getTerminal2().getVoltageLevel().getSubstation().orElse(null);
        if (s1 != substation || s2 != substation) {
            throw Substations.createIsolationException(substation);
        }
    }

    private static void checkRemovability(Substation substation, ThreeWindingsTransformer twt) {
        Substation s1 = twt.getLeg1().getTerminal().getVoltageLevel().getSubstation().orElse(null);
        Substation s2 = twt.getLeg2().getTerminal().getVoltageLevel().getSubstation().orElse(null);
        Substation s3 = twt.getLeg3().getTerminal().getVoltageLevel().getSubstation().orElse(null);
        if (s1 != substation || s2 != substation || s3 != substation) {
            throw Substations.createIsolationException(substation);
        }
    }

    private static void checkRemovability(Substation substation, HvdcConverterStation station) {
        HvdcLine hvdcLine = substation.getNetwork().getHvdcLine(station);
        if (hvdcLine != null) {
            Substation s1 = hvdcLine.getConverterStation1().getTerminal().getVoltageLevel().getSubstation().orElse(null);
            Substation s2 = hvdcLine.getConverterStation2().getTerminal().getVoltageLevel().getSubstation().orElse(null);
            if (s1 != substation || s2 != substation) {
                throw Substations.createIsolationException(substation);
            }
        }
    }

    private static PowsyblException createIsolationException(Substation substation) {
        Objects.requireNonNull(substation);
        return new PowsyblException("The substation " + substation.getId() + " is still connected to another substation");
    }
}

