/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.impl.AbstractTapChanger;

class TapChangerStepImpl<S extends TapChangerStepImpl<S>> {
    private AbstractTapChanger<?, ?, ?> stepHolder;
    private final int position;
    private double rho;
    private double r;
    private double x;
    private double g;
    private double b;

    protected TapChangerStepImpl(int position, double rho, double r, double x, double g, double b) {
        this.position = position;
        this.rho = rho;
        this.r = r;
        this.x = x;
        this.g = g;
        this.b = b;
    }

    protected void setParent(AbstractTapChanger<?, ?, ?> parent) {
        this.stepHolder = parent;
    }

    protected void notifyUpdate(String attribute, Object oldValue, Object newValue) {
        this.stepHolder.getNetwork().getListeners().notifyUpdate(this.stepHolder.parent.getTransformer(), () -> this.stepHolder.getTapChangerAttribute() + ".step[" + this.position + "]." + attribute, oldValue, newValue);
    }

    public double getRho() {
        return this.rho;
    }

    public S setRho(double rho) {
        double oldValue = this.rho;
        this.rho = rho;
        this.notifyUpdate("rho", oldValue, rho);
        return (S)this;
    }

    public double getR() {
        return this.r;
    }

    public S setR(double r) {
        double oldValue = this.r;
        this.r = r;
        this.notifyUpdate("r", oldValue, r);
        return (S)this;
    }

    public double getX() {
        return this.x;
    }

    public S setX(double x) {
        double oldValue = this.x;
        this.x = x;
        this.notifyUpdate("x", oldValue, x);
        return (S)this;
    }

    public double getB() {
        return this.b;
    }

    public S setB(double b) {
        double oldValue = this.b;
        this.b = b;
        this.notifyUpdate("b", oldValue, b);
        return (S)this;
    }

    public double getG() {
        return this.g;
    }

    public S setG(double g) {
        double oldValue = this.g;
        this.g = g;
        this.notifyUpdate("g", oldValue, g);
        return (S)this;
    }
}

