/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.OperationalLimits;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.TapChanger;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.NetworkExt;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.OperationalLimitsHolderImpl;
import com.powsybl.iidm.network.impl.PhaseTapChangerAdderImpl;
import com.powsybl.iidm.network.impl.PhaseTapChangerImpl;
import com.powsybl.iidm.network.impl.PhaseTapChangerParent;
import com.powsybl.iidm.network.impl.RatioTapChangerAdderImpl;
import com.powsybl.iidm.network.impl.RatioTapChangerImpl;
import com.powsybl.iidm.network.impl.RatioTapChangerParent;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.util.Ref;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

class ThreeWindingsTransformerImpl
extends AbstractConnectable<ThreeWindingsTransformer>
implements ThreeWindingsTransformer {
    private final LegImpl leg1;
    private final LegImpl leg2;
    private final LegImpl leg3;
    private double ratedU0;

    ThreeWindingsTransformerImpl(Ref<NetworkImpl> network, String id, String name, boolean fictitious, LegImpl leg1, LegImpl leg2, LegImpl leg3, double ratedU0) {
        super(network, id, name, fictitious);
        this.leg1 = Objects.requireNonNull(leg1);
        this.leg2 = Objects.requireNonNull(leg2);
        this.leg3 = Objects.requireNonNull(leg3);
        this.ratedU0 = ratedU0;
    }

    public Optional<Substation> getSubstation() {
        return this.getLegStream().map(leg -> leg.getTerminal().getVoltageLevel().getSubstation()).filter(Optional::isPresent).findFirst().orElseGet(Optional::empty);
    }

    public Substation getNullableSubstation() {
        return this.getLegStream().map(leg -> leg.getTerminal().getVoltageLevel().getNullableSubstation()).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public LegImpl getLeg1() {
        return this.leg1;
    }

    public LegImpl getLeg2() {
        return this.leg2;
    }

    public LegImpl getLeg3() {
        return this.leg3;
    }

    public Stream<ThreeWindingsTransformer.Leg> getLegStream() {
        return Stream.of(this.leg1, this.leg2, this.leg3);
    }

    public List<ThreeWindingsTransformer.Leg> getLegs() {
        return Arrays.asList(this.leg1, this.leg2, this.leg3);
    }

    public double getRatedU0() {
        return this.ratedU0;
    }

    public Terminal getTerminal(ThreeWindingsTransformer.Side side) {
        switch (side) {
            case ONE: {
                return this.getLeg1().getTerminal();
            }
            case TWO: {
                return this.getLeg2().getTerminal();
            }
            case THREE: {
                return this.getLeg3().getTerminal();
            }
        }
        throw new IllegalStateException();
    }

    public ThreeWindingsTransformer.Side getSide(Terminal terminal) {
        Objects.requireNonNull(terminal);
        if (this.getLeg1().getTerminal() == terminal) {
            return ThreeWindingsTransformer.Side.ONE;
        }
        if (this.getLeg2().getTerminal() == terminal) {
            return ThreeWindingsTransformer.Side.TWO;
        }
        if (this.getLeg3().getTerminal() == terminal) {
            return ThreeWindingsTransformer.Side.THREE;
        }
        throw new IllegalStateException("The terminal is not connected to this three windings transformer");
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.leg1.getOptionalRatioTapChanger().ifPresent(rtc -> ((RatioTapChangerImpl)rtc).extendVariantArraySize(initVariantArraySize, number, sourceIndex));
        this.leg1.getOptionalPhaseTapChanger().ifPresent(ptc -> ((PhaseTapChangerImpl)ptc).extendVariantArraySize(initVariantArraySize, number, sourceIndex));
        this.leg2.getOptionalRatioTapChanger().ifPresent(rtc -> ((RatioTapChangerImpl)rtc).extendVariantArraySize(initVariantArraySize, number, sourceIndex));
        this.leg2.getOptionalPhaseTapChanger().ifPresent(ptc -> ((PhaseTapChangerImpl)ptc).extendVariantArraySize(initVariantArraySize, number, sourceIndex));
        this.leg3.getOptionalRatioTapChanger().ifPresent(rtc -> ((RatioTapChangerImpl)rtc).extendVariantArraySize(initVariantArraySize, number, sourceIndex));
        this.leg3.getOptionalPhaseTapChanger().ifPresent(ptc -> ((PhaseTapChangerImpl)ptc).extendVariantArraySize(initVariantArraySize, number, sourceIndex));
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.leg1.getOptionalRatioTapChanger().ifPresent(rtc -> ((RatioTapChangerImpl)rtc).reduceVariantArraySize(number));
        this.leg1.getOptionalPhaseTapChanger().ifPresent(ptc -> ((PhaseTapChangerImpl)ptc).reduceVariantArraySize(number));
        this.leg2.getOptionalRatioTapChanger().ifPresent(rtc -> ((RatioTapChangerImpl)rtc).reduceVariantArraySize(number));
        this.leg2.getOptionalPhaseTapChanger().ifPresent(ptc -> ((PhaseTapChangerImpl)ptc).reduceVariantArraySize(number));
        this.leg3.getOptionalRatioTapChanger().ifPresent(rtc -> ((RatioTapChangerImpl)rtc).reduceVariantArraySize(number));
        this.leg3.getOptionalPhaseTapChanger().ifPresent(ptc -> ((PhaseTapChangerImpl)ptc).reduceVariantArraySize(number));
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
        this.leg1.getOptionalRatioTapChanger().ifPresent(rtc -> ((RatioTapChangerImpl)rtc).deleteVariantArrayElement(index));
        this.leg1.getOptionalPhaseTapChanger().ifPresent(ptc -> ((PhaseTapChangerImpl)ptc).deleteVariantArrayElement(index));
        this.leg2.getOptionalRatioTapChanger().ifPresent(rtc -> ((RatioTapChangerImpl)rtc).deleteVariantArrayElement(index));
        this.leg2.getOptionalPhaseTapChanger().ifPresent(ptc -> ((PhaseTapChangerImpl)ptc).deleteVariantArrayElement(index));
        this.leg3.getOptionalRatioTapChanger().ifPresent(rtc -> ((RatioTapChangerImpl)rtc).deleteVariantArrayElement(index));
        this.leg3.getOptionalPhaseTapChanger().ifPresent(ptc -> ((PhaseTapChangerImpl)ptc).deleteVariantArrayElement(index));
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        this.leg1.getOptionalRatioTapChanger().ifPresent(rtc -> ((RatioTapChangerImpl)rtc).allocateVariantArrayElement(indexes, sourceIndex));
        this.leg1.getOptionalPhaseTapChanger().ifPresent(ptc -> ((PhaseTapChangerImpl)ptc).allocateVariantArrayElement(indexes, sourceIndex));
        this.leg2.getOptionalRatioTapChanger().ifPresent(rtc -> ((RatioTapChangerImpl)rtc).allocateVariantArrayElement(indexes, sourceIndex));
        this.leg2.getOptionalPhaseTapChanger().ifPresent(ptc -> ((PhaseTapChangerImpl)ptc).allocateVariantArrayElement(indexes, sourceIndex));
        this.leg3.getOptionalRatioTapChanger().ifPresent(rtc -> ((RatioTapChangerImpl)rtc).allocateVariantArrayElement(indexes, sourceIndex));
        this.leg3.getOptionalPhaseTapChanger().ifPresent(ptc -> ((PhaseTapChangerImpl)ptc).allocateVariantArrayElement(indexes, sourceIndex));
    }

    @Override
    protected String getTypeDescription() {
        return "3 windings transformer";
    }

    static class LegImpl
    implements Validable,
    ThreeWindingsTransformer.Leg,
    RatioTapChangerParent,
    PhaseTapChangerParent {
        protected ThreeWindingsTransformerImpl transformer;
        private double r;
        private double x;
        private double g;
        private double b;
        private double ratedU;
        private double ratedS;
        private OperationalLimitsHolderImpl operationalLimitsHolder;
        private RatioTapChangerImpl ratioTapChanger;
        private PhaseTapChangerImpl phaseTapChanger;
        private int legNumber = 0;

        LegImpl(double r, double x, double g, double b, double ratedU, double ratedS, int legNumber) {
            this.r = r;
            this.x = x;
            this.g = g;
            this.b = b;
            this.ratedU = ratedU;
            this.legNumber = legNumber;
            this.ratedS = ratedS;
        }

        void setTransformer(ThreeWindingsTransformerImpl transformer) {
            this.transformer = transformer;
            this.operationalLimitsHolder = new OperationalLimitsHolderImpl(transformer, "limits" + this.legNumber);
        }

        public TerminalExt getTerminal() {
            return (TerminalExt)this.transformer.terminals.get(this.legNumber - 1);
        }

        public double getR() {
            return this.r;
        }

        public ThreeWindingsTransformer.Leg setR(double r) {
            ValidationUtil.checkR((Validable)this, (double)r);
            double oldValue = this.r;
            this.r = r;
            this.transformer.notifyUpdate(() -> this.getLegAttribute() + ".r", (Object)oldValue, (Object)r);
            return this;
        }

        public double getX() {
            return this.x;
        }

        public ThreeWindingsTransformer.Leg setX(double x) {
            ValidationUtil.checkX((Validable)this, (double)x);
            double oldValue = this.x;
            this.x = x;
            this.transformer.notifyUpdate(() -> this.getLegAttribute() + ".x", (Object)oldValue, (Object)x);
            return this;
        }

        public double getG() {
            return this.g;
        }

        public ThreeWindingsTransformer.Leg setG(double g) {
            ValidationUtil.checkG((Validable)this, (double)g);
            double oldValue = this.g;
            this.g = g;
            this.transformer.notifyUpdate(() -> this.getLegAttribute() + ".g", (Object)oldValue, (Object)g);
            return this;
        }

        public double getB() {
            return this.b;
        }

        public ThreeWindingsTransformer.Leg setB(double b) {
            ValidationUtil.checkB((Validable)this, (double)b);
            double oldValue = this.b;
            this.b = b;
            this.transformer.notifyUpdate(() -> this.getLegAttribute() + ".b", (Object)oldValue, (Object)b);
            return this;
        }

        public double getRatedU() {
            return this.ratedU;
        }

        public ThreeWindingsTransformer.Leg setRatedU(double ratedU) {
            ValidationUtil.checkRatedU((Validable)this, (double)ratedU, (String)"");
            double oldValue = this.ratedU;
            this.ratedU = ratedU;
            this.transformer.notifyUpdate(() -> this.getLegAttribute() + ".ratedU", (Object)oldValue, (Object)ratedU);
            return this;
        }

        public RatioTapChangerAdderImpl newRatioTapChanger() {
            return new RatioTapChangerAdderImpl(this);
        }

        @Override
        public RatioTapChangerImpl getRatioTapChanger() {
            return this.ratioTapChanger;
        }

        public PhaseTapChangerAdderImpl newPhaseTapChanger() {
            return new PhaseTapChangerAdderImpl(this);
        }

        @Override
        public PhaseTapChangerImpl getPhaseTapChanger() {
            return this.phaseTapChanger;
        }

        @Override
        public NetworkImpl getNetwork() {
            return this.transformer.getNetwork();
        }

        @Override
        public NetworkExt getParentNetwork() {
            return this.transformer.getParentNetwork();
        }

        @Override
        public void setRatioTapChanger(RatioTapChangerImpl ratioTapChanger) {
            RatioTapChangerImpl oldValue = this.ratioTapChanger;
            this.ratioTapChanger = ratioTapChanger;
            this.transformer.notifyUpdate(() -> this.getLegAttribute() + "." + this.getTapChangerAttribute(), (Object)oldValue, (Object)ratioTapChanger);
        }

        @Override
        public void setPhaseTapChanger(PhaseTapChangerImpl phaseTapChanger) {
            PhaseTapChangerImpl oldValue = this.phaseTapChanger;
            this.phaseTapChanger = phaseTapChanger;
            this.transformer.notifyUpdate(() -> this.getLegAttribute() + "." + this.getTapChangerAttribute(), (Object)oldValue, (Object)phaseTapChanger);
        }

        public Collection<OperationalLimits> getOperationalLimits() {
            return this.operationalLimitsHolder.getOperationalLimits();
        }

        public Optional<CurrentLimits> getCurrentLimits() {
            return this.operationalLimitsHolder.getOperationalLimits(LimitType.CURRENT, CurrentLimits.class);
        }

        public CurrentLimits getNullableCurrentLimits() {
            return this.operationalLimitsHolder.getNullableOperationalLimits(LimitType.CURRENT, CurrentLimits.class);
        }

        public CurrentLimitsAdder newCurrentLimits() {
            return this.operationalLimitsHolder.newCurrentLimits();
        }

        public Optional<ApparentPowerLimits> getApparentPowerLimits() {
            return this.operationalLimitsHolder.getOperationalLimits(LimitType.APPARENT_POWER, ApparentPowerLimits.class);
        }

        public ApparentPowerLimits getNullableApparentPowerLimits() {
            return this.operationalLimitsHolder.getNullableOperationalLimits(LimitType.APPARENT_POWER, ApparentPowerLimits.class);
        }

        public ApparentPowerLimitsAdder newApparentPowerLimits() {
            return this.operationalLimitsHolder.newApparentPowerLimits();
        }

        public Optional<ActivePowerLimits> getActivePowerLimits() {
            return this.operationalLimitsHolder.getOperationalLimits(LimitType.ACTIVE_POWER, ActivePowerLimits.class);
        }

        public ActivePowerLimits getNullableActivePowerLimits() {
            return this.operationalLimitsHolder.getNullableOperationalLimits(LimitType.ACTIVE_POWER, ActivePowerLimits.class);
        }

        public ActivePowerLimitsAdder newActivePowerLimits() {
            return this.operationalLimitsHolder.newActivePowerLimits();
        }

        protected String getTypeDescription() {
            return "3 windings transformer " + this.getLegAttribute();
        }

        public String toString() {
            return this.transformer.getId() + " " + this.getLegAttribute();
        }

        @Override
        public Identifiable getTransformer() {
            return this.transformer;
        }

        public String getMessageHeader() {
            return this.getTypeDescription() + " '" + this.transformer.getId() + "': ";
        }

        @Override
        public String getTapChangerAttribute() {
            return String.format("TapChanger%d", this.legNumber);
        }

        protected String getLegAttribute() {
            return String.format("leg%d", this.legNumber);
        }

        @Override
        public Set<TapChanger<?, ?>> getAllTapChangers() {
            HashSet tapChangers = new HashSet();
            this.transformer.leg1.getOptionalRatioTapChanger().ifPresent(tapChangers::add);
            this.transformer.leg1.getOptionalPhaseTapChanger().ifPresent(tapChangers::add);
            this.transformer.leg2.getOptionalRatioTapChanger().ifPresent(tapChangers::add);
            this.transformer.leg2.getOptionalPhaseTapChanger().ifPresent(tapChangers::add);
            this.transformer.leg3.getOptionalRatioTapChanger().ifPresent(tapChangers::add);
            this.transformer.leg3.getOptionalPhaseTapChanger().ifPresent(tapChangers::add);
            return tapChangers;
        }

        @Override
        public boolean hasRatioTapChanger() {
            return this.ratioTapChanger != null;
        }

        @Override
        public boolean hasPhaseTapChanger() {
            return this.phaseTapChanger != null;
        }

        public double getRatedS() {
            return this.ratedS;
        }

        public LegImpl setRatedS(double ratedS) {
            ValidationUtil.checkRatedS((Validable)this, (double)ratedS);
            double oldValue = this.ratedS;
            this.ratedS = ratedS;
            this.transformer.notifyUpdate(() -> this.getLegAttribute() + ".ratedS", (Object)oldValue, (Object)ratedS);
            return this;
        }
    }
}

