/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.VoltageAngleLimit;
import com.powsybl.iidm.network.VoltageAngleLimitAdder;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.VoltageAngleLimitImpl;
import com.powsybl.iidm.network.impl.util.Ref;

class VoltageAngleLimitAdderImpl
implements VoltageAngleLimitAdder,
Validable {
    private final Ref<NetworkImpl> networkRef;
    private final String subnetworkId;
    private String id;
    private Terminal from;
    private Terminal to;
    private double lowLimit = Double.NaN;
    private double highLimit = Double.NaN;

    VoltageAngleLimitAdderImpl(Ref<NetworkImpl> networkRef) {
        this(networkRef, null);
    }

    VoltageAngleLimitAdderImpl(Ref<NetworkImpl> networkRef, String subnetworkId) {
        this.networkRef = networkRef;
        this.subnetworkId = subnetworkId;
    }

    public VoltageAngleLimitAdderImpl setId(String id) {
        this.id = id;
        return this;
    }

    public VoltageAngleLimitAdderImpl from(Terminal from) {
        this.from = from;
        return this;
    }

    public VoltageAngleLimitAdderImpl to(Terminal to) {
        this.to = to;
        return this;
    }

    public VoltageAngleLimitAdderImpl setLowLimit(double lowLimit) {
        this.lowLimit = lowLimit;
        return this;
    }

    public VoltageAngleLimitAdderImpl setHighLimit(double highLimit) {
        this.highLimit = highLimit;
        return this;
    }

    public VoltageAngleLimit add() {
        if (this.id == null) {
            throw new IllegalStateException("Voltage angle limit id is mandatory.");
        }
        if (this.subnetworkId != null && this.checkTerminalsInSubnetwork(this.subnetworkId)) {
            throw new ValidationException((Validable)this, "The involved voltage levels are not in the subnetwork '" + this.subnetworkId + "'. Create this VoltageAngleLimit from the parent network '" + this.networkRef.get().getId() + "'");
        }
        if (this.networkRef.get().getVoltageAngleLimitsIndex().containsKey(this.id)) {
            throw new PowsyblException("The network " + this.networkRef.get().getId() + " already contains a voltage angle limit with the id '" + this.id + "'");
        }
        if (!Double.isNaN(this.lowLimit) && !Double.isNaN(this.highLimit) && this.lowLimit >= this.highLimit) {
            throw new IllegalStateException("Voltage angle low limit must be lower than the high limit.");
        }
        VoltageAngleLimitImpl voltageAngleLimit = new VoltageAngleLimitImpl(this.id, this.from, this.to, this.lowLimit, this.highLimit);
        this.networkRef.get().getVoltageAngleLimitsIndex().put(this.id, voltageAngleLimit);
        return voltageAngleLimit;
    }

    private boolean checkTerminalsInSubnetwork(String subnetworkId) {
        return !subnetworkId.equals(this.from.getVoltageLevel().getParentNetwork().getId()) || !subnetworkId.equals(this.to.getVoltageLevel().getParentNetwork().getId());
    }

    public String getMessageHeader() {
        return "VoltageAngleLimit '" + this.id + "': ";
    }
}

