/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.impl.AbstractIdentifiableAdder;
import com.powsybl.iidm.network.impl.AbstractVoltageLevel;
import com.powsybl.iidm.network.impl.BusBreakerVoltageLevel;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.NodeBreakerVoltageLevel;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import com.powsybl.iidm.network.impl.SubstationImpl;
import com.powsybl.iidm.network.impl.util.Ref;
import java.util.Optional;

class VoltageLevelAdderImpl
extends AbstractIdentifiableAdder<VoltageLevelAdderImpl>
implements VoltageLevelAdder {
    private final Ref<NetworkImpl> networkRef;
    private final SubstationImpl substation;
    private final Ref<SubnetworkImpl> subnetworkRef;
    private double nominalV = Double.NaN;
    private double lowVoltageLimit = Double.NaN;
    private double highVoltageLimit = Double.NaN;
    private TopologyKind topologyKind;

    VoltageLevelAdderImpl(SubstationImpl substation) {
        this.substation = substation;
        this.subnetworkRef = substation.getSubnetworkRef();
        this.networkRef = substation.getNetworkRef();
    }

    VoltageLevelAdderImpl(Ref<NetworkImpl> networkRef, Ref<SubnetworkImpl> subnetworkRef) {
        this.networkRef = networkRef;
        this.substation = null;
        this.subnetworkRef = subnetworkRef;
    }

    @Override
    protected NetworkImpl getNetwork() {
        return this.networkRef.get();
    }

    @Override
    protected String getTypeDescription() {
        return "Voltage level";
    }

    public VoltageLevelAdder setNominalV(double nominalV) {
        this.nominalV = nominalV;
        return this;
    }

    public VoltageLevelAdder setLowVoltageLimit(double lowVoltageLimit) {
        this.lowVoltageLimit = lowVoltageLimit;
        return this;
    }

    public VoltageLevelAdder setHighVoltageLimit(double highVoltageLimit) {
        this.highVoltageLimit = highVoltageLimit;
        return this;
    }

    public VoltageLevelAdder setTopologyKind(String topologyKind) {
        this.topologyKind = TopologyKind.valueOf((String)topologyKind);
        return this;
    }

    public VoltageLevelAdder setTopologyKind(TopologyKind topologyKind) {
        this.topologyKind = topologyKind;
        return this;
    }

    public VoltageLevel add() {
        String id = this.checkAndGetUniqueId();
        ValidationUtil.checkNominalV((Validable)this, (double)this.nominalV);
        ValidationUtil.checkVoltageLimits((Validable)this, (double)this.lowVoltageLimit, (double)this.highVoltageLimit);
        ValidationUtil.checkTopologyKind((Validable)this, (TopologyKind)this.topologyKind);
        AbstractVoltageLevel voltageLevel = switch (this.topologyKind) {
            case TopologyKind.NODE_BREAKER -> new NodeBreakerVoltageLevel(id, this.getName(), this.isFictitious(), this.substation, this.networkRef, this.subnetworkRef, this.nominalV, this.lowVoltageLimit, this.highVoltageLimit);
            case TopologyKind.BUS_BREAKER -> new BusBreakerVoltageLevel(id, this.getName(), this.isFictitious(), this.substation, this.networkRef, this.subnetworkRef, this.nominalV, this.lowVoltageLimit, this.highVoltageLimit);
            default -> throw new IllegalStateException();
        };
        this.getNetwork().getIndex().checkAndAdd(voltageLevel);
        Optional.ofNullable(this.substation).ifPresent(s -> s.addVoltageLevel(voltageLevel));
        this.getNetwork().getListeners().notifyCreation(voltageLevel);
        return voltageLevel;
    }
}

