/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.VscConverterStationAdder;
import com.powsybl.iidm.network.impl.AbstractHvdcConverterStationAdder;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.impl.VscConverterStationImpl;
import com.powsybl.iidm.network.impl.util.Ref;

class VscConverterStationAdderImpl
extends AbstractHvdcConverterStationAdder<VscConverterStationAdderImpl>
implements VscConverterStationAdder {
    private Boolean voltageRegulatorOn;
    private double reactivePowerSetpoint = Double.NaN;
    private double voltageSetpoint = Double.NaN;
    private TerminalExt regulatingTerminal;

    VscConverterStationAdderImpl(VoltageLevelExt voltageLevel) {
        super(voltageLevel);
    }

    @Override
    protected String getTypeDescription() {
        return "vscConverterStation";
    }

    public VscConverterStationAdderImpl setVoltageRegulatorOn(boolean voltageRegulatorOn) {
        this.voltageRegulatorOn = voltageRegulatorOn;
        return this;
    }

    public VscConverterStationAdderImpl setVoltageSetpoint(double voltageSetpoint) {
        this.voltageSetpoint = voltageSetpoint;
        return this;
    }

    public VscConverterStationAdderImpl setReactivePowerSetpoint(double reactivePowerSetpoint) {
        this.reactivePowerSetpoint = reactivePowerSetpoint;
        return this;
    }

    public VscConverterStationAdder setRegulatingTerminal(Terminal regulatingTerminal) {
        this.regulatingTerminal = (TerminalExt)regulatingTerminal;
        return this;
    }

    @Override
    protected Ref<? extends VariantManagerHolder> getVariantManagerHolder() {
        return this.getNetworkRef();
    }

    private Ref<NetworkImpl> getNetworkRef() {
        return this.getVoltageLevel().getNetworkRef();
    }

    public VscConverterStationImpl add() {
        NetworkImpl network = this.getNetwork();
        if (network.getMinValidationLevel() == ValidationLevel.EQUIPMENT && this.voltageRegulatorOn == null) {
            this.voltageRegulatorOn = false;
        }
        String id = this.checkAndGetUniqueId();
        String name = this.getName();
        TerminalExt terminal = this.checkAndGetTerminal();
        this.validate();
        VscConverterStationImpl converterStation = new VscConverterStationImpl(id, name, this.isFictitious(), this.getLossFactor(), this.getNetworkRef(), this.voltageRegulatorOn, this.reactivePowerSetpoint, this.voltageSetpoint, this.regulatingTerminal == null ? terminal : this.regulatingTerminal);
        converterStation.addTerminal(terminal);
        this.getVoltageLevel().attach(terminal, false);
        network.getIndex().checkAndAdd(converterStation);
        network.getListeners().notifyCreation(converterStation);
        return converterStation;
    }

    @Override
    protected void validate() {
        super.validate();
        NetworkImpl network = this.getNetwork();
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkVoltageControl((Validable)this, (Boolean)this.voltageRegulatorOn, (double)this.voltageSetpoint, (double)this.reactivePowerSetpoint, (ValidationLevel)network.getMinValidationLevel()));
        ValidationUtil.checkRegulatingTerminal((Validable)this, (Terminal)this.regulatingTerminal, (Network)network);
    }
}

