/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.util.trove.TBooleanArrayList;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.extensions.ActivePowerControl;
import com.powsybl.iidm.network.impl.AbstractMultiVariantIdentifiableExtension;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.List;

public class ActivePowerControlImpl<T extends Injection<T>>
extends AbstractMultiVariantIdentifiableExtension<T>
implements ActivePowerControl<T> {
    private final TBooleanArrayList participate;
    private final TDoubleArrayList droop;
    private final TDoubleArrayList participationFactor;
    private final List<TDoubleArrayList> allTDoubleArrayLists;

    public ActivePowerControlImpl(T component, boolean participate, double droop, double participationFactor) {
        super(component);
        int variantArraySize = this.getVariantManagerHolder().getVariantManager().getVariantArraySize();
        this.participate = new TBooleanArrayList(variantArraySize);
        this.droop = new TDoubleArrayList(variantArraySize);
        this.participationFactor = new TDoubleArrayList(variantArraySize);
        this.allTDoubleArrayLists = List.of(this.droop, this.participationFactor);
        for (int i = 0; i < variantArraySize; ++i) {
            this.participate.add(participate);
            this.droop.add(droop);
            this.participationFactor.add(participationFactor);
        }
    }

    public boolean isParticipate() {
        return this.participate.get(this.getVariantIndex());
    }

    public void setParticipate(boolean participate) {
        this.participate.set(this.getVariantIndex(), participate);
    }

    public double getDroop() {
        return this.droop.get(this.getVariantIndex());
    }

    public void setDroop(double droop) {
        this.droop.set(this.getVariantIndex(), droop);
    }

    public double getParticipationFactor() {
        return this.participationFactor.get(this.getVariantIndex());
    }

    public void setParticipationFactor(double participationFactor) {
        this.participationFactor.set(this.getVariantIndex(), participationFactor);
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.participate.ensureCapacity(this.participate.size() + number);
        this.allTDoubleArrayLists.forEach(dl -> dl.ensureCapacity(dl.size() + number));
        for (int i = 0; i < number; ++i) {
            this.participate.add(this.participate.get(sourceIndex));
            this.allTDoubleArrayLists.forEach(dl -> dl.add(dl.get(sourceIndex)));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        this.participate.remove(this.participate.size() - number, number);
        this.allTDoubleArrayLists.forEach(dl -> dl.remove(dl.size() - number, number));
    }

    @Override
    public void deleteVariantArrayElement(int index) {
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (int index : indexes) {
            this.participate.set(index, this.participate.get(sourceIndex));
            this.droop.set(index, this.droop.get(sourceIndex));
            this.allTDoubleArrayLists.forEach(dl -> dl.set(index, dl.get(sourceIndex)));
        }
    }
}

