/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.extensions.CoordinatedReactiveControl;
import com.powsybl.iidm.network.impl.AbstractMultiVariantIdentifiableExtension;
import gnu.trove.list.array.TDoubleArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatedReactiveControlImpl
extends AbstractMultiVariantIdentifiableExtension<Generator>
implements CoordinatedReactiveControl {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoordinatedReactiveControlImpl.class);
    private TDoubleArrayList qPercent;

    public CoordinatedReactiveControlImpl(Generator generator, double qPercent) {
        super(generator);
        int variantArraySize = this.getVariantManagerHolder().getVariantManager().getVariantArraySize();
        this.qPercent = new TDoubleArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.qPercent.add(CoordinatedReactiveControlImpl.checkQPercent(generator, qPercent));
        }
    }

    public double getQPercent() {
        return this.qPercent.get(this.getVariantIndex());
    }

    public void setQPercent(double qPercent) {
        this.qPercent.set(this.getVariantIndex(), CoordinatedReactiveControlImpl.checkQPercent((Generator)this.getExtendable(), qPercent));
    }

    private static double checkQPercent(Generator generator, double qPercent) {
        if (Double.isNaN(qPercent)) {
            throw new PowsyblException("Undefined value for qPercent");
        }
        if (qPercent < 0.0 || qPercent > 100.0) {
            LOGGER.debug("qPercent value of generator {} does not seem to be a valid percent: {}", (Object)generator.getId(), (Object)qPercent);
        }
        return qPercent;
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.qPercent.ensureCapacity(this.qPercent.size() + number);
        for (int i = 0; i < number; ++i) {
            this.qPercent.add(this.qPercent.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        this.qPercent.remove(this.qPercent.size() - number, number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (int index : indexes) {
            this.qPercent.set(index, this.qPercent.get(sourceIndex));
        }
    }
}

