/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.google.common.collect.FluentIterable;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Component;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyVisitor;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.BatteryImpl;
import com.powsybl.iidm.network.impl.BusbarSectionImpl;
import com.powsybl.iidm.network.impl.DanglingLineImpl;
import com.powsybl.iidm.network.impl.GeneratorImpl;
import com.powsybl.iidm.network.impl.LoadImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.ShuntCompensatorImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class AbstractBus
extends AbstractIdentifiable<Bus>
implements Bus {
    protected VoltageLevelExt voltageLevel;

    AbstractBus(String id, boolean fictitious, VoltageLevelExt voltageLevel) {
        this(id, id, fictitious, voltageLevel);
    }

    AbstractBus(String id, String name, boolean fictitious, VoltageLevelExt voltageLevel) {
        super(id, name, fictitious);
        this.voltageLevel = voltageLevel;
    }

    public boolean isInMainConnectedComponent() {
        Component cc = this.getConnectedComponent();
        return cc != null && cc.getNum() == 0;
    }

    public boolean isInMainSynchronousComponent() {
        Component sc = this.getSynchronousComponent();
        return sc != null && sc.getNum() == 0;
    }

    @Override
    public NetworkImpl getNetwork() {
        return this.voltageLevel.getNetwork();
    }

    public Network getParentNetwork() {
        return this.voltageLevel.getParentNetwork();
    }

    public VoltageLevel getVoltageLevel() {
        return this.voltageLevel;
    }

    public abstract Iterable<TerminalExt> getConnectedTerminals();

    public abstract Stream<TerminalExt> getConnectedTerminalStream();

    public abstract Collection<? extends TerminalExt> getTerminals();

    public double getP() {
        if (this.getConnectedTerminalCount() == 0) {
            return Double.NaN;
        }
        double p = 0.0;
        block4: for (TerminalExt terminal : this.getConnectedTerminals()) {
            AbstractConnectable connectable = terminal.getConnectable();
            switch (connectable.getType()) {
                case BUSBAR_SECTION: 
                case SHUNT_COMPENSATOR: 
                case STATIC_VAR_COMPENSATOR: 
                case LINE: 
                case TWO_WINDINGS_TRANSFORMER: 
                case THREE_WINDINGS_TRANSFORMER: 
                case DANGLING_LINE: {
                    continue block4;
                }
                case GENERATOR: 
                case BATTERY: 
                case LOAD: 
                case HVDC_CONVERTER_STATION: {
                    if (Double.isNaN(terminal.getP())) continue block4;
                    p += terminal.getP();
                    continue block4;
                }
            }
            throw new IllegalStateException();
        }
        return p;
    }

    public double getQ() {
        if (this.getConnectedTerminalCount() == 0) {
            return Double.NaN;
        }
        double q = 0.0;
        block4: for (TerminalExt terminal : this.getConnectedTerminals()) {
            AbstractConnectable connectable = terminal.getConnectable();
            switch (connectable.getType()) {
                case BUSBAR_SECTION: 
                case LINE: 
                case TWO_WINDINGS_TRANSFORMER: 
                case THREE_WINDINGS_TRANSFORMER: 
                case DANGLING_LINE: {
                    continue block4;
                }
                case SHUNT_COMPENSATOR: 
                case STATIC_VAR_COMPENSATOR: 
                case GENERATOR: 
                case BATTERY: 
                case LOAD: 
                case HVDC_CONVERTER_STATION: {
                    if (Double.isNaN(terminal.getQ())) continue block4;
                    q += terminal.getQ();
                    continue block4;
                }
            }
            throw new IllegalStateException();
        }
        return q;
    }

    private <C extends Connectable> Iterable<C> getConnectables(Class<C> clazz) {
        if (this.getConnectedTerminalCount() == 0) {
            return Collections.emptyList();
        }
        return FluentIterable.from(this.getConnectedTerminals()).transform(Terminal::getConnectable).filter(clazz);
    }

    protected <C extends Connectable> Stream<C> getConnectableStream(Class<C> clazz) {
        if (this.getConnectedTerminalCount() == 0) {
            return Stream.empty();
        }
        return this.getConnectedTerminalStream().map(TerminalExt::getConnectable).filter(clazz::isInstance).map(clazz::cast);
    }

    public Iterable<Line> getLines() {
        return this.getConnectables(Line.class);
    }

    public Stream<Line> getLineStream() {
        return this.getConnectableStream(Line.class);
    }

    public Iterable<TwoWindingsTransformer> getTwoWindingsTransformers() {
        return this.getConnectables(TwoWindingsTransformer.class);
    }

    public Stream<TwoWindingsTransformer> getTwoWindingsTransformerStream() {
        return this.getConnectableStream(TwoWindingsTransformer.class);
    }

    public Iterable<ThreeWindingsTransformer> getThreeWindingsTransformers() {
        return this.getConnectables(ThreeWindingsTransformer.class);
    }

    public Stream<ThreeWindingsTransformer> getThreeWindingsTransformerStream() {
        return this.getConnectableStream(ThreeWindingsTransformer.class);
    }

    public Iterable<Load> getLoads() {
        return this.getConnectables(Load.class);
    }

    public Stream<Load> getLoadStream() {
        return this.getConnectableStream(Load.class);
    }

    public Iterable<ShuntCompensator> getShuntCompensators() {
        return this.getConnectables(ShuntCompensator.class);
    }

    public Stream<ShuntCompensator> getShuntCompensatorStream() {
        return this.getConnectableStream(ShuntCompensator.class);
    }

    public Iterable<Generator> getGenerators() {
        return this.getConnectables(Generator.class);
    }

    public Stream<Generator> getGeneratorStream() {
        return this.getConnectableStream(Generator.class);
    }

    public Iterable<Battery> getBatteries() {
        return this.getConnectables(Battery.class);
    }

    public Stream<Battery> getBatteryStream() {
        return this.getConnectableStream(Battery.class);
    }

    public Iterable<DanglingLine> getDanglingLines(DanglingLineFilter danglingLineFilter) {
        return this.getDanglingLineStream(danglingLineFilter).collect(Collectors.toList());
    }

    public Stream<DanglingLine> getDanglingLineStream(DanglingLineFilter danglingLineFilter) {
        return this.getConnectableStream(DanglingLine.class).filter(danglingLineFilter.getPredicate());
    }

    public Iterable<StaticVarCompensator> getStaticVarCompensators() {
        return this.getConnectables(StaticVarCompensator.class);
    }

    public Stream<StaticVarCompensator> getStaticVarCompensatorStream() {
        return this.getConnectableStream(StaticVarCompensator.class);
    }

    public Iterable<LccConverterStation> getLccConverterStations() {
        return this.getConnectables(LccConverterStation.class);
    }

    public Stream<LccConverterStation> getLccConverterStationStream() {
        return this.getConnectableStream(LccConverterStation.class);
    }

    public Iterable<VscConverterStation> getVscConverterStations() {
        return this.getConnectables(VscConverterStation.class);
    }

    public Stream<VscConverterStation> getVscConverterStationStream() {
        return this.getConnectableStream(VscConverterStation.class);
    }

    public void visitConnectedEquipments(TopologyVisitor visitor) {
        AbstractBus.visitEquipments(this.getConnectedTerminals(), visitor);
    }

    public void visitConnectedOrConnectableEquipments(TopologyVisitor visitor) {
        AbstractBus.visitEquipments(this.getTerminals(), visitor);
    }

    static <T extends Terminal> void visitEquipments(Iterable<T> terminals, TopologyVisitor visitor) {
        if (visitor == null) {
            throw new NullPointerException("visitor is null");
        }
        block13: for (Terminal terminal : terminals) {
            AbstractConnectable connectable = ((TerminalExt)terminal).getConnectable();
            switch (connectable.getType()) {
                case BUSBAR_SECTION: {
                    visitor.visitBusbarSection((BusbarSection)((BusbarSectionImpl)connectable));
                    continue block13;
                }
                case LINE: {
                    Line line = (Line)connectable;
                    visitor.visitLine(line, line.getTerminal1() == terminal ? TwoSides.ONE : TwoSides.TWO);
                    continue block13;
                }
                case GENERATOR: {
                    visitor.visitGenerator((Generator)((GeneratorImpl)connectable));
                    continue block13;
                }
                case BATTERY: {
                    visitor.visitBattery((Battery)((BatteryImpl)connectable));
                    continue block13;
                }
                case SHUNT_COMPENSATOR: {
                    visitor.visitShuntCompensator((ShuntCompensator)((ShuntCompensatorImpl)connectable));
                    continue block13;
                }
                case TWO_WINDINGS_TRANSFORMER: {
                    TwoWindingsTransformer twt = (TwoWindingsTransformer)connectable;
                    visitor.visitTwoWindingsTransformer(twt, twt.getTerminal1() == terminal ? TwoSides.ONE : TwoSides.TWO);
                    continue block13;
                }
                case THREE_WINDINGS_TRANSFORMER: {
                    ThreeWindingsTransformer thwt = (ThreeWindingsTransformer)connectable;
                    ThreeSides side = thwt.getLeg1().getTerminal() == terminal ? ThreeSides.ONE : (thwt.getLeg2().getTerminal() == terminal ? ThreeSides.TWO : ThreeSides.THREE);
                    visitor.visitThreeWindingsTransformer(thwt, side);
                    continue block13;
                }
                case LOAD: {
                    visitor.visitLoad((Load)((LoadImpl)connectable));
                    continue block13;
                }
                case DANGLING_LINE: {
                    visitor.visitDanglingLine((DanglingLine)((DanglingLineImpl)connectable));
                    continue block13;
                }
                case STATIC_VAR_COMPENSATOR: {
                    visitor.visitStaticVarCompensator((StaticVarCompensator)connectable);
                    continue block13;
                }
                case HVDC_CONVERTER_STATION: {
                    visitor.visitHvdcConverterStation((HvdcConverterStation)connectable);
                    continue block13;
                }
            }
            throw new IllegalStateException();
        }
    }

    @Override
    protected String getTypeDescription() {
        return "Bus";
    }
}

