/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractOperationalLimits;
import com.powsybl.iidm.network.impl.OperationalLimitsOwner;
import java.util.Collection;
import java.util.Objects;
import java.util.TreeMap;

abstract class AbstractLoadingLimits<L extends AbstractLoadingLimits<L>>
extends AbstractOperationalLimits
implements LoadingLimits {
    private double permanentLimit;
    private final TreeMap<Integer, LoadingLimits.TemporaryLimit> temporaryLimits;

    AbstractLoadingLimits(OperationalLimitsOwner owner, double permanentLimit, TreeMap<Integer, LoadingLimits.TemporaryLimit> temporaryLimits) {
        super(owner);
        this.permanentLimit = permanentLimit;
        this.temporaryLimits = Objects.requireNonNull(temporaryLimits);
    }

    public double getPermanentLimit() {
        return this.permanentLimit;
    }

    public L setPermanentLimit(double permanentLimit) {
        ValidationUtil.checkPermanentLimit((Validable)this.owner, (double)permanentLimit);
        double oldValue = this.permanentLimit;
        this.permanentLimit = permanentLimit;
        this.owner.notifyUpdate(this.getLimitType(), "permanentLimit", oldValue, this.permanentLimit);
        return (L)this;
    }

    public Collection<LoadingLimits.TemporaryLimit> getTemporaryLimits() {
        return this.temporaryLimits.values();
    }

    public LoadingLimits.TemporaryLimit getTemporaryLimit(int acceptableDuration) {
        return this.temporaryLimits.get(acceptableDuration);
    }

    public double getTemporaryLimitValue(int acceptableDuration) {
        LoadingLimits.TemporaryLimit tl = this.getTemporaryLimit(acceptableDuration);
        return tl != null ? tl.getValue() : Double.NaN;
    }

    static class TemporaryLimitImpl
    implements LoadingLimits.TemporaryLimit {
        private final String name;
        private final double value;
        private final int acceptableDuration;
        private final boolean fictitious;

        TemporaryLimitImpl(String name, double value, int acceptableDuration, boolean hasOverloadingProtection) {
            this.name = Objects.requireNonNull(name);
            this.value = value;
            this.acceptableDuration = acceptableDuration;
            this.fictitious = hasOverloadingProtection;
        }

        public String getName() {
            return this.name;
        }

        public double getValue() {
            return this.value;
        }

        public int getAcceptableDuration() {
            return this.acceptableDuration;
        }

        public boolean isFictitious() {
            return this.fictitious;
        }
    }
}

