/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.LoadingLimitsAdder;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractLoadingLimits;
import com.powsybl.iidm.network.impl.OperationalLimitsOwner;
import java.util.Comparator;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLoadingLimitsAdder<L extends LoadingLimits, A extends LoadingLimitsAdder<L, A>>
implements LoadingLimitsAdder<L, A> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLoadingLimitsAdder.class);
    private static final Comparator<Integer> ACCEPTABLE_DURATION_COMPARATOR = (acceptableDuration1, acceptableDuration2) -> acceptableDuration2 - acceptableDuration1;
    protected final OperationalLimitsOwner owner;
    protected double permanentLimit = Double.NaN;
    protected final TreeMap<Integer, LoadingLimits.TemporaryLimit> temporaryLimits = new TreeMap(ACCEPTABLE_DURATION_COMPARATOR);

    AbstractLoadingLimitsAdder(OperationalLimitsOwner owner) {
        this.owner = owner;
    }

    public A setPermanentLimit(double permanentLimit) {
        this.permanentLimit = permanentLimit;
        return (A)this;
    }

    public LoadingLimitsAdder.TemporaryLimitAdder<A> beginTemporaryLimit() {
        return new TemporaryLimitAdderImpl();
    }

    public double getPermanentLimit() {
        return this.permanentLimit;
    }

    public double getTemporaryLimitValue(int acceptableDuration) {
        return Optional.ofNullable(this.temporaryLimits.get(acceptableDuration)).map(LoadingLimits.TemporaryLimit::getValue).orElse(Double.NaN);
    }

    public boolean hasTemporaryLimits() {
        return !this.temporaryLimits.isEmpty();
    }

    private void checkTemporaryLimits() {
        double previousLimit = Double.NaN;
        for (LoadingLimits.TemporaryLimit tl : this.temporaryLimits.values()) {
            if (tl.getValue() <= this.permanentLimit) {
                LOGGER.debug("{}, temporary limit should be greater than permanent limit", (Object)this.owner.getMessageHeader());
            }
            if (Double.isNaN(previousLimit)) {
                previousLimit = tl.getValue();
                continue;
            }
            if (!(tl.getValue() <= previousLimit)) continue;
            LOGGER.debug("{} : temporary limits should be in ascending value order", (Object)this.owner.getMessageHeader());
        }
        this.temporaryLimits.values().stream().collect(Collectors.groupingBy(LoadingLimits.TemporaryLimit::getName)).forEach((name, temporaryLimits1) -> {
            if (temporaryLimits1.size() > 1) {
                throw new ValidationException((Validable)this.owner, temporaryLimits1.size() + "temporary limits have the same name " + name);
            }
        });
    }

    protected void checkLoadingLimits() {
        ValidationUtil.checkPermanentLimit((Validable)this.owner, (double)this.permanentLimit);
        this.checkTemporaryLimits();
    }

    public class TemporaryLimitAdderImpl<B extends LoadingLimitsAdder<L, B>>
    implements LoadingLimitsAdder.TemporaryLimitAdder<B> {
        private String name;
        private double value = Double.NaN;
        private Integer acceptableDuration;
        private boolean fictitious = false;
        private boolean ensureNameUnicity = false;

        public LoadingLimitsAdder.TemporaryLimitAdder<B> setName(String name) {
            this.name = name;
            return this;
        }

        public LoadingLimitsAdder.TemporaryLimitAdder<B> setValue(double value) {
            this.value = value;
            return this;
        }

        public LoadingLimitsAdder.TemporaryLimitAdder<B> setAcceptableDuration(int acceptableDuration) {
            this.acceptableDuration = acceptableDuration;
            return this;
        }

        public LoadingLimitsAdder.TemporaryLimitAdder<B> setFictitious(boolean fictitious) {
            this.fictitious = fictitious;
            return this;
        }

        public LoadingLimitsAdder.TemporaryLimitAdder<B> ensureNameUnicity() {
            this.ensureNameUnicity = true;
            return this;
        }

        public B endTemporaryLimit() {
            if (Double.isNaN(this.value)) {
                throw new ValidationException((Validable)AbstractLoadingLimitsAdder.this.owner, "temporary limit value is not set");
            }
            if (this.value <= 0.0) {
                throw new ValidationException((Validable)AbstractLoadingLimitsAdder.this.owner, "temporary limit value must be > 0");
            }
            if (this.acceptableDuration == null) {
                throw new ValidationException((Validable)AbstractLoadingLimitsAdder.this.owner, "acceptable duration is not set");
            }
            if (this.acceptableDuration < 0) {
                throw new ValidationException((Validable)AbstractLoadingLimitsAdder.this.owner, "acceptable duration must be >= 0");
            }
            this.checkAndGetUniqueName();
            AbstractLoadingLimitsAdder.this.temporaryLimits.put(this.acceptableDuration, new AbstractLoadingLimits.TemporaryLimitImpl(this.name, this.value, this.acceptableDuration, this.fictitious));
            return (B)AbstractLoadingLimitsAdder.this;
        }

        private void checkAndGetUniqueName() {
            if (this.name == null) {
                throw new ValidationException((Validable)AbstractLoadingLimitsAdder.this.owner, "name is not set");
            }
            if (this.ensureNameUnicity) {
                Object uniqueName = this.name;
                for (int i = 0; i < Integer.MAX_VALUE && this.nameExists((String)uniqueName); ++i) {
                    uniqueName = this.name + "#" + i;
                }
                this.name = uniqueName;
            }
        }

        private boolean nameExists(String name) {
            return AbstractLoadingLimitsAdder.this.temporaryLimits.values().stream().anyMatch(t -> t.getName().equals(name));
        }
    }
}

