/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.BatteryAdder;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.ContainerType;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.LccConverterStationAdder;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyVisitor;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.VscConverterStationAdder;
import com.powsybl.iidm.network.impl.AbstractBus;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.BatteryAdderImpl;
import com.powsybl.iidm.network.impl.DanglingLineAdderImpl;
import com.powsybl.iidm.network.impl.GeneratorAdderImpl;
import com.powsybl.iidm.network.impl.LccConverterStationAdderImpl;
import com.powsybl.iidm.network.impl.LoadAdderImpl;
import com.powsybl.iidm.network.impl.NetworkExt;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.ShuntCompensatorAdderImpl;
import com.powsybl.iidm.network.impl.StaticVarCompensatorAdderImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import com.powsybl.iidm.network.impl.SubstationImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.impl.VoltageLevels;
import com.powsybl.iidm.network.impl.VscConverterStationAdderImpl;
import com.powsybl.iidm.network.impl.util.Ref;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class AbstractVoltageLevel
extends AbstractIdentifiable<VoltageLevel>
implements VoltageLevelExt {
    private static final int DEFAULT_NODE_INDEX_LIMIT = 1000;
    public static final int NODE_INDEX_LIMIT = AbstractVoltageLevel.loadNodeIndexLimit(PlatformConfig.defaultConfig());
    private final Ref<NetworkImpl> networkRef;
    private Ref<SubnetworkImpl> subnetworkRef;
    private final SubstationImpl substation;
    private double nominalV;
    private double lowVoltageLimit;
    private double highVoltageLimit;
    private boolean removed = false;

    AbstractVoltageLevel(String id, String name, boolean fictitious, SubstationImpl substation, Ref<NetworkImpl> networkRef, Ref<SubnetworkImpl> subnetworkRef, double nominalV, double lowVoltageLimit, double highVoltageLimit) {
        super(id, name, fictitious);
        this.substation = substation;
        this.networkRef = networkRef;
        this.subnetworkRef = subnetworkRef;
        this.nominalV = nominalV;
        this.lowVoltageLimit = lowVoltageLimit;
        this.highVoltageLimit = highVoltageLimit;
    }

    protected static int loadNodeIndexLimit(PlatformConfig platformConfig) {
        return platformConfig.getOptionalModuleConfig("iidm").map(moduleConfig -> moduleConfig.getIntProperty("node-index-limit", 1000)).orElse(1000);
    }

    @Override
    public String getSubnetworkId() {
        return Optional.ofNullable(this.subnetworkRef.get()).map(Identifiable::getId).orElse(null);
    }

    @Override
    public Ref<NetworkImpl> getNetworkRef() {
        return this.networkRef;
    }

    public ContainerType getContainerType() {
        return ContainerType.VOLTAGE_LEVEL;
    }

    public Optional<Substation> getSubstation() {
        if (this.removed) {
            throw new PowsyblException("Cannot access substation of removed voltage level " + this.id);
        }
        return Optional.ofNullable(this.substation);
    }

    public Substation getNullableSubstation() {
        return this.substation;
    }

    @Override
    public NetworkImpl getNetwork() {
        if (this.removed) {
            throw new PowsyblException("Cannot access network of removed voltage level " + this.id);
        }
        return Optional.ofNullable(this.networkRef).map(Ref::get).orElseGet(() -> Optional.ofNullable(this.substation).map(SubstationImpl::getNetwork).orElseThrow(() -> new PowsyblException(String.format("Voltage level %s has no container", this.id))));
    }

    @Override
    public NetworkExt getParentNetwork() {
        SubnetworkImpl subnetwork = this.subnetworkRef.get();
        return subnetwork != null ? subnetwork : this.getNetwork();
    }

    private void notifyUpdate(String attribute, Object oldValue, Object newValue) {
        this.getNetwork().getListeners().notifyUpdate((Identifiable)this, attribute, oldValue, newValue);
    }

    public double getNominalV() {
        return this.nominalV;
    }

    public VoltageLevelExt setNominalV(double nominalV) {
        ValidationUtil.checkNominalV((Validable)this, (double)nominalV);
        double oldValue = this.nominalV;
        this.nominalV = nominalV;
        this.notifyUpdate("nominalV", oldValue, nominalV);
        return this;
    }

    public double getLowVoltageLimit() {
        return this.lowVoltageLimit;
    }

    public VoltageLevel setLowVoltageLimit(double lowVoltageLimit) {
        ValidationUtil.checkVoltageLimits((Validable)this, (double)lowVoltageLimit, (double)this.highVoltageLimit);
        double oldValue = this.lowVoltageLimit;
        this.lowVoltageLimit = lowVoltageLimit;
        this.notifyUpdate("lowVoltageLimit", oldValue, lowVoltageLimit);
        return this;
    }

    public double getHighVoltageLimit() {
        return this.highVoltageLimit;
    }

    public VoltageLevel setHighVoltageLimit(double highVoltageLimit) {
        ValidationUtil.checkVoltageLimits((Validable)this, (double)this.lowVoltageLimit, (double)highVoltageLimit);
        double oldValue = this.highVoltageLimit;
        this.highVoltageLimit = highVoltageLimit;
        this.notifyUpdate("highVoltageLimit", oldValue, highVoltageLimit);
        return this;
    }

    public <T extends Connectable> T getConnectable(String id, Class<T> aClass) {
        Connectable connectable = (Connectable)this.getNetwork().getIndex().get(id, aClass);
        if (connectable == null) {
            return null;
        }
        if (connectable instanceof Injection) {
            Injection injection = (Injection)connectable;
            return (T)(injection.getTerminal().getVoltageLevel() == this ? connectable : null);
        }
        if (connectable instanceof Branch) {
            Branch branch = (Branch)connectable;
            return (T)(branch.getTerminal1().getVoltageLevel() == this || branch.getTerminal2().getVoltageLevel() == this ? connectable : null);
        }
        if (connectable instanceof ThreeWindingsTransformer) {
            ThreeWindingsTransformer twt = (ThreeWindingsTransformer)connectable;
            return (T)(twt.getLeg1().getTerminal().getVoltageLevel() == this || twt.getLeg2().getTerminal().getVoltageLevel() == this || twt.getLeg3().getTerminal().getVoltageLevel() == this ? connectable : null);
        }
        throw new IllegalStateException();
    }

    public <T extends Connectable> Iterable<T> getConnectables(Class<T> clazz) {
        Iterable<Terminal> terminals = this.getTerminals();
        return FluentIterable.from(terminals).transform(Terminal::getConnectable).filter(clazz).toSet();
    }

    public <T extends Connectable> Stream<T> getConnectableStream(Class<T> clazz) {
        return this.getTerminalStream().map(Terminal::getConnectable).filter(clazz::isInstance).map(clazz::cast).distinct();
    }

    public <T extends Connectable> int getConnectableCount(Class<T> clazz) {
        return Ints.checkedCast((long)this.getConnectableStream(clazz).count());
    }

    public Iterable<Connectable> getConnectables() {
        return FluentIterable.from(this.getTerminals()).transform(Terminal::getConnectable).toSet();
    }

    public Stream<Connectable> getConnectableStream() {
        return this.getTerminalStream().map(Terminal::getConnectable).distinct();
    }

    public int getConnectableCount() {
        return Ints.checkedCast((long)this.getConnectableStream().count());
    }

    public GeneratorAdder newGenerator() {
        return new GeneratorAdderImpl(this);
    }

    public Iterable<Generator> getGenerators() {
        return this.getConnectables(Generator.class);
    }

    public Stream<Generator> getGeneratorStream() {
        return this.getConnectableStream(Generator.class);
    }

    public int getGeneratorCount() {
        return this.getConnectableCount(Generator.class);
    }

    public BatteryAdder newBattery() {
        return new BatteryAdderImpl(this);
    }

    public Iterable<Battery> getBatteries() {
        return this.getConnectables(Battery.class);
    }

    public Stream<Battery> getBatteryStream() {
        return this.getConnectableStream(Battery.class);
    }

    public int getBatteryCount() {
        return this.getConnectableCount(Battery.class);
    }

    public LoadAdder newLoad() {
        return new LoadAdderImpl(this);
    }

    public Iterable<Load> getLoads() {
        return this.getConnectables(Load.class);
    }

    public Stream<Load> getLoadStream() {
        return this.getConnectableStream(Load.class);
    }

    public int getLoadCount() {
        return this.getConnectableCount(Load.class);
    }

    public ShuntCompensatorAdder newShuntCompensator() {
        return new ShuntCompensatorAdderImpl(this);
    }

    public int getShuntCompensatorCount() {
        return this.getConnectableCount(ShuntCompensator.class);
    }

    public Iterable<ShuntCompensator> getShuntCompensators() {
        return this.getConnectables(ShuntCompensator.class);
    }

    public Stream<ShuntCompensator> getShuntCompensatorStream() {
        return this.getConnectableStream(ShuntCompensator.class);
    }

    public DanglingLineAdder newDanglingLine() {
        return new DanglingLineAdderImpl(this);
    }

    public Iterable<DanglingLine> getDanglingLines(DanglingLineFilter danglingLineFilter) {
        return this.getDanglingLineStream(danglingLineFilter).collect(Collectors.toList());
    }

    public Stream<DanglingLine> getDanglingLineStream(DanglingLineFilter danglingLineFilter) {
        return this.getConnectableStream(DanglingLine.class).filter(danglingLineFilter.getPredicate());
    }

    public int getDanglingLineCount() {
        return this.getConnectableCount(DanglingLine.class);
    }

    public StaticVarCompensatorAdderImpl newStaticVarCompensator() {
        return new StaticVarCompensatorAdderImpl(this);
    }

    public Iterable<StaticVarCompensator> getStaticVarCompensators() {
        return this.getConnectables(StaticVarCompensator.class);
    }

    public Stream<StaticVarCompensator> getStaticVarCompensatorStream() {
        return this.getConnectableStream(StaticVarCompensator.class);
    }

    public int getStaticVarCompensatorCount() {
        return this.getConnectableCount(StaticVarCompensator.class);
    }

    public int getVscConverterStationCount() {
        return this.getConnectableCount(VscConverterStation.class);
    }

    public Iterable<VscConverterStation> getVscConverterStations() {
        return this.getConnectables(VscConverterStation.class);
    }

    public Stream<VscConverterStation> getVscConverterStationStream() {
        return this.getConnectableStream(VscConverterStation.class);
    }

    public VscConverterStationAdder newVscConverterStation() {
        return new VscConverterStationAdderImpl(this);
    }

    public int getLccConverterStationCount() {
        return this.getConnectableCount(LccConverterStation.class);
    }

    public Iterable<LccConverterStation> getLccConverterStations() {
        return this.getConnectables(LccConverterStation.class);
    }

    public Stream<LccConverterStation> getLccConverterStationStream() {
        return this.getConnectableStream(LccConverterStation.class);
    }

    public LccConverterStationAdder newLccConverterStation() {
        return new LccConverterStationAdderImpl(this);
    }

    public int getLineCount() {
        return this.getConnectableCount(Line.class);
    }

    public Iterable<Line> getLines() {
        return this.getConnectables(Line.class);
    }

    public Stream<Line> getLineStream() {
        return this.getConnectableStream(Line.class);
    }

    public int getTwoWindingsTransformerCount() {
        return this.getConnectableCount(TwoWindingsTransformer.class);
    }

    public Iterable<TwoWindingsTransformer> getTwoWindingsTransformers() {
        return this.getConnectables(TwoWindingsTransformer.class);
    }

    public Stream<TwoWindingsTransformer> getTwoWindingsTransformerStream() {
        return this.getConnectableStream(TwoWindingsTransformer.class);
    }

    public int getThreeWindingsTransformerCount() {
        return this.getConnectableCount(ThreeWindingsTransformer.class);
    }

    public Iterable<ThreeWindingsTransformer> getThreeWindingsTransformers() {
        return this.getConnectables(ThreeWindingsTransformer.class);
    }

    public Stream<ThreeWindingsTransformer> getThreeWindingsTransformerStream() {
        return this.getConnectableStream(ThreeWindingsTransformer.class);
    }

    @Override
    protected String getTypeDescription() {
        return "Voltage level";
    }

    protected abstract Iterable<Terminal> getTerminals();

    protected abstract Stream<Terminal> getTerminalStream();

    public void visitEquipments(TopologyVisitor visitor) {
        AbstractBus.visitEquipments(this.getTerminals(), visitor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void addNextTerminals(TerminalExt otherTerminal, List<TerminalExt> nextTerminals) {
        Objects.requireNonNull(otherTerminal);
        Objects.requireNonNull(nextTerminals);
        AbstractConnectable otherConnectable = otherTerminal.getConnectable();
        if (otherConnectable instanceof Branch) {
            Branch branch = (Branch)otherConnectable;
            if (branch.getTerminal1() == otherTerminal) {
                nextTerminals.add((TerminalExt)branch.getTerminal2());
                return;
            } else {
                if (branch.getTerminal2() != otherTerminal) throw new IllegalStateException();
                nextTerminals.add((TerminalExt)branch.getTerminal1());
            }
            return;
        } else {
            if (!(otherConnectable instanceof ThreeWindingsTransformer)) return;
            ThreeWindingsTransformer ttc = (ThreeWindingsTransformer)otherConnectable;
            if (ttc.getLeg1().getTerminal() == otherTerminal) {
                nextTerminals.add((TerminalExt)ttc.getLeg2().getTerminal());
                nextTerminals.add((TerminalExt)ttc.getLeg3().getTerminal());
                return;
            } else if (ttc.getLeg2().getTerminal() == otherTerminal) {
                nextTerminals.add((TerminalExt)ttc.getLeg1().getTerminal());
                nextTerminals.add((TerminalExt)ttc.getLeg3().getTerminal());
                return;
            } else {
                if (ttc.getLeg3().getTerminal() != otherTerminal) throw new IllegalStateException();
                nextTerminals.add((TerminalExt)ttc.getLeg1().getTerminal());
                nextTerminals.add((TerminalExt)ttc.getLeg2().getTerminal());
            }
        }
    }

    public void remove() {
        VoltageLevels.checkRemovability(this);
        NetworkImpl network = this.getNetwork();
        network.getListeners().notifyBeforeRemoval(this);
        ArrayList connectables = Lists.newArrayList(this.getConnectables());
        for (Connectable connectable : connectables) {
            connectable.remove();
        }
        this.removeTopology();
        this.getSubstation().map(SubstationImpl.class::cast).ifPresent(s -> s.remove(this));
        network.getIndex().remove(this);
        network.getListeners().notifyAfterRemoval(this.id);
        this.removed = true;
    }

    protected abstract void removeTopology();
}

