/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.util.trove.TBooleanArrayList;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyPoint;
import com.powsybl.iidm.network.impl.AbstractTerminal;
import com.powsybl.iidm.network.impl.BusBreakerVoltageLevel;
import com.powsybl.iidm.network.impl.BusExt;
import com.powsybl.iidm.network.impl.BusTopologyPointImpl;
import com.powsybl.iidm.network.impl.ConfiguredBus;
import com.powsybl.iidm.network.impl.MergedBus;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import com.powsybl.iidm.network.impl.util.Ref;
import com.powsybl.math.graph.TraversalType;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;

class BusTerminal
extends AbstractTerminal {
    private final Terminal.NodeBreakerView nodeBreakerView = new Terminal.NodeBreakerView(){

        public int getNode() {
            throw BusBreakerVoltageLevel.createNotSupportedBusBreakerTopologyException();
        }

        public void moveConnectable(int node, String voltageLevelId) {
            if (BusTerminal.this.removed) {
                throw new PowsyblException("Cannot modify removed equipment " + BusTerminal.this.connectable.id);
            }
            BusTerminal.this.getConnectable().move((TerminalExt)BusTerminal.this, BusTerminal.this.getTopologyPoint(), node, voltageLevelId);
        }
    };
    private final TerminalExt.BusBreakerViewExt busBreakerView = new TerminalExt.BusBreakerViewExt(){

        @Override
        public BusExt getBus() {
            if (BusTerminal.this.removed) {
                throw new PowsyblException("Cannot access bus of removed equipment " + BusTerminal.this.connectable.id);
            }
            return BusTerminal.this.isConnected() ? this.getConnectableBus() : null;
        }

        public ConfiguredBus getConnectableBus() {
            if (BusTerminal.this.removed) {
                throw new PowsyblException("Cannot access bus of removed equipment " + BusTerminal.this.connectable.id);
            }
            return ((BusBreakerVoltageLevel)BusTerminal.this.voltageLevel).getBus(BusTerminal.this.getConnectableBusId(), true);
        }

        public void setConnectableBus(String busId) {
            if (BusTerminal.this.removed) {
                throw new PowsyblException("Cannot modify removed equipment " + BusTerminal.this.connectable.id);
            }
            Objects.requireNonNull(busId);
            BusBreakerVoltageLevel vl = (BusBreakerVoltageLevel)BusTerminal.this.voltageLevel;
            vl.getBus(busId, true);
            vl.detach(BusTerminal.this);
            int variantIndex = BusTerminal.this.getVariantManagerHolder().getVariantIndex();
            String oldValue = BusTerminal.this.connectableBusId.set(variantIndex, busId);
            vl.attach(BusTerminal.this, false);
            String variantId = BusTerminal.this.getVariantManagerHolder().getVariantManager().getVariantId(variantIndex);
            BusTerminal.this.getConnectable().notifyUpdate("connectableBusId", variantId, (Object)oldValue, (Object)busId);
        }

        public void moveConnectable(String busId, boolean connected) {
            if (BusTerminal.this.removed) {
                throw new PowsyblException("Cannot modify removed equipment " + BusTerminal.this.connectable.id);
            }
            BusTerminal.this.getConnectable().move((TerminalExt)BusTerminal.this, BusTerminal.this.getTopologyPoint(), busId, connected);
        }
    };
    private final TerminalExt.BusViewExt busView = new TerminalExt.BusViewExt(){

        @Override
        public BusExt getBus() {
            if (BusTerminal.this.removed) {
                throw new PowsyblException("Cannot access bus of removed equipment " + BusTerminal.this.connectable.id);
            }
            return BusTerminal.this.isConnected() ? this.getConnectableBus() : null;
        }

        public MergedBus getConnectableBus() {
            if (BusTerminal.this.removed) {
                throw new PowsyblException("Cannot access bus of removed equipment " + BusTerminal.this.connectable.id);
            }
            ConfiguredBus bus = ((BusBreakerVoltageLevel)BusTerminal.this.voltageLevel).getBus(BusTerminal.this.getConnectableBusId(), true);
            return ((BusBreakerVoltageLevel)BusTerminal.this.voltageLevel).calculatedBusTopology.getMergedBus(bus);
        }
    };
    private final TBooleanArrayList connected;
    private final ArrayList<String> connectableBusId;

    @Override
    public TopologyPoint getTopologyPoint() {
        return new BusTopologyPointImpl(this.getVoltageLevel().getId(), this.getConnectableBusId(), this.isConnected());
    }

    BusTerminal(Ref<? extends VariantManagerHolder> network, String connectableBusId, boolean connected) {
        super(network);
        Objects.requireNonNull(connectableBusId);
        int variantArraySize = network.get().getVariantManager().getVariantArraySize();
        this.connected = new TBooleanArrayList(variantArraySize);
        this.connectableBusId = new ArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.connected.add(connected);
            this.connectableBusId.add(connectableBusId);
        }
    }

    void setConnectableBusId(String connectableBusId) {
        if (this.removed) {
            throw new PowsyblException("Cannot modify removed equipment " + this.connectable.id);
        }
        int variantIndex = this.getVariantManagerHolder().getVariantIndex();
        String oldValue = this.connectableBusId.set(variantIndex, connectableBusId);
        String variantId = this.getVariantManagerHolder().getVariantManager().getVariantId(variantIndex);
        this.getConnectable().notifyUpdate("connectableBusId", variantId, (Object)oldValue, (Object)connectableBusId);
    }

    String getConnectableBusId() {
        if (this.removed) {
            throw new PowsyblException("Cannot access bus of removed equipment " + this.connectable.id);
        }
        return this.connectableBusId.get(this.getVariantManagerHolder().getVariantIndex());
    }

    void setConnected(boolean connected) {
        if (this.removed) {
            throw new PowsyblException("Cannot modify removed equipment " + this.connectable.id);
        }
        int variantIndex = this.getVariantManagerHolder().getVariantIndex();
        boolean oldValue = this.connected.set(variantIndex, connected);
        String variantId = this.getVariantManagerHolder().getVariantManager().getVariantId(variantIndex);
        this.getConnectable().notifyUpdate("connected", variantId, (Object)oldValue, (Object)connected);
    }

    public boolean isConnected() {
        if (this.removed) {
            throw new PowsyblException("Cannot access connectivity status of removed equipment " + this.connectable.id);
        }
        return this.connected.get(this.getVariantManagerHolder().getVariantIndex());
    }

    @Override
    public boolean traverse(Terminal.TopologyTraverser traverser, Set<Terminal> visitedTerminals, TraversalType traversalType) {
        if (this.removed) {
            throw new PowsyblException(String.format("Associated equipment %s is removed", this.connectable.id));
        }
        return ((BusBreakerVoltageLevel)this.voltageLevel).traverse(this, traverser, visitedTerminals, traversalType);
    }

    public void traverse(Terminal.TopologyTraverser traverser) {
        this.traverse(traverser, TraversalType.DEPTH_FIRST);
    }

    public void traverse(Terminal.TopologyTraverser traverser, TraversalType traversalType) {
        if (this.removed) {
            throw new PowsyblException(String.format("Associated equipment %s is removed", this.connectable.id));
        }
        ((BusBreakerVoltageLevel)this.voltageLevel).traverse(this, traverser, traversalType);
    }

    @Override
    protected double getV() {
        if (this.removed) {
            throw new PowsyblException("Cannot access v of removed equipment " + this.connectable.id);
        }
        return this.busBreakerView.getBus() != null ? this.busBreakerView.getBus().getV() : Double.NaN;
    }

    public Terminal.NodeBreakerView getNodeBreakerView() {
        return this.nodeBreakerView;
    }

    @Override
    public TerminalExt.BusBreakerViewExt getBusBreakerView() {
        return this.busBreakerView;
    }

    @Override
    public TerminalExt.BusViewExt getBusView() {
        return this.busView;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getConnectableBusId() + "]";
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.connected.ensureCapacity(this.connected.size() + number);
        this.connectableBusId.ensureCapacity(this.connectableBusId.size() + number);
        for (int i = 0; i < number; ++i) {
            this.connected.add(this.connected.get(sourceIndex));
            this.connectableBusId.add(this.connectableBusId.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        for (int i = 0; i < number; ++i) {
            this.connected.removeAt(this.connected.size() - 1);
            this.connectableBusId.remove(this.connectableBusId.size() - 1);
        }
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
        this.connectableBusId.set(index, null);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.connected.set(index, this.connected.get(sourceIndex));
            this.connectableBusId.set(index, this.connectableBusId.get(sourceIndex));
        }
    }
}

