/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.ExponentialLoadModelAdder;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.LoadType;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.ZipLoadModelAdder;
import com.powsybl.iidm.network.impl.AbstractInjectionAdder;
import com.powsybl.iidm.network.impl.AbstractLoadModelImpl;
import com.powsybl.iidm.network.impl.ExponentialLoadModelAdderImpl;
import com.powsybl.iidm.network.impl.LoadImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.impl.ZipLoadModelAdderImpl;
import com.powsybl.iidm.network.impl.util.Ref;

class LoadAdderImpl
extends AbstractInjectionAdder<LoadAdderImpl>
implements LoadAdder {
    private final VoltageLevelExt voltageLevel;
    private LoadType loadType = LoadType.UNDEFINED;
    private AbstractLoadModelImpl model;
    private double p0 = Double.NaN;
    private double q0 = Double.NaN;

    LoadAdderImpl(VoltageLevelExt voltageLevel) {
        this.voltageLevel = voltageLevel;
    }

    @Override
    protected NetworkImpl getNetwork() {
        return this.voltageLevel.getNetwork();
    }

    @Override
    protected String getTypeDescription() {
        return "Load";
    }

    public LoadAdder setLoadType(LoadType loadType) {
        this.loadType = loadType;
        return this;
    }

    public LoadAdderImpl setP0(double p0) {
        this.p0 = p0;
        return this;
    }

    public LoadAdderImpl setQ0(double q0) {
        this.q0 = q0;
        return this;
    }

    void setModel(AbstractLoadModelImpl model) {
        this.model = model;
    }

    public ZipLoadModelAdder newZipModel() {
        return new ZipLoadModelAdderImpl(this);
    }

    public ExponentialLoadModelAdder newExponentialModel() {
        return new ExponentialLoadModelAdderImpl(this);
    }

    @Override
    protected Ref<? extends VariantManagerHolder> getVariantManagerHolder() {
        return this.getNetworkRef();
    }

    private Ref<NetworkImpl> getNetworkRef() {
        return this.voltageLevel.getNetworkRef();
    }

    public LoadImpl add() {
        NetworkImpl network = this.getNetwork();
        String id = this.checkAndGetUniqueId();
        TerminalExt terminal = this.checkAndGetTerminal();
        ValidationUtil.checkLoadType((Validable)this, (LoadType)this.loadType);
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkP0((Validable)this, (double)this.p0, (ValidationLevel)network.getMinValidationLevel()));
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkQ0((Validable)this, (double)this.q0, (ValidationLevel)network.getMinValidationLevel()));
        LoadImpl load = new LoadImpl(this.getNetworkRef(), id, this.getName(), this.isFictitious(), this.loadType, this.model, this.p0, this.q0);
        if (this.model != null) {
            this.model.setLoad(load);
        }
        load.addTerminal(terminal);
        this.voltageLevel.attach(terminal, false);
        network.getIndex().checkAndAdd(load);
        network.getListeners().notifyCreation(load);
        return load;
    }
}

