/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.NetworkListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NetworkListenerList {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkListenerList.class);
    private final List<NetworkListener> listeners = new ArrayList<NetworkListener>();

    NetworkListenerList() {
    }

    void add(NetworkListener listener) {
        this.listeners.add(listener);
    }

    void remove(NetworkListener listener) {
        this.listeners.remove(listener);
    }

    void notifyUpdate(Identifiable identifiable, Supplier<String> attribute, Object oldValue, Object newValue) {
        if (!this.listeners.isEmpty() && !Objects.equals(oldValue, newValue)) {
            this.notifyListeners(identifiable, attribute.get(), oldValue, newValue);
        }
    }

    void notifyUpdate(Identifiable identifiable, String attribute, Object oldValue, Object newValue) {
        if (!this.listeners.isEmpty() && !Objects.equals(oldValue, newValue)) {
            this.notifyListeners(identifiable, attribute, oldValue, newValue);
        }
    }

    private void notifyListeners(Identifiable identifiable, String attribute, Object oldValue, Object newValue) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onUpdate(identifiable, attribute, oldValue, newValue);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    void notifyUpdate(Identifiable identifiable, Supplier<String> attribute, String variantId, Object oldValue, Object newValue) {
        if (!this.listeners.isEmpty() && !Objects.equals(oldValue, newValue)) {
            this.notifyListeners(identifiable, attribute.get(), variantId, oldValue, newValue);
        }
    }

    void notifyUpdate(Identifiable identifiable, String attribute, String variantId, Object oldValue, Object newValue) {
        if (!this.listeners.isEmpty() && !Objects.equals(oldValue, newValue)) {
            this.notifyListeners(identifiable, attribute, variantId, oldValue, newValue);
        }
    }

    private void notifyListeners(Identifiable identifiable, String attribute, String variantId, Object oldValue, Object newValue) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onUpdate(identifiable, attribute, variantId, oldValue, newValue);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    void notifyCreation(Identifiable identifiable) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onCreation(identifiable);
            }
            catch (Throwable t) {
                LOGGER.error(t.toString(), t);
            }
        }
    }

    void notifyBeforeRemoval(Identifiable identifiable) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.beforeRemoval(identifiable);
            }
            catch (Throwable t) {
                LOGGER.error(t.toString(), t);
            }
        }
    }

    void notifyAfterRemoval(String id) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.afterRemoval(id);
            }
            catch (Throwable t) {
                LOGGER.error(t.toString(), t);
            }
        }
    }

    void notifyElementAdded(Identifiable<?> identifiable, Supplier<String> attribute, Object newValue) {
        if (!this.listeners.isEmpty()) {
            this.notifyElementAdded(identifiable, attribute.get(), newValue);
        }
    }

    void notifyElementAdded(Identifiable<?> identifiable, String attribute, Object newValue) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onElementAdded(identifiable, attribute, newValue);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    void notifyElementReplaced(Identifiable<?> identifiable, Supplier<String> attribute, Object oldValue, Object newValue) {
        if (!this.listeners.isEmpty() && !Objects.equals(oldValue, newValue)) {
            this.notifyElementReplaced(identifiable, attribute.get(), oldValue, newValue);
        }
    }

    void notifyElementReplaced(Identifiable<?> identifiable, String attribute, Object oldValue, Object newValue) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onElementReplaced(identifiable, attribute, oldValue, newValue);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    void notifyElementRemoved(Identifiable<?> identifiable, Supplier<String> attribute, Object oldValue) {
        if (!this.listeners.isEmpty()) {
            this.notifyElementRemoved(identifiable, attribute.get(), oldValue);
        }
    }

    void notifyElementRemoved(Identifiable<?> identifiable, String attribute, Object oldValue) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onElementRemoved(identifiable, attribute, oldValue);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    void notifyVariantCreated(String sourceVariantId, String targetVariantId) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onVariantCreated(sourceVariantId, targetVariantId);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    void notifyVariantOverwritten(String sourceVariantId, String targetVariantId) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onVariantOverwritten(sourceVariantId, targetVariantId);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }

    void notifyVariantRemoved(String variantId) {
        for (NetworkListener listener : this.listeners) {
            try {
                listener.onVariantRemoved(variantId);
            }
            catch (Exception t) {
                LOGGER.error(t.toString(), (Throwable)t);
            }
        }
    }
}

