/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.RatioTapChangerStep;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractTapChanger;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.RatioTapChangerParent;
import com.powsybl.iidm.network.impl.RatioTapChangerStepImpl;
import com.powsybl.iidm.network.impl.RegulatingPoint;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

class RatioTapChangerImpl
extends AbstractTapChanger<RatioTapChangerParent, RatioTapChangerImpl, RatioTapChangerStepImpl>
implements RatioTapChanger {
    private boolean loadTapChangingCapabilities;
    private final TDoubleArrayList targetV;

    RatioTapChangerImpl(RatioTapChangerParent parent, int lowTapPosition, List<RatioTapChangerStepImpl> steps, TerminalExt regulationTerminal, boolean loadTapChangingCapabilities, Integer tapPosition, Boolean regulating, double targetV, double targetDeadband) {
        super(parent, lowTapPosition, steps, regulationTerminal, tapPosition, regulating, targetDeadband, "ratio tap changer");
        this.loadTapChangingCapabilities = loadTapChangingCapabilities;
        int variantArraySize = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantArraySize();
        this.targetV = new TDoubleArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.targetV.add(targetV);
        }
    }

    protected void notifyUpdate(Supplier<String> attribute, Object oldValue, Object newValue) {
        this.getNetwork().getListeners().notifyUpdate(((RatioTapChangerParent)this.parent).getTransformer(), attribute, oldValue, newValue);
    }

    protected void notifyUpdate(Supplier<String> attribute, String variantId, Object oldValue, Object newValue) {
        this.getNetwork().getListeners().notifyUpdate(((RatioTapChangerParent)this.parent).getTransformer(), attribute, variantId, oldValue, newValue);
    }

    @Override
    protected RegulatingPoint createRegulatingPoint(int variantArraySize, boolean regulating) {
        return new RegulatingPoint(((RatioTapChangerParent)this.parent).getTransformer().getId(), () -> null, variantArraySize, regulating, true);
    }

    @Override
    protected Integer getRelativeNeutralPosition() {
        for (int i = 0; i < this.steps.size(); ++i) {
            RatioTapChangerStepImpl step = (RatioTapChangerStepImpl)this.steps.get(i);
            if (step.getRho() != 1.0) continue;
            return i;
        }
        return null;
    }

    public Optional<RatioTapChangerStep> getNeutralStep() {
        return this.relativeNeutralPosition != null ? Optional.of((RatioTapChangerStep)this.steps.get(this.relativeNeutralPosition)) : Optional.empty();
    }

    @Override
    public RatioTapChangerImpl setRegulating(boolean regulating) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkRatioTapChangerRegulation((Validable)this.parent, (boolean)regulating, (boolean)this.loadTapChangingCapabilities, (Terminal)this.regulatingPoint.getRegulatingTerminal(), (double)this.getTargetV(), (Network)n, (ValidationLevel)n.getMinValidationLevel());
        HashSet tapChangers = new HashSet(((RatioTapChangerParent)this.parent).getAllTapChangers());
        tapChangers.remove(((RatioTapChangerParent)this.parent).getRatioTapChanger());
        ValidationUtil.checkOnlyOneTapChangerRegulatingEnabled((Validable)this.parent, tapChangers, (boolean)regulating, (n.getMinValidationLevel().compareTo((Enum)ValidationLevel.STEADY_STATE_HYPOTHESIS) >= 0 ? 1 : 0) != 0);
        n.invalidateValidationLevel();
        return (RatioTapChangerImpl)super.setRegulating(regulating);
    }

    public boolean hasLoadTapChangingCapabilities() {
        return this.loadTapChangingCapabilities;
    }

    public RatioTapChangerImpl setLoadTapChangingCapabilities(boolean loadTapChangingCapabilities) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkRatioTapChangerRegulation((Validable)this.parent, (boolean)this.isRegulating(), (boolean)loadTapChangingCapabilities, (Terminal)this.regulatingPoint.getRegulatingTerminal(), (double)this.getTargetV(), (Network)n, (ValidationLevel)n.getMinValidationLevel());
        boolean oldValue = this.loadTapChangingCapabilities;
        this.loadTapChangingCapabilities = loadTapChangingCapabilities;
        n.invalidateValidationLevel();
        this.notifyUpdate(() -> this.getTapChangerAttribute() + ".loadTapChangingCapabilities", oldValue, loadTapChangingCapabilities);
        return this;
    }

    public double getTargetV() {
        return this.targetV.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
    }

    public RatioTapChangerImpl setTargetV(double targetV) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkRatioTapChangerRegulation((Validable)this.parent, (boolean)this.isRegulating(), (boolean)this.loadTapChangingCapabilities, (Terminal)this.regulatingPoint.getRegulatingTerminal(), (double)targetV, (Network)n, (ValidationLevel)n.getMinValidationLevel());
        int variantIndex = ((VariantManagerHolder)this.network.get()).getVariantIndex();
        double oldValue = this.targetV.set(variantIndex, targetV);
        String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate(() -> this.getTapChangerAttribute() + ".targetV", variantId, oldValue, targetV);
        return this;
    }

    @Override
    public RatioTapChangerImpl setRegulationTerminal(Terminal regulationTerminal) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkRatioTapChangerRegulation((Validable)this.parent, (boolean)this.isRegulating(), (boolean)this.loadTapChangingCapabilities, (Terminal)regulationTerminal, (double)this.getTargetV(), (Network)n, (ValidationLevel)n.getMinValidationLevel());
        n.invalidateValidationLevel();
        return (RatioTapChangerImpl)super.setRegulationTerminal(regulationTerminal);
    }

    public void remove() {
        this.regulatingPoint.remove();
        ((RatioTapChangerParent)this.parent).setRatioTapChanger(null);
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.targetV.ensureCapacity(this.targetV.size() + number);
        for (int i = 0; i < number; ++i) {
            this.targetV.add(this.targetV.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.targetV.remove(this.targetV.size() - number, number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.targetV.set(index, this.targetV.get(sourceIndex));
        }
    }

    @Override
    protected String getTapChangerAttribute() {
        return "ratio" + ((RatioTapChangerParent)this.parent).getTapChangerAttribute();
    }

    public Map<Integer, RatioTapChangerStep> getAllSteps() {
        HashMap<Integer, RatioTapChangerStep> allSteps = new HashMap<Integer, RatioTapChangerStep>();
        for (int i = 0; i < this.steps.size(); ++i) {
            allSteps.put(i + this.lowTapPosition, (RatioTapChangerStep)this.steps.get(i));
        }
        return allSteps;
    }
}

