/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.util.trove.TBooleanArrayList;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.impl.BusExt;
import com.powsybl.iidm.network.impl.MultiVariantObject;
import com.powsybl.iidm.network.impl.TerminalExt;
import gnu.trove.list.array.TIntArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RegulatingPoint
implements MultiVariantObject {
    private static final Logger LOG = LoggerFactory.getLogger(RegulatingPoint.class);
    private final String regulatedEquipmentId;
    private final Supplier<TerminalExt> localTerminalSupplier;
    private boolean useVoltageRegulation;
    private TerminalExt regulatingTerminal = null;
    private final TBooleanArrayList regulating;
    private final TIntArrayList regulationMode;

    RegulatingPoint(String regulatedEquipmentId, Supplier<TerminalExt> localTerminalSupplier, int variantArraySize, boolean regulating, boolean useVoltageRegulation) {
        this.regulatedEquipmentId = regulatedEquipmentId;
        this.localTerminalSupplier = localTerminalSupplier;
        this.useVoltageRegulation = useVoltageRegulation;
        this.regulating = new TBooleanArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.regulating.add(regulating);
        }
        this.regulationMode = null;
    }

    RegulatingPoint(String regulatedEquipmentId, Supplier<TerminalExt> localTerminalSupplier, int variantArraySize, int regulationMode, boolean useVoltageRegulation) {
        this.regulatedEquipmentId = regulatedEquipmentId;
        this.localTerminalSupplier = localTerminalSupplier;
        this.useVoltageRegulation = useVoltageRegulation;
        this.regulationMode = new TIntArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.regulationMode.add(regulationMode);
        }
        this.regulating = null;
    }

    void setRegulatingTerminal(TerminalExt regulatingTerminal) {
        if (this.regulatingTerminal != null) {
            this.regulatingTerminal.removeRegulatingPoint(this);
        }
        TerminalExt terminalExt = this.regulatingTerminal = regulatingTerminal != null ? regulatingTerminal : this.localTerminalSupplier.get();
        if (this.regulatingTerminal != null) {
            this.regulatingTerminal.setAsRegulatingPoint(this);
        }
    }

    TerminalExt getRegulatingTerminal() {
        return this.regulatingTerminal;
    }

    boolean setRegulating(int index, boolean regulating) {
        return this.regulating.set(index, regulating);
    }

    void setUseVoltageRegulation(boolean useVoltageRegulation) {
        this.useVoltageRegulation = useVoltageRegulation;
    }

    boolean isRegulating(int index) {
        return this.regulating.get(index);
    }

    int setRegulationMode(int index, int regulationMode) {
        return this.regulationMode.set(index, regulationMode);
    }

    int getRegulationMode(int index) {
        return this.regulationMode.get(index);
    }

    void removeRegulatingTerminal() {
        Objects.requireNonNull(this.regulatingTerminal);
        TerminalExt localTerminal = this.localTerminalSupplier.get();
        if (localTerminal != null && this.useVoltageRegulation) {
            BusExt bus = this.regulatingTerminal.getBusView().getBus();
            BusExt localBus = localTerminal.getBusView().getBus();
            if (bus != null && bus == localBus) {
                LOG.warn("Connectable {} was a local voltage regulation point for {}. Regulation point is re-located at {}.", new Object[]{this.regulatingTerminal.getConnectable().getId(), this.regulatedEquipmentId, this.regulatedEquipmentId});
                this.regulatingTerminal = localTerminal;
                return;
            }
        }
        LOG.warn("Connectable {} was a regulation point for {}. Regulation is deactivated", (Object)this.regulatingTerminal.getConnectable().getId(), (Object)this.regulatedEquipmentId);
        this.regulatingTerminal = localTerminal;
        if (this.regulating != null) {
            this.regulating.fill(0, this.regulating.size(), false);
        }
        if (this.regulationMode != null) {
            this.regulationMode.fill(0, this.regulationMode.size(), StaticVarCompensator.RegulationMode.OFF.ordinal());
        }
    }

    void remove() {
        if (this.regulatingTerminal != null) {
            this.regulatingTerminal.removeRegulatingPoint(this);
        }
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        if (this.regulating != null) {
            this.regulating.ensureCapacity(this.regulating.size() + number);
        }
        if (this.regulationMode != null) {
            this.regulationMode.ensureCapacity(this.regulationMode.size() + number);
        }
        for (int i = 0; i < number; ++i) {
            if (this.regulating != null) {
                this.regulating.add(this.regulating.get(sourceIndex));
            }
            if (this.regulationMode == null) continue;
            this.regulationMode.add(this.regulationMode.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        if (this.regulating != null) {
            this.regulating.remove(this.regulating.size() - number, number);
        }
        if (this.regulationMode != null) {
            this.regulationMode.remove(this.regulationMode.size() - number, number);
        }
    }

    @Override
    public void deleteVariantArrayElement(int index) {
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (int index : indexes) {
            if (this.regulating != null) {
                this.regulating.set(index, this.regulating.get(sourceIndex));
            }
            if (this.regulationMode == null) continue;
            this.regulationMode.set(index, this.regulationMode.get(sourceIndex));
        }
    }
}

