/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.OperationalLimits;
import com.powsybl.iidm.network.Overload;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.BranchUtil;
import com.powsybl.iidm.network.impl.DanglingLineImpl;
import com.powsybl.iidm.network.impl.NetworkExt;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.util.Ref;
import com.powsybl.iidm.network.util.LimitViolationUtils;
import com.powsybl.iidm.network.util.TieLineUtil;
import java.util.Collection;
import java.util.Optional;

class TieLineImpl
extends AbstractIdentifiable<TieLine>
implements TieLine {
    private DanglingLineImpl danglingLine1;
    private DanglingLineImpl danglingLine2;
    private final Ref<NetworkImpl> networkRef;
    private boolean removed = false;

    @Override
    public NetworkImpl getNetwork() {
        if (this.removed) {
            throw new PowsyblException("Cannot access network of removed tie line " + this.id);
        }
        return this.networkRef.get();
    }

    public Network getParentNetwork() {
        NetworkExt subnetwork2;
        NetworkExt subnetwork1 = this.danglingLine1.getParentNetwork();
        if (subnetwork1 == (subnetwork2 = this.danglingLine2.getParentNetwork())) {
            return subnetwork1;
        }
        return this.networkRef.get();
    }

    @Override
    protected String getTypeDescription() {
        return "Tie Line";
    }

    TieLineImpl(Ref<NetworkImpl> network, String id, String name, boolean fictitious) {
        super(id, name, fictitious);
        this.networkRef = network;
    }

    void attachDanglingLines(DanglingLineImpl dl1, DanglingLineImpl dl2) {
        this.danglingLine1 = this.attach(dl1);
        this.danglingLine2 = this.attach(dl2);
    }

    private DanglingLineImpl attach(DanglingLineImpl danglingLine) {
        danglingLine.setTieLine(this);
        return danglingLine;
    }

    public String getPairingKey() {
        return Optional.ofNullable(this.danglingLine1.getPairingKey()).orElseGet(() -> this.danglingLine2.getPairingKey());
    }

    public DanglingLineImpl getDanglingLine1() {
        return this.danglingLine1;
    }

    public DanglingLineImpl getDanglingLine2() {
        return this.danglingLine2;
    }

    public DanglingLineImpl getDanglingLine(TwoSides side) {
        return BranchUtil.getFromSide(side, this::getDanglingLine1, this::getDanglingLine2);
    }

    public DanglingLine getDanglingLine(String voltageLevelId) {
        if (this.danglingLine1.getTerminal().getVoltageLevel().getId().equals(voltageLevelId)) {
            return this.danglingLine1;
        }
        if (this.danglingLine2.getTerminal().getVoltageLevel().getId().equals(voltageLevelId)) {
            return this.danglingLine2;
        }
        return null;
    }

    public double getR() {
        return TieLineUtil.getR((DanglingLine)this.danglingLine1, (DanglingLine)this.danglingLine2);
    }

    public double getX() {
        return TieLineUtil.getX((DanglingLine)this.danglingLine1, (DanglingLine)this.danglingLine2);
    }

    public double getG1() {
        return TieLineUtil.getG1((DanglingLine)this.danglingLine1, (DanglingLine)this.danglingLine2);
    }

    public double getB1() {
        return TieLineUtil.getB1((DanglingLine)this.danglingLine1, (DanglingLine)this.danglingLine2);
    }

    public double getG2() {
        return TieLineUtil.getG2((DanglingLine)this.danglingLine1, (DanglingLine)this.danglingLine2);
    }

    public double getB2() {
        return TieLineUtil.getB2((DanglingLine)this.danglingLine1, (DanglingLine)this.danglingLine2);
    }

    public void remove() {
        this.remove(false);
    }

    public void remove(boolean updateDanglingLines) {
        NetworkImpl network = this.getNetwork();
        network.getListeners().notifyBeforeRemoval(this);
        if (updateDanglingLines) {
            TieLineImpl.updateDanglingLine(this.danglingLine1);
            TieLineImpl.updateDanglingLine(this.danglingLine2);
        }
        this.danglingLine1.removeTieLine();
        this.danglingLine2.removeTieLine();
        network.getConnectedComponentsManager().invalidate();
        network.getSynchronousComponentsManager().invalidate();
        network.getIndex().remove(this);
        network.getListeners().notifyAfterRemoval(this.id);
        this.removed = true;
    }

    public TerminalExt getTerminal1() {
        return this.danglingLine1.getTerminal();
    }

    public TerminalExt getTerminal2() {
        return this.danglingLine2.getTerminal();
    }

    public Terminal getTerminal(TwoSides side) {
        return BranchUtil.getFromSide(side, this::getTerminal1, this::getTerminal2);
    }

    public Terminal getTerminal(String voltageLevelId) {
        return BranchUtil.getTerminal(voltageLevelId, this.getTerminal1(), this.getTerminal2());
    }

    public TwoSides getSide(Terminal terminal) {
        return BranchUtil.getSide(terminal, this.getTerminal1(), this.getTerminal2());
    }

    public Collection<OperationalLimits> getOperationalLimits1() {
        return this.danglingLine1.getOperationalLimits();
    }

    public Optional<CurrentLimits> getCurrentLimits1() {
        return this.danglingLine1.getCurrentLimits();
    }

    public CurrentLimits getNullableCurrentLimits1() {
        return this.getCurrentLimits1().orElse(null);
    }

    public CurrentLimitsAdder newCurrentLimits1() {
        return this.danglingLine1.newCurrentLimits();
    }

    public Optional<ApparentPowerLimits> getApparentPowerLimits1() {
        return this.danglingLine1.getApparentPowerLimits();
    }

    public ApparentPowerLimits getNullableApparentPowerLimits1() {
        return this.getApparentPowerLimits1().orElse(null);
    }

    public ApparentPowerLimitsAdder newApparentPowerLimits1() {
        return this.danglingLine1.newApparentPowerLimits();
    }

    public Collection<OperationalLimits> getOperationalLimits2() {
        return this.danglingLine2.getOperationalLimits();
    }

    public Optional<ActivePowerLimits> getActivePowerLimits1() {
        return this.danglingLine1.getActivePowerLimits();
    }

    public ActivePowerLimits getNullableActivePowerLimits1() {
        return this.getActivePowerLimits1().orElse(null);
    }

    public ActivePowerLimitsAdder newActivePowerLimits1() {
        return this.danglingLine1.newActivePowerLimits();
    }

    public Optional<CurrentLimits> getCurrentLimits2() {
        return this.danglingLine2.getCurrentLimits();
    }

    public CurrentLimits getNullableCurrentLimits2() {
        return this.getCurrentLimits2().orElse(null);
    }

    public CurrentLimitsAdder newCurrentLimits2() {
        return this.danglingLine2.newCurrentLimits();
    }

    public Optional<ApparentPowerLimits> getApparentPowerLimits2() {
        return this.danglingLine2.getApparentPowerLimits();
    }

    public ApparentPowerLimits getNullableApparentPowerLimits2() {
        return this.getApparentPowerLimits2().orElse(null);
    }

    public ApparentPowerLimitsAdder newApparentPowerLimits2() {
        return this.danglingLine2.newApparentPowerLimits();
    }

    public Optional<ActivePowerLimits> getActivePowerLimits2() {
        return this.danglingLine2.getActivePowerLimits();
    }

    public ActivePowerLimits getNullableActivePowerLimits2() {
        return this.getActivePowerLimits2().orElse(null);
    }

    public ActivePowerLimitsAdder newActivePowerLimits2() {
        return this.danglingLine2.newActivePowerLimits();
    }

    public Optional<CurrentLimits> getCurrentLimits(TwoSides side) {
        return BranchUtil.getFromSide(side, this::getCurrentLimits1, this::getCurrentLimits2);
    }

    public Optional<ActivePowerLimits> getActivePowerLimits(TwoSides side) {
        return BranchUtil.getFromSide(side, this::getActivePowerLimits1, this::getActivePowerLimits2);
    }

    public Optional<ApparentPowerLimits> getApparentPowerLimits(TwoSides side) {
        return BranchUtil.getFromSide(side, this::getApparentPowerLimits1, this::getApparentPowerLimits2);
    }

    public boolean isOverloaded() {
        return this.isOverloaded(1.0f);
    }

    public boolean isOverloaded(float limitReduction) {
        return this.checkPermanentLimit1(limitReduction, LimitType.CURRENT) || this.checkPermanentLimit2(limitReduction, LimitType.CURRENT);
    }

    public int getOverloadDuration() {
        return BranchUtil.getOverloadDuration(this.checkTemporaryLimits1(LimitType.CURRENT), this.checkTemporaryLimits2(LimitType.CURRENT));
    }

    public boolean checkPermanentLimit(TwoSides side, float limitReduction, LimitType type) {
        return BranchUtil.getFromSide(side, () -> this.checkPermanentLimit1(limitReduction, type), () -> this.checkPermanentLimit2(limitReduction, type));
    }

    public boolean checkPermanentLimit(TwoSides side, LimitType type) {
        return this.checkPermanentLimit(side, 1.0f, type);
    }

    public boolean checkPermanentLimit1(float limitReduction, LimitType type) {
        return LimitViolationUtils.checkPermanentLimit((Branch)this, (TwoSides)TwoSides.ONE, (float)limitReduction, (double)this.getValueForLimit(this.getTerminal1(), type), (LimitType)type);
    }

    public boolean checkPermanentLimit1(LimitType type) {
        return this.checkPermanentLimit1(1.0f, type);
    }

    public boolean checkPermanentLimit2(float limitReduction, LimitType type) {
        return LimitViolationUtils.checkPermanentLimit((Branch)this, (TwoSides)TwoSides.TWO, (float)limitReduction, (double)this.getValueForLimit(this.getTerminal2(), type), (LimitType)type);
    }

    public boolean checkPermanentLimit2(LimitType type) {
        return this.checkPermanentLimit2(1.0f, type);
    }

    public Overload checkTemporaryLimits(TwoSides side, float limitReduction, LimitType type) {
        return BranchUtil.getFromSide(side, () -> this.checkTemporaryLimits1(limitReduction, type), () -> this.checkTemporaryLimits2(limitReduction, type));
    }

    public Overload checkTemporaryLimits(TwoSides side, LimitType type) {
        return this.checkTemporaryLimits(side, 1.0f, type);
    }

    public Overload checkTemporaryLimits1(float limitReduction, LimitType type) {
        return LimitViolationUtils.checkTemporaryLimits((Branch)this, (TwoSides)TwoSides.ONE, (float)limitReduction, (double)this.getValueForLimit(this.getTerminal1(), type), (LimitType)type);
    }

    public Overload checkTemporaryLimits1(LimitType type) {
        return this.checkTemporaryLimits1(1.0f, type);
    }

    public Overload checkTemporaryLimits2(float limitReduction, LimitType type) {
        return LimitViolationUtils.checkTemporaryLimits((Branch)this, (TwoSides)TwoSides.TWO, (float)limitReduction, (double)this.getValueForLimit(this.getTerminal2(), type), (LimitType)type);
    }

    public Overload checkTemporaryLimits2(LimitType type) {
        return this.checkTemporaryLimits2(1.0f, type);
    }

    public double getValueForLimit(Terminal t, LimitType type) {
        return BranchUtil.getValueForLimit(t, type);
    }

    private static void updateDanglingLine(DanglingLine danglingLine) {
        if (!Double.isNaN(danglingLine.getBoundary().getP())) {
            danglingLine.setP0(-danglingLine.getBoundary().getP());
            if (danglingLine.getGeneration() != null) {
                danglingLine.getGeneration().setTargetP(0.0);
            }
        }
        if (!Double.isNaN(danglingLine.getBoundary().getQ())) {
            danglingLine.setQ0(-danglingLine.getBoundary().getQ());
            if (danglingLine.getGeneration() != null) {
                danglingLine.getGeneration().setTargetQ(0.0).setVoltageRegulationOn(false).setTargetV(Double.NaN);
            }
        }
    }
}

