/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.SlackTerminal;
import com.powsybl.iidm.network.impl.AbstractMultiVariantIdentifiableExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

public class SlackTerminalImpl
extends AbstractMultiVariantIdentifiableExtension<VoltageLevel>
implements SlackTerminal {
    private final ArrayList<Terminal> terminals = new ArrayList<Object>(Collections.nCopies(this.getVariantManagerHolder().getVariantManager().getVariantArraySize(), null));

    SlackTerminalImpl(VoltageLevel voltageLevel, Terminal terminal) {
        super(voltageLevel);
        this.setTerminal(terminal);
    }

    public Terminal getTerminal() {
        return this.terminals.get(this.getVariantIndex());
    }

    public SlackTerminal setTerminal(Terminal terminal) {
        if (terminal != null && !terminal.getVoltageLevel().equals(this.getExtendable())) {
            throw new PowsyblException("Terminal given is not in the right VoltageLevel (" + terminal.getVoltageLevel().getId() + " instead of " + ((VoltageLevel)this.getExtendable()).getId() + ")");
        }
        this.terminals.set(this.getVariantIndex(), terminal);
        return this;
    }

    public boolean isEmpty() {
        return this.terminals.stream().noneMatch(Objects::nonNull);
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.terminals.ensureCapacity(this.terminals.size() + number);
        Terminal sourceTerminal = this.terminals.get(sourceIndex);
        for (int i = 0; i < number; ++i) {
            this.terminals.add(sourceTerminal);
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        for (int i = 0; i < number; ++i) {
            this.terminals.remove(this.terminals.size() - 1);
        }
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        this.terminals.set(index, null);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        Terminal terminalSource = this.terminals.get(sourceIndex);
        for (int index : indexes) {
            this.terminals.set(index, terminalSource);
        }
    }
}

