/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.util.trove.TBooleanArrayList;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.extensions.StandbyAutomaton;
import com.powsybl.iidm.network.impl.AbstractMultiVariantIdentifiableExtension;
import gnu.trove.list.array.TDoubleArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandbyAutomatonImpl
extends AbstractMultiVariantIdentifiableExtension<StaticVarCompensator>
implements StandbyAutomaton {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandbyAutomatonImpl.class);
    private double b0;
    private final TBooleanArrayList standby;
    private final TDoubleArrayList lowVoltageSetpoint;
    private final TDoubleArrayList highVoltageSetpoint;
    private final TDoubleArrayList lowVoltageThreshold;
    private final TDoubleArrayList highVoltageThreshold;

    private static double checkB0(double b0) {
        if (Double.isNaN(b0)) {
            throw new IllegalArgumentException("b0 is invalid");
        }
        return b0;
    }

    private static void checkVoltageConfig(double lowVoltageSetpoint, double highVoltageSetpoint, double lowVoltageThreshold, double highVoltageThreshold) {
        if (Double.isNaN(lowVoltageSetpoint)) {
            throw new IllegalArgumentException("lowVoltageSetpoint is invalid");
        }
        if (Double.isNaN(highVoltageSetpoint)) {
            throw new IllegalArgumentException("highVoltageSetpoint is invalid");
        }
        if (Double.isNaN(lowVoltageThreshold)) {
            throw new IllegalArgumentException("lowVoltageThreshold is invalid");
        }
        if (Double.isNaN(highVoltageThreshold)) {
            throw new IllegalArgumentException("highVoltageThreshold is invalid");
        }
        if (lowVoltageThreshold >= highVoltageThreshold) {
            throw new IllegalArgumentException("Inconsistent low (" + lowVoltageThreshold + ") and high (" + highVoltageThreshold + ") voltage thresholds");
        }
        if (lowVoltageSetpoint < lowVoltageThreshold) {
            LOGGER.warn("Invalid low voltage setpoint {} < threshold {}", (Object)lowVoltageSetpoint, (Object)lowVoltageThreshold);
        }
        if (highVoltageSetpoint > highVoltageThreshold) {
            LOGGER.warn("Invalid high voltage setpoint {} > threshold {}", (Object)highVoltageSetpoint, (Object)highVoltageThreshold);
        }
    }

    public StandbyAutomatonImpl(StaticVarCompensator svc, double b0, boolean standby, double lowVoltageSetpoint, double highVoltageSetpoint, double lowVoltageThreshold, double highVoltageThreshold) {
        super(svc);
        int variantArraySize = this.getVariantManagerHolder().getVariantManager().getVariantArraySize();
        StandbyAutomatonImpl.checkVoltageConfig(lowVoltageSetpoint, highVoltageSetpoint, lowVoltageThreshold, highVoltageThreshold);
        this.b0 = StandbyAutomatonImpl.checkB0(b0);
        this.standby = new TBooleanArrayList(variantArraySize);
        this.lowVoltageSetpoint = new TDoubleArrayList(variantArraySize);
        this.highVoltageSetpoint = new TDoubleArrayList(variantArraySize);
        this.lowVoltageThreshold = new TDoubleArrayList(variantArraySize);
        this.highVoltageThreshold = new TDoubleArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.standby.add(standby);
            this.lowVoltageSetpoint.add(lowVoltageSetpoint);
            this.highVoltageSetpoint.add(highVoltageSetpoint);
            this.lowVoltageThreshold.add(lowVoltageThreshold);
            this.highVoltageThreshold.add(highVoltageThreshold);
        }
    }

    public boolean isStandby() {
        return this.standby.get(this.getVariantIndex());
    }

    public StandbyAutomatonImpl setStandby(boolean standby) {
        this.standby.set(this.getVariantIndex(), standby);
        return this;
    }

    public double getB0() {
        return this.b0;
    }

    public StandbyAutomatonImpl setB0(double b0) {
        this.b0 = StandbyAutomatonImpl.checkB0(b0);
        return this;
    }

    public double getHighVoltageSetpoint() {
        return this.highVoltageSetpoint.get(this.getVariantIndex());
    }

    public StandbyAutomatonImpl setHighVoltageSetpoint(double highVoltageSetpoint) {
        StandbyAutomatonImpl.checkVoltageConfig(this.lowVoltageSetpoint.get(this.getVariantIndex()), highVoltageSetpoint, this.lowVoltageThreshold.get(this.getVariantIndex()), this.highVoltageThreshold.get(this.getVariantIndex()));
        this.highVoltageSetpoint.set(this.getVariantIndex(), highVoltageSetpoint);
        return this;
    }

    public double getHighVoltageThreshold() {
        return this.highVoltageThreshold.get(this.getVariantIndex());
    }

    public StandbyAutomatonImpl setHighVoltageThreshold(double highVoltageThreshold) {
        StandbyAutomatonImpl.checkVoltageConfig(this.lowVoltageSetpoint.get(this.getVariantIndex()), this.highVoltageSetpoint.get(this.getVariantIndex()), this.lowVoltageThreshold.get(this.getVariantIndex()), highVoltageThreshold);
        this.highVoltageThreshold.set(this.getVariantIndex(), highVoltageThreshold);
        return this;
    }

    public double getLowVoltageSetpoint() {
        return this.lowVoltageSetpoint.get(this.getVariantIndex());
    }

    public StandbyAutomatonImpl setLowVoltageSetpoint(double lowVoltageSetpoint) {
        StandbyAutomatonImpl.checkVoltageConfig(lowVoltageSetpoint, this.highVoltageSetpoint.get(this.getVariantIndex()), this.lowVoltageThreshold.get(this.getVariantIndex()), this.highVoltageThreshold.get(this.getVariantIndex()));
        this.lowVoltageSetpoint.set(this.getVariantIndex(), lowVoltageSetpoint);
        return this;
    }

    public double getLowVoltageThreshold() {
        return this.lowVoltageThreshold.get(this.getVariantIndex());
    }

    public StandbyAutomatonImpl setLowVoltageThreshold(double lowVoltageThreshold) {
        StandbyAutomatonImpl.checkVoltageConfig(this.lowVoltageSetpoint.get(this.getVariantIndex()), this.highVoltageSetpoint.get(this.getVariantIndex()), lowVoltageThreshold, this.highVoltageThreshold.get(this.getVariantIndex()));
        this.lowVoltageThreshold.set(this.getVariantIndex(), lowVoltageThreshold);
        return this;
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.standby.ensureCapacity(this.standby.size() + number);
        this.lowVoltageSetpoint.ensureCapacity(this.lowVoltageSetpoint.size() + number);
        this.highVoltageSetpoint.ensureCapacity(this.highVoltageSetpoint.size() + number);
        this.lowVoltageThreshold.ensureCapacity(this.lowVoltageThreshold.size() + number);
        this.highVoltageThreshold.ensureCapacity(this.highVoltageThreshold.size() + number);
        for (int i = 0; i < number; ++i) {
            this.standby.add(this.standby.get(sourceIndex));
            this.lowVoltageSetpoint.add(this.lowVoltageSetpoint.get(sourceIndex));
            this.highVoltageSetpoint.add(this.highVoltageSetpoint.get(sourceIndex));
            this.lowVoltageThreshold.add(this.lowVoltageThreshold.get(sourceIndex));
            this.highVoltageThreshold.add(this.highVoltageThreshold.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        this.standby.remove(this.standby.size() - number, number);
        this.lowVoltageSetpoint.remove(this.lowVoltageSetpoint.size() - number, number);
        this.highVoltageSetpoint.remove(this.highVoltageSetpoint.size() - number, number);
        this.lowVoltageThreshold.remove(this.lowVoltageThreshold.size() - number, number);
        this.highVoltageThreshold.remove(this.highVoltageThreshold.size() - number, number);
    }

    @Override
    public void deleteVariantArrayElement(int i) {
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (int index : indexes) {
            this.standby.set(index, this.standby.get(sourceIndex));
            this.lowVoltageSetpoint.set(index, this.lowVoltageSetpoint.get(sourceIndex));
            this.highVoltageSetpoint.set(index, this.highVoltageSetpoint.get(sourceIndex));
            this.lowVoltageThreshold.set(index, this.lowVoltageThreshold.get(sourceIndex));
            this.highVoltageThreshold.set(index, this.highVoltageThreshold.get(sourceIndex));
        }
    }
}

