/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.extensions.AbstractExtensionAdder;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.extensions.FortescueConstants;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerFortescue;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerFortescueAdder;
import com.powsybl.iidm.network.extensions.WindingConnectionType;
import com.powsybl.iidm.network.impl.extensions.TwoWindingsTransformerFortescueImpl;
import java.util.Objects;

public class TwoWindingsTransformerFortescueAdderImpl
extends AbstractExtensionAdder<TwoWindingsTransformer, TwoWindingsTransformerFortescue>
implements TwoWindingsTransformerFortescueAdder {
    private double rz = Double.NaN;
    private double xz = Double.NaN;
    private boolean freeFluxes = true;
    private WindingConnectionType connectionType1 = FortescueConstants.DEFAULT_LEG1_CONNECTION_TYPE;
    private WindingConnectionType connectionType2 = FortescueConstants.DEFAULT_LEG2_CONNECTION_TYPE;
    private double groundingR1 = 0.0;
    private double groundingX1 = 0.0;
    private double groundingR2 = 0.0;
    private double groundingX2 = 0.0;

    public TwoWindingsTransformerFortescueAdderImpl(TwoWindingsTransformer twt) {
        super((Extendable)twt);
    }

    public Class<? super TwoWindingsTransformerFortescue> getExtensionClass() {
        return TwoWindingsTransformerFortescue.class;
    }

    protected TwoWindingsTransformerFortescueImpl createExtension(TwoWindingsTransformer twt) {
        return new TwoWindingsTransformerFortescueImpl(twt, this.rz, this.xz, this.freeFluxes, this.connectionType1, this.connectionType2, this.groundingR1, this.groundingX1, this.groundingR2, this.groundingX2);
    }

    public TwoWindingsTransformerFortescueAdderImpl withRz(double rz) {
        this.rz = rz;
        return this;
    }

    public TwoWindingsTransformerFortescueAdderImpl withXz(double xz) {
        this.xz = xz;
        return this;
    }

    public TwoWindingsTransformerFortescueAdderImpl withFreeFluxes(boolean freeFluxes) {
        this.freeFluxes = freeFluxes;
        return this;
    }

    public TwoWindingsTransformerFortescueAdderImpl withConnectionType1(WindingConnectionType connectionType1) {
        this.connectionType1 = Objects.requireNonNull(connectionType1);
        return this;
    }

    public TwoWindingsTransformerFortescueAdderImpl withConnectionType2(WindingConnectionType connectionType2) {
        this.connectionType2 = Objects.requireNonNull(connectionType2);
        return this;
    }

    public TwoWindingsTransformerFortescueAdderImpl withGroundingR1(double groundingR1) {
        this.groundingR1 = groundingR1;
        return this;
    }

    public TwoWindingsTransformerFortescueAdderImpl withGroundingX1(double groundingX1) {
        this.groundingX1 = groundingX1;
        return this;
    }

    public TwoWindingsTransformerFortescueAdderImpl withGroundingR2(double groundingR2) {
        this.groundingR2 = groundingR2;
        return this;
    }

    public TwoWindingsTransformerFortescueAdderImpl withGroundingX2(double groundingX2) {
        this.groundingX2 = groundingX2;
        return this;
    }
}

